/*
 * -showcase commandline handler; starts up Showcase.
 */

const nsIAppShellService = Components.interfaces.nsIAppShellService;
const nsISupports = Components.interfaces.nsISupports;
const nsICategoryManager = Components.interfaces.nsICategoryManager;
const nsIComponentRegistrar = Components.interfaces.nsIComponentRegistrar;
const nsICommandLine = Components.interfaces.nsICommandLine;
const nsICommandLineHandler = Components.interfaces.nsICommandLineHandler;
const nsIFactory = Components.interfaces.nsIFactory;
const nsIModule = Components.interfaces.nsIModule;
const nsIWindowWatcher = Components.interfaces.nsIWindowWatcher;


var consoleService = Components
.classes['@mozilla.org/consoleservice;1']
.getService( Components.interfaces.nsIConsoleService );

function recordMessage( message ) {
consoleService.logStringMessage("showcase: " + message + "\n");
}


/*
* Classes
*/

const showcaseHandler = {
/* nsISupports */
QueryInterface : function clh_QI(iid) {
if (iid.equals(nsICommandLineHandler) ||
iid.equals(nsIFactory) ||
iid.equals(nsISupports))
return this;

throw Components.results.NS_ERROR_NO_INTERFACE;
},

/* nsICommandLineHandler */

handle : function clh_handle(cmdLine) {
var args = new Object();
args.urlopt = false;
try {
var uristr = cmdLine.handleFlagWithParam("showcase", false);
if (uristr) {
args.urlopt = true;
args.url = uristr;
}
}
catch (e) {
}

if (args.urlopt || cmdLine.handleFlag("showcase", false)) {
var appShellClass = Components.classes[ "@mozilla.org/appshell/appShellService;1" ];
var appShellService = appShellClass.getService(nsIAppShellService);
var hiddenWin = appShellService.hiddenDOMWindow;
/*
A XULWindow man be better than a DOMWindow
var hiddenWin = appShellService.hiddenWindow;
*/

// Call showcase
showShowcase(hiddenWin);

cmdLine.preventDefault = true;

}
},

helpInfo : " -showcase Open Showcase.\n",

/* nsIFactory */

createInstance : function clh_CI(outer, iid) {
if (outer != null)
throw Components.results.NS_ERROR_NO_AGGREGATION;

return this.QueryInterface(iid);
},

lockFactory : function clh_lock(lock) {
/* no-op */
}
};

const clh_contractID = "@mozilla.org/commandlinehandler/general-startup;1?type=showcase";
const clh_CID = Components.ID("{35bcd621-c5bc-4c54-ac4e-4ea886ab2887}");
const clh_category = "c-showcase";

const showcaseHandlerModule = {
/* nsISupports */

QueryInterface : function mod_QI(iid) {
if (iid.equals(nsIModule) ||
iid.equals(nsISupports))
return this;

throw Components.results.NS_ERROR_NO_INTERFACE;
},

/* nsIModule */

getClassObject : function mod_gch(compMgr, cid, iid) {
if (cid.equals(clh_CID))
return showcaseHandler.QueryInterface(iid);

throw Components.results.NS_ERROR_NOT_REGISTERED;
},

registerSelf : function mod_regself(compMgr, fileSpec, location, type) {
compMgr.QueryInterface(nsIComponentRegistrar);

compMgr.registerFactoryLocation(clh_CID,
"showcaseHandler",
clh_contractID,
fileSpec,
location,
type);

var catMan = Components.classes["@mozilla.org/categorymanager;1"]
.getService(nsICategoryManager);
catMan.addCategoryEntry("command-line-handler",
clh_category,
clh_contractID, true, true);
},

unregisterSelf : function mod_unreg(compMgr, location, type) {
compMgr.QueryInterface(nsIComponentRegistrar);

compMgr.unregisterFactoryLocation(clh_CID, location);

var catMan = Components.classes["@mozilla.org/categorymanager;1"]
.getService(nsICategoryManager);
catMan.deleteCategoryEntry("command-line-handler", clh_category);
},

canUnload : function (compMgr) {
return true;
}
};

/* module initialisation */
function NSGetModule(comMgr, fileSpec) {
return showcaseHandlerModule;
}

function showShowcase(targetWindow) {
      var prefs = Components.classes["@mozilla.org/preferences-service;1"].
                    getService(Components.interfaces.nsIPrefService);
      prefs = prefs.getBranch("extensions.showcase.");

      // First close the window so we can keep the "last position" and "last size" values
        var wm = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
        var windowIter = wm.getEnumerator('extension:showcase');
        if (windowIter.hasMoreElements()) {
          var targetWindow = windowIter.getNext();
          if (targetWindow.wrappedJSObject) targetWindow = targetWindow.wrappedJSObject;

          if (targetWindow) {
            var shouldRefresh = false;
            if (allWindows) {
              if (!targetWindow.globalMode) {
                targetWindow.globalMode = true;
                shouldRefresh = true;
              }
            } else {
              if (targetWindow.globalMode) {
                targetWindow.globalMode = false;
                targetWindow.localTargetWindow = window;
                shouldRefresh = true;
              } else {
                if ((targetWindow.localTargetWindow && (targetWindow.localTargetWindow != window)) || 
                    (!targetWindow.localTargetWindow && (window.opener != window))) {
                  targetWindow.localTargetWindow = window;
                  shouldRefresh = true;
                }
              }
            }
            if (shouldRefresh)
              targetWindow.refreshScreen();

            targetWindow.focus();
            return;
          }
        }

      var windowHeight, windowWidth;
      var createWindowString = "chrome";
      
      var showcaseWidthType = prefs.getIntPref("windowWidth");
      var widthPercentage = parseFloat(prefs.getCharPref("windowWidthPercentage"));
      var widthModifier = prefs.getIntPref("windowWidthModifier");

      createWindowString += ",width=";

      if ((showcaseWidthType == 0) && (showcaseWidthType == 1)) {
        windowWidth = Math.floor(targetWindow.screen.availWidth * widthPercentage / 100 + widthModifier);
        createWindowString += windowWidth;
      } else { // if (showcaseWidthType == 2)
        windowWidth = prefs.getIntPref("windowLastWidth");
        createWindowString += windowWidth;
        if (windowWidth < 1) {
          windowWidth = 300;
        }
      }

      var showcaseHeightType = prefs.getIntPref("windowHeight");
      var heightPercentage = parseFloat(prefs.getCharPref("windowHeightPercentage"));
      var heightModifier = prefs.getIntPref("windowHeightModifier");

      createWindowString += ",height=";

      if ((showcaseHeightType == 0) && (showcaseHeightType == 1)) {
        windowHeight = Math.floor(targetWindow.screen.availHeight * heightPercentage / 100 + heightModifier);
        createWindowString += windowHeight;
      } else { // if (showcaseHeightType == 2)
        windowHeight = prefs.getIntPref("windowLastHeight");
        if (windowHeight < 1) {
          windowHeight = 300;
        }
        createWindowString += windowHeight;
      }
      
      if (prefs.getBoolPref("windowAttributeDialog")) {
        createWindowString += ",dialog=yes";
      } else {
        createWindowString += ",dialog=no";
      }

      if (prefs.getBoolPref("windowAttributeModal")) {
        createWindowString += ",modal=yes";
      }

      if (prefs.getBoolPref("windowAttributeAlwaysRaised")) {
        createWindowString += ",alwaysRaised";
      }

      var showcasePosition = prefs.getIntPref("windowPosition");
      if ((showcasePosition == 1) || (showcasePosition == 0) || (showcasePosition == 3)) {
        // Center on current screen
        createWindowString += ",centerscreen=yes";
      } else if (showcasePosition == 2) {
        // Remember last position
        createWindowString += ",left=" + 
         prefs.getIntPref("windowLastX") +
         ",top=" +
         prefs.getIntPref("windowLastY");
      }

      // Add "normal" parameters
      createWindowString += ",close=yes,resizable=yes";
      
      var showcaseURL = "chrome://showcase/content/showcase.xul?global=true";
      var showcaseWindow = targetWindow.openDialog(showcaseURL,
		"showcaseDialog", createWindowString, targetWindow);

      // Try to focus on new window (will fail if window is modal, but that's not an issue)
      try {
        showcaseWindow.focus();
      } catch (e) {}
}