var canvas_counter = 0;

// Tab cache
function ShowcaseTabCache(b)
{
	this.browser = b;
      this.thumb = null;
	b.showcaseCache = this;

	b.addEventListener("pageshow", this.updateListener, false);
};

ShowcaseTabCache.prototype = {

QueryInterface: function(aIID) {
	if (aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
	    aIID.equals(Components.interfaces.nsISupports))
		return this;

	throw Components.results.NS_NOINTERFACE;
},

makeThumbnail: function () {
	if (this.browser.currentURI != null &&
	    this.browser.currentURI.spec == "about:blank") {
        this.thumb = null;
		return;
	}
      if (!ShowcaseCache.activateCache) {
        this.thumb = null;
        return;
       }

  var cacheWidth, cacheHeight;

  if (this.browser.contentWindow.innerWidth > this.browser.contentWindow.innerHeight) {
    if (this.browser.contentWindow.innerWidth > ShowcaseCache.cacheSize) {
      cacheWidth = ShowcaseCache.cacheSize;
      cacheHeight = Math.floor(ShowcaseCache.cacheSize * this.browser.contentWindow.innerHeight / this.browser.contentWindow.innerWidth);
    } else {
      cacheWidth = this.browser.contentWindow.innerWidth;
      cacheHeight = this.browser.contentWindow.innerHeight;
    }
  } else {
    if (this.browser.contentWindow.innerHeight > ShowcaseCache.cacheSize) {
      cacheHeight = ShowcaseCache.cacheSize;
      cacheWidth = Math.floor(ShowcaseCache.cacheSize * this.browser.contentWindow.innerWidth / this.browser.contentWindow.innerHeight);
    } else {
      cacheWidth = this.browser.contentWindow.innerWidth;
      cacheHeight = this.browser.contentWindow.innerHeight;
    }
  }
  
  if (this.thumb == null) {
    this.thumb = document.createElementNS("http://www.w3.org/1999/xhtml", "canvas");
    this.thumb.id = "thumbcanvas" + canvas_counter++;
  }

  this.thumb.width = cacheWidth;
  this.thumb.height = cacheHeight;

  try {
    var ctx = this.thumb.getContext("2d");
    ctx.clearRect(0, 0, cacheWidth, cacheHeight);
    ctx.save();
    ctx.scale(cacheWidth/this.browser.contentWindow.innerWidth, cacheHeight/this.browser.contentWindow.innerHeight);

    ctx.drawWindow(this.browser.contentWindow, 
      this.browser.contentWindow.scrollX, 
      this.browser.contentWindow.scrollY, 
      this.browser.contentWindow.innerWidth, 
      this.browser.contentWindow.innerHeight, 
      "rgb(255,255,255)");
      ctx.restore();
  } catch (e) {
    //Paint thumbnail failed, probably because the thumbnail disappeared. Fail silently.
  }
},

updateListener: function (e) {
	var tmp = e.currentTarget.showcaseCache;
	if (tmp == null)
		return;

	tmp.makeThumbnail();
},

unload: function() {
      if (this.browser) {
  	  this.browser.removeEventListener("pageshow", this.updateListener, false);
        this.browser.showcaseCache = null;
      }
      this.browser = null;
      this.thumb = null;
}

};

var ShowcaseCache = {
  prefs: null,
  activateCache: false,
  cacheSize: 0,
  isCaching: false,

	QueryInterface: function (aIID)
	{
	if (aIID.equals(Components.interfaces.nsIPrefBranchInternal) ||
	    aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
	    aIID.equals(Components.interfaces.nsISupports))
		return this;

	throw Components.results.NS_NOINTERFACE;
	},

	observe: function (aSubject, aTopic, aData)
	{
	if (aTopic != "nsPref:changed")
		return;

	switch (aData) {
	case "extensions.showcase.cacheSize":
		ShowcaseCache.cacheSize = ShowcaseCache.prefs.getIntPref("cacheSize");
		break;
	case "extensions.showcase.activateCache":
		ShowcaseCache.activateCache = ShowcaseCache.prefs.getBoolPref("activateCache");
            if (ShowcaseCache.activateCache && !ShowcaseCache.isCaching) {
              ShowcaseCache.enableCaching();
            } else if (!ShowcaseCache.activateCache && ShowcaseCache.isCaching) {
              ShowcaseCache.disableCaching();
            }
            break;
	}
	},


    catchNewTab: function(event) {
      if (event.currentTarget != getBrowser().mPanelContainer)
        return;
      var targetPanel;
      if (event.target.childNodes[1]) {
        targetPanel = event.target.childNodes[1];
      } else {
        targetPanel = event.target;
      }

      if (!targetPanel.showcaseCache) {
        (new ShowcaseTabCache(targetPanel)).makeThumbnail();
      }
	},

     firefox2CatchNewTab: function(event) {
      var targetPanel = event.target.linkedBrowser;
      if (!targetPanel.showcaseCache) {
        (new ShowcaseTabCache(targetPanel)).makeThumbnail();
      }
     },

	catchDestroyTab: function(event) {
        if (event.relatedNode != gBrowser.mPanelContainer)
          return;
      var targetPanel;
      if (event.target.childNodes[1]) {
        targetPanel = event.target.childNodes[1];
      } else {
        targetPanel = event.target;
      }
      if (targetPanel.showcaseCache) {
        targetPanel.showcaseCache.unload();
      }
	},

     firefox2CatchDestroyTab: function(event) {
      var targetPanel = event.target.linkedBrowser;
      if (targetPanel.showcaseCache) {
        targetPanel.showcaseCache.unload();
      }
     },

	onLoad: function() {
	ShowcaseCache.prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("extensions.showcase.");
	ShowcaseCache.activateCache = ShowcaseCache.prefs.getBoolPref("activateCache");
	ShowcaseCache.cacheSize = ShowcaseCache.prefs.getIntPref("cacheSize");
      
      /*#if seamonkey*/
	Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranchInternal).addObserver("extensions.showcase.", this, false);
      /*#else*/
	Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch2).addObserver("extensions.showcase.", this, false);
      /*#endif*/

      if (ShowcaseCache.activateCache) {
        ShowcaseCache.enableCaching();
      }

      // Feature for next version
      //if (gBrowser.mTabContainer.mAllTabsPopup) {
      //  gBrowser.mTabContainer.mAllTabsPopup.addEventListener("popupshowing", ShowcaseCache.catchAllTabsPopupShowing, false);
      //}

      },

      catchAllTabsPopupShowing: function(ev) {
        showShowcaseThisWindow(ev);
        ev.preventDefault();
      },

      enableCaching: function() {
      if (ShowcaseCache.isCaching) return;
      if(typeof BrowserOpenAddonsMgr == "function") {
        gBrowser.tabContainer.addEventListener("TabOpen", ShowcaseCache.firefox2CatchNewTab, false);
        gBrowser.tabContainer.addEventListener("TabClose", ShowcaseCache.firefox2CatchDestroyTab, false);
      } else {
  	  getBrowser().mPanelContainer.addEventListener("DOMNodeInserted", ShowcaseCache.catchNewTab, false);
  	  getBrowser().mPanelContainer.addEventListener("DOMNodeRemoved", ShowcaseCache.catchDestroyTab, false);
      }

        var totalTabs = getBrowser().tabContainer.childNodes.length;
        for (var d=0; d<totalTabs; d++) {
		new ShowcaseTabCache(getBrowser().getBrowserForTab(getBrowser().tabContainer.childNodes.item(d)));
	  }
        ShowcaseCache.isCaching = true;
	},

	onUnload: function() {
      if(typeof BrowserOpenAddonsMgr == "function") {
        gBrowser.tabContainer.removeEventListener("TabOpen", ShowcaseCache.firefox2CatchNewTab, false);
        gBrowser.tabContainer.removeEventListener("TabClose", ShowcaseCache.firefox2CatchDestroyTab, false);
      } else {
        getBrowser().mPanelContainer.removeEventListener("DOMNodeInserted", ShowcaseCache.catchNewTab, false);
        getBrowser().mPanelContainer.removeEventListener("DOMNodeRemoved", ShowcaseCache.catchDestroyTab, false);
      }

      /*#if seamonkey*/
	Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranchInternal).removeObserver("extensions.showcase.", this);
      /*#else*/
	Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch2).removeObserver("extensions.showcase.", this);
      /*#endif*/

      if (ShowcaseCache.isCaching) {
        ShowcaseCache.disableCaching();
	}
     },

     disableCaching: function() {
        if (!ShowcaseCache.isCaching) return;
        var totalTabs = getBrowser().tabContainer.childNodes.length;
        for (var d=0; d<totalTabs; d++) {
		var browser = getBrowser().getBrowserForTab(getBrowser().tabContainer.childNodes.item(d));
           if (browser.showcaseCache) {
             browser.showcaseCache.unload();
           }
       }
       ShowcaseCache.isCaching = false;
     }
};

window.addEventListener("load", function(e) { ShowcaseCache.onLoad(); }, false);
window.addEventListener("unload", function(e) { ShowcaseCache.onUnload(); }, false)
