// Constants
const NUMBER_BORDER_COLORS = 12;
const ANIMATION_INTERVAL = 40;
const STATE_START = Components.interfaces.nsIWebProgressListener.STATE_START;
const STATE_STOP = Components.interfaces.nsIWebProgressListener.STATE_STOP;
const STATE_REDIRECTING= Components.interfaces.nsIWebProgressListener.STATE_REDIRECTING;
const STATE_TRANSFERRING = Components.interfaces.nsIWebProgressListener.STATE_TRANSFERRING;
const STATE_IS_DOCUMENT = Components.interfaces.nsIWebProgressListener.STATE_IS_DOCUMENT;
const STATE_IS_WINDOW = Components.interfaces.nsIWebProgressListener.STATE_IS_WINDOW;
const STATE_IS_REQUEST = Components.interfaces.nsIWebProgressListener.STATE_IS_REQUEST;
const RELOAD_FLAGS = Components.interfaces.nsIWebNavigation.LOAD_FLAGS_NONE;
const RELOAD_SKIP_CACHE_FLAGS = Components.interfaces.nsIWebNavigation.LOAD_FLAGS_BYPASS_PROXY | Components.interfaces.nsIWebNavigation.LOAD_FLAGS_BYPASS_CACHE;
const VK_SPACE = 32;
const VK_PRIOR = 33;
const VK_NEXT = 34;
const IETAB_URL = "chrome://ietab/content/reloaded.html?url=";
const SHOWCASE_SIDEBAR = "viewShowcaseSidebar";
const SHOWCASETHISWINDOW_SIDEBAR = "viewShowcaseThisWindowSidebar";
const OPTIONS_URL = "chrome://showcase/content/settings/settings.xul";
const FINDTYPE_TITLE = 0;
const FINDTYPE_LOCATION = 1;
const FINDTYPE_CONTENT = 2;
const FINDTYPE_ANY = 3;
const SCROLL_NONE = 0;
const SCROLL_VERTICAL = 1;
const SCROLL_HORIZONTAL = 2;
const CONTENTTYPE_HTML = "text/html";
const CONTENTTYPE_XHTML = "application/xhtml+xml";
const CONTENTTYPE_XUL = "application/vnd.mozilla.xul+xml";
const CACHEMODE_NOTHING = 0;
const CACHEMODE_CLEAR = 1;
const CACHEMODE_UPDATE = 2;

// Identification var
var isShowcaseWindow = true;

// Global vars
var showcaseBox;
var showcaseContentVertical;
var selectionBox;
var dropBox;
var selectionStartX;
var selectionStartY;
var selectionEndX;
var selectionEndY;
var originalSelection = new Array();
var originalGlobalMode;
var globalMode;
var topWindow;
var targetFocusWindow;
var currentAnimations = new Array();
var loadingTabTitle;
var untitledTabTitle;
var closeTabTitle;
var showcasePopupTab;
var pendingThumbnails = new Array();
var windowCurrentColor = 1;
var thumbWidth, thumbHeight;
var closingShowcase = false;
var processedWindows = new Array();
var currentCursor = null;
var showcaseOriginalTitle = null;
var tabOldStyle;
var showcaseOldBackgroundColor;
var paintThumbnailsThread;
var findPhraseNotFoundLabel;
var showOnlyCurrent =false;
var showOnlyCurrentLabel = null;
var localTargetWindow = null;
var scrollBoxObject = null;
var scrollActivated = false;
var isWaitingRefocus = false;
var lastMouseDownTab = null;
var selectTimer = null;
var selectTimerTarget = null;
var currentIconsThumbnail = null;
var thumbnailBackButtonObject = null;
var thumbnailForwardButtonObject = null;
var thumbnailReloadButtonObject = null;
var thumbnailStopButtonObject = null;

// Selection bars
var selectedTabs = new Array();
var lastFocusedTab = null;
var focusToggleSelection = false;
var focusSelectRange = false;
var focusIgnoreSelection = false;
var focusSelectIfUnselected = false;

// Search variables
var gFinder = Components.classes["@mozilla.org/embedcomp/rangefind;1"].createInstance()
                        .QueryInterface(Components.interfaces.nsIFind);
var searchCaseSensitive = false;
var searchActive = false;
var searchFindType = FINDTYPE_ANY;
var lastSearch = "";
var lastSearchFindType = FINDTYPE_ANY;
var lastSearchCaseSensitive = false;

// Configuration parameters
var coloredThumbnailsForMultipleWindows;
var paintThumbnailsAfterLoading;
var paintSelectedTabsFirst;
var thumbnailActiveAnimation;
var animationFrames;
var thumbnailIdleSizeFactor;
var thumbnailActiveSizeFactor;
var windowAttributeMaximized;
var windowAttributeFullScreen;
var windowAttributeTranslucent;
var updateThumbnailWhenContentLoaded;
var updateThumbnailWhenScroll;
var updateThumbnailWhenContentChanges;
var limitContentChangeUpdates;
var limitContentChangeUpdatesTime;
var thumbnailShowLabels;
var thumbnailLabelStyle;
var leftClickAction;
var middleClickAction;
var rightClickAction;
var showcaseCustomColors = false;
var showcaseCustomTitleColor;
var showcaseCustomBackgroundColor;
var showcaseCloseWhenBlur;
var showcaseCloseWhenParentFocus;
var showcaseCloseWhenSelect;
var showcaseCloseWhenZeroThumbnails;
var thumbnailTooltipTitle;
var thumbnailTooltipURL;
var browserChromeURL;
var showTitleStats;
var scrollType;
var thumbnailPreferredMinimumSize = 250;
var alwaysShowScrollbar;
var verticalScrollbarWidth;
var horizontalScrollbarHeight;
var useWindowZOrder;
var selectWhenMouseOver = false;
var selectWhenMouseOverDelay = 300;
var hideTabBar = false;
var synchFindBar = false;
var showOnlyCurrentByDefault = false;
var doubleClickOpen = false;
var detectBlank;
var detectIETab;
var detectPlugin;
var detectImage;
var renderingType;
var tabColorizeLabel;
var closeLastTabKeepOpen;
var dragDropExclude;
var zoomScrollIncrement;
var tabFlipping;
var findBarMode;
var thumbnailBackButton;
var thumbnailForwardButton;
var thumbnailStopButton;
var thumbnailReloadButton;
var imageThumbnailUpscale = false;

// Contextual menu actions
var loadedContextualSettings = false;
var contextualActionOpen;
var contextualActionShowcaseThis;
var contextualActionBack;
var contextualActionForward;
var contextualActionReload;
var contextualActionStop;
var contextualActionDuplicateTab;
var contextualActionDuplicateSelected;
var contextualActionMoveTab;
var contextualActionMergeSelected;
var contextualActionBookmarkPage;
var contextualActionBookmarkSelected;
var contextualActionSavePage;
var contextualActionSendPage;
var contextualActionPrint;
var contextualActionViewSource;
var contextualActionPageInfo;
var contextualActionCloseOther;
var contextualActionClose;
var contextualActionCloseTab;
var contextualActionCloseWindow;

/*#if seamonkey*/
var gPref = Components.classes["@mozilla.org/preferences-service;1"]
               .getService(Components.interfaces.nsIPrefService)
               .QueryInterface(Components.interfaces.nsIPrefBranchInternal);
/*#else*/
var gPref = Components.classes["@mozilla.org/preferences-service;1"]
               .getService(Components.interfaces.nsIPrefService)
               .QueryInterface(Components.interfaces.nsIPrefBranch2);
/*#endif*/

// Mosaic vars
var mosaicRows;
var mosaicColumns;
var mosaicWidth;
var mosaicHeight;

// Zoom vars
var inZoomMode = false;
var zoomTargetThumbnail = null;
var zoomTargetPreviousCursorStyle = null;
var previousZoomScrollX = null;
var previousZoomScrollY = null;
var zoomScrollingUp = false;
var zoomScrollingDown = false;
var zoomScrollingLeft = false;
var zoomScrollingRight = false;

// Size checked
var thumbnailBorderWidth = -1;
var thumbnailBorderHeight = -1;

// Version detector
var isFirefox3 = false;

// Observers
var windowObserver = {
  observe: function(subject,topic,data){
    switch(topic){
      case 'domwindowopened':
        subject.addEventListener("load", newWindowLoaded, false);
        break;
      case 'domwindowclosed':
        var targetProcessedWindow = getProcessedWindowForWindow(subject);
        if (targetProcessedWindow) {
          unlinkProcessedWindow(targetProcessedWindow, CACHEMODE_NOTHING);
          if ((processedWindows.length == 0) && showcaseCloseWhenZeroThumbnails) {
            closeWindow();
          } else {
            if (processedWindows.length < 1) {
              document.getElementById("emptyMessage").setAttribute("hidden", false);
            }

            if (processedWindows.length == 1) {
              updateBorders(processedWindows[0]);
            }
            updateTitle();
            refreshContent();
          }
        }
        break;
    }
  }
};

// Array helper functions
function removeAllElements(targetArray) {
  targetArray.length = 0;
}

function removeElementAt(targetArray, index) {
  targetArray.splice(index, 1);
}

function insertElementAt(targetArray, element, index) {
  targetArray.splice(index, 0, element);
}

function startup() {
  showcaseBox = document.getElementById("showcase-box");
  showcaseContentVertical = document.getElementById("showcase-content-vertical");
  selectionBox = document.getElementById("selection-box");
  dropBox = document.getElementById("drop-box");
  
  // Detect version
  var appInfo = Components.classes["@mozilla.org/xre/app-info;1"]
                        .getService(Components.interfaces.nsIXULAppInfo)
  // only if this is Firefox
  if (appInfo.ID == "{ec8030f7-c20a-464f-9b0e-13a3a9e97384}") {
    var versionChecker = Components.classes["@mozilla.org/xpcom/version-comparator;1"]
                                 .getService(Components.interfaces.nsIVersionComparator);
    // only if the app version is 3 or greater
    if (versionChecker.compare(3, appInfo.version) >= 0) {
      isFirefox3 = true;
    }
  } 

  // Guess if we want single window mode or multi window
  if (window.location.search) {
    var globalModeParameter = window.location.search.substr("?global=".length, window.location.search.length);
    globalMode = ((globalModeParameter == "true") || (globalModeParameter == "yes"));
  } else {
    globalMode = false;
  }

  originalGlobalMode = globalMode;

  // Set top window if needed
  topWindow = QueryInterface(Components.interfaces.nsIInterfaceRequestor).getInterface(Components.interfaces.nsIWebNavigation).QueryInterface(Components.interfaces.nsIDocShellTreeItem).rootTreeItem.QueryInterface(Components.interfaces.nsIInterfaceRequestor).getInterface(Components.interfaces.nsIDOMWindow);

  /*
  if (topWindow != window) {
    // We're embedded (tab or sidebar)
    if (window.top == topWindow) {
      // Sidebar
    }
  }
  */

  showcaseBox.setAttribute("focusable", "true");
  showcaseBox.focus();


  loadSettings();

  // Default settings
  showOnlyCurrent = showOnlyCurrentByDefault;

  initShowcase();

  if ((topWindow == window) && (windowAttributeFullScreen || windowAttributeMaximized)) {
    // Invoke it "later", when window is created. If we don't do this, we won't overlap the taskbar in Windows
    setTimeout(activateFullScreen, 0);
  } else {
    // Proceed
    contentStartup(thumbnailActiveAnimation);
    /*#if !seamonkey*/
    // Check synch find bar in tab mode
    if (synchFindBar && (topWindow != window.top)) {
      checkSynchFindBar(topWindow, this);
    }
    /*#endif*/
  }
}

function initShowcase() {
  // set the correct scrolling
  if (scrollType != SCROLL_NONE) {
    scrollBoxObject = showcaseContentVertical.boxObject.QueryInterface(Components.interfaces.nsIScrollBoxObject);
  } else {
    scrollBoxObject = null;
  }

  if (showcaseCustomColors) {
    showcaseOldBackgroundColor = showcaseBox.style.backgroundColor;
    showcaseBox.style.backgroundColor = showcaseCustomBackgroundColor + " !important;";

    if ((window.top != topWindow) && (tabColorizeLabel)) {
      // We're a tab, set the style...
      var tabbrowser = topWindow.getBrowser();
      for (var i = 0; i < tabbrowser.mTabContainer.childNodes.length; i++) {
        var tab = tabbrowser.mTabContainer.childNodes[i];
        if (tab.linkedBrowser.contentWindow == window) {
          setTabColor(tab, topWindow.document);
        }
      }
      window.focus();
    }
  }

  if (showcaseCloseWhenParentFocus) {
    try {
      window.opener.addEventListener("focus", showcaseParentGotFocus, true);
    } catch (e) {}
  }

//  window.addEventListener("focus", showcaseGainedFocus, false);
  window.addEventListener("blur", showcaseLostFocus, false);

  if (windowAttributeTranslucent) {
    try {
      var translucentWindowCss = window.document.createProcessingInstruction("xml-stylesheet","type=\"text/css\" href=\"chrome://showcase/skin/translucentWindow.css\"");
      window.hidden = true;
      window.document.insertBefore(translucentWindowCss, window.document.documentElement);
    } catch (e) { alert("startup - " + e); }
  }

  if (window.sidebarFindBar) {
    if (findBarMode == 0) {
      searchActive = true;
      document.getElementById("FindToolbar").hidden = false;
      document.getElementById("find-closebutton").hidden = true;
    } else if (findBarMode == 1) {
      searchActive = false;
      document.getElementById("FindToolbar").hidden = true;
      document.getElementById("find-closebutton").hidden = true;
    } else {
      document.getElementById("FindToolbar").hidden = !searchActive;
      document.getElementById("find-closebutton").hidden = false;
    }
  }
}

function showcaseParentGotFocus() {
  if (!isWaitingRefocus) {
    closeWindow();
  }
}

// To unlink a tab from the events structure
function unlinkProcessedTab(processedTab, tabWindow) {
  try {

  if (selectedTabs.indexOf(processedTab) > -1) {
    removeElementAt(selectedTabs, selectedTabs.indexOf(processedTab));
  }

  if (processedTab.showcaseCanvasBox) {
    // Remove from current animations if it's there
    if (thumbnailActiveAnimation) {
      var animationPos = currentAnimations.indexOf(processedTab.showcaseCanvasBox);
      if (animationPos > -1) {
        removeElementAt(currentAnimations, animationPos);
      }
    }

    if (currentCursor == processedTab) {
      // Select next
      var targetRow = currentCursor.showcaseRow;
      var targetColumn = currentCursor.showcaseColumn;

      if (targetColumn < mosaicColumns - 1) {
        targetColumn++;
      } else {
        targetColumn = 0;
        targetRow++;
      }
      var result = getTabAt(targetRow, targetColumn);

      if (result) {
        if (currentCursor == result) {
          // No change, go to previous
          targetRow = currentCursor.showcaseRow;
          targetColumn = currentCursor.showcaseColumn;

          if (targetColumn > 0) {
            targetColumn--;
          } else if (targetRow > 0) {
            targetRow--;
            targetColumn = mosaicColumns - 1;
          } else {
            currentCursor = null;
            targetRow = -1;
          }

          if (targetRow > -1) {
            var result = getTabAt(targetRow, targetColumn);

            if (result) {
              if (currentCursor == result) {
                currentCursor = null;
              } else {
                focusIgnoreSelection = true;
                result.showcaseCanvasBox.focus();
              }
            }
          }
        } else {
          focusIgnoreSelection = true;
          result.showcaseCanvasBox.focus();
        }
      }
    }

    // Check if it has the icons
    if ((currentIconsThumbnail != null) && (currentIconsThumbnail.showcaseTab == processedTab)) {
      hideThumbnailIcons();
      currentIconsThumbnail = null;
    }

    // Remove event listeners
    processedTab.showcaseCanvasBox.removeEventListener("focus", thumbnailFocus, false);
    processedTab.showcaseCanvasBox.removeEventListener("blur", thumbnailBlur, false);
    if (thumbnailActiveAnimation || selectWhenMouseOver || thumbnailBackButton || thumbnailForwardButton || thumbnailStopButton || thumbnailReloadButton) {
      processedTab.showcaseCanvasBox.removeEventListener("mouseover", mouseOverCanvas, false);
      processedTab.showcaseCanvasBox.removeEventListener("mouseout", mouseOutCanvas, false);
    }
    processedTab.showcaseCanvasBox.removeEventListener("mousedown", mouseDownCanvas, (topWindow != window));
    processedTab.showcaseCanvasBox.removeEventListener("mouseup", mouseUpCanvas, (topWindow != window));
    if (doubleClickOpen) {
      processedTab.showcaseCanvasBox.removeEventListener("dblclick", mouseDoubleClickCanvas, (topWindow != window));
    }

    while (processedTab.showcaseCanvasBox.hasChildNodes()) {
      processedTab.showcaseCanvasBox.removeChild(processedTab.showcaseCanvasBox.firstChild);
    }
    processedTab.showcaseCanvasBox.showcaseCanvas = undefined;
    processedTab.showcaseCanvasBox.showcaseTab = undefined;
    processedTab.showcaseCanvasBox.showcaseLabel = undefined;
    processedTab.showcaseCanvasBox.showcaseImageLabel = undefined;
    processedTab.showcaseCanvasBox.showcaseCloseButton = undefined;
    processedTab.showcaseCanvasBox = undefined;

    if (processedTab.showcaseCanvasSubBox) {
      while (processedTab.showcaseCanvasSubBox.hasChildNodes()) {
        processedTab.showcaseCanvasSubBox.removeChild(processedTab.showcaseCanvasSubBox.firstChild);
      }
      processedTab.showcaseCanvasSubBox = undefined;
    }
  }
  
  if (processedTab._scrollTimer) {
    processedTab._scrollTimer.cancel();
    processedTab._scrollTimer = undefined;
  }

  processedTab.showcaseIETab = undefined;
  processedTab.showcaseBlank = undefined;
  processedTab.showcaseEmbedded = undefined;

  if (processedTab.showcaseProgressListener) {
    processedTab.showcaseProgressListener.unloadListener();
    processedTab.showcaseProgressListener = undefined;
  }

  if (processedTab.showcaseTabEventListener) {
    try {
      processedTab.targetTab.removeEventListener("resize", processedTab.showcaseTabEventListener, false);
      processedTab.targetTab.removeEventListener("load", processedTab.showcaseTabEventListener, true);
      if (thumbnailShowLabels) {
        processedTab.tabHeader.removeEventListener("DOMAttrModified", processedTab.showcaseTabEventListener, false);
      }
      if (updateThumbnailWhenScroll) {
        processedTab.targetTab.removeEventListener("scroll", processedTab.showcaseTabEventListener, true);
      }
    } catch (e) {}
    processedTab.showcaseTabEventListener = undefined;
  }
  
  if (processedTab.showcaseCanvas) {
    processedTab.showcaseCanvas.width = 0;
    processedTab.showcaseCanvas.height = 0;
    processedTab.showcaseCanvas.showcaseCanvasBox = undefined;
    processedTab.showcaseCanvas = undefined;
  }
  
  processedTab.targetTab = undefined;
  processedTab.targetTabWindow = undefined;
  processedTab.tabHeader = undefined;

  if (tabWindow.processedTabs) {
    var position = tabWindow.processedTabs.indexOf(processedTab);
    if (position > -1) {
      removeElementAt(tabWindow.processedTabs, position);
    }
  }

  if (selectTimerTarget == processedTab) {
    selectTimer.cancel();
    selectTimerTarget = null;
  }
  } catch (e) { alert("unlinkProcessedTab: " + e); }
}

function setTabColor(tab, tabDocument) {
  var style = "-moz-appearance: none !important; color: " + showcaseCustomTitleColor + " !important;";
  // background: " + showcaseCustomBackgroundColor + " !important;";
  tabOldStyle = tab.getAttribute("style");
  tab.setAttribute("style",  tabOldStyle + style);
  var nodes = tabDocument.getAnonymousNodes(tab);
  for (var i=0; i < nodes.length; i++)
    nodes[i].style.setProperty('background-color', showcaseCustomBackgroundColor, '');
}

function restoreTabColor(tab, tabDocument) {
  tab.setAttribute("style", tabOldStyle);
  var nodes = tabDocument.getAnonymousNodes(tab);
  for (var i=0; i < nodes.length; i++)
    nodes[i].style.removeProperty ('background-color');
}


function updateBorders(targetProcessedWindow) {
  // Get selected tab
  var tabbrowser = targetProcessedWindow.targetWindow.getBrowser();
  var tabs = tabbrowser.mTabContainer.childNodes;
  var selectedTab = tabbrowser.getBrowserForTab(tabs[tabbrowser.mTabContainer.selectedIndex]);
  
  var multipleWindows = (processedWindows.length > 1);

  // Iterate array
  for (var c=0; c<targetProcessedWindow.processedTabs.length; c++) {
    var processedTab = targetProcessedWindow.processedTabs[c];
    
    if (multipleWindows && coloredThumbnailsForMultipleWindows) {
      if (processedTab.targetTab == selectedTab) {
        processedTab.showcaseCanvasBox.setAttribute("selectedtab", "true");
      } else {
        processedTab.showcaseCanvasBox.removeAttribute("selectedtab");
      }
      processedTab.showcaseCanvasSubBox.setAttribute("class", "coloredThumbnailBox" + targetProcessedWindow.showcaseColor);
    } else {
      if (processedTab.targetTab == selectedTab) {
        processedTab.showcaseCanvasBox.setAttribute("selectedtab", "true");
      } else {
        processedTab.showcaseCanvasBox.removeAttribute("selectedtab");
      }
      processedTab.showcaseCanvasSubBox.setAttribute("class", "thumbnailBox");
    }
  }
}

function updateTabBorder(processedTab, targetWindow) {
  // Get selected tab
  var tabbrowser = targetWindow.targetWindow.getBrowser();
  var tabs = tabbrowser.mTabContainer.childNodes;
  var selectedTab = tabbrowser.getBrowserForTab(tabs[tabbrowser.mTabContainer.selectedIndex]);
  
  var multipleWindows = (processedWindows.length > 1);
  if (multipleWindows && coloredThumbnailsForMultipleWindows) {
    if (processedTab.targetTab == selectedTab) {
      processedTab.showcaseCanvasBox.setAttribute("selectedtab", "true");
    } else {
      processedTab.showcaseCanvasBox.removeAttribute("selectedtab");
    }
    processedTab.showcaseCanvasSubBox.setAttribute("class", "coloredThumbnailBox" + targetWindow.showcaseColor);
  } else {
    if (processedTab.targetTab == selectedTab) {
      processedTab.showcaseCanvasBox.setAttribute("selectedtab", "true");
    } else {
      processedTab.showcaseCanvasBox.removeAttribute("selectedtab");
    }
    processedTab.showcaseCanvasSubBox.setAttribute("class", "thumbnailBox");
  }
}

function checkWindow(targetWindow, attempts) {
  try {
    if (linkWindow(targetWindow)) {
      updateTitle();
      setTimeout(refreshContent, 0);
    }
  } catch (e) {
    // Window not ready, try again later...
    if (attempts > 0) {
      setTimeout(checkWindow, 100, targetWindow, --attempts);
    } else if (processedWindows.length < 1) {
      document.getElementById("emptyMessage").setAttribute("hidden", false);
    }

  }
}

function isWindowProcessed(targetWindow) {
  var found = false;

  for (var c=0; (c<processedWindows.length)&&!found; c++) {
    if (processedWindows[c].targetWindow == targetWindow) {
      found = true;
    }
  }

  return found;
}

function getProcessedWindowForWindow(targetWindow) {
  var foundProcessedWindow;

  for (var c=0; (c<processedWindows.length)&&!foundProcessedWindow; c++) {
    if (processedWindows[c].targetWindow == targetWindow) {
      foundProcessedWindow = processedWindows[c];
    }
  }

  return foundProcessedWindow;
}

function removeProcessedWindowForWindow(targetWindow) {
  var found = false;

  for (var c=0; (c<processedWindows.length)&&!found; c++) {
    if (processedWindows[c].targetWindow == targetWindow) {
      removeElementAt(processedWindow, c);
      found = true;
    }
  }
  
  return found;
}

function linkWindow(targetWindow) {
  if (!isWindowProcessed(targetWindow)) {
      var tabbrowser = targetWindow.getBrowser();
      var currentProcessedWindow = new ProcessedWindow(targetWindow);
    // Assign window color
    currentProcessedWindow.showcaseColor = windowCurrentColor;
    windowCurrentColor++;
    if (windowCurrentColor > NUMBER_BORDER_COLORS)
      windowCurrentColor = 1;
      
      // Add listeners to tabsDOMNodeInserted
      var tabsChangeListener = new TabsChangeListener(currentProcessedWindow, this);
      tabbrowser.tabContainer.addEventListener("select", tabsChangeListener, false);
      tabbrowser.tabContainer.addEventListener("DOMNodeInserted", tabsChangeListener, false);
      tabbrowser.tabContainer.addEventListener("DOMNodeRemoved", tabsChangeListener, false); 
      currentProcessedWindow.showcaseTabsChangeListener = tabsChangeListener;

      var tabs = tabbrowser.mTabContainer.childNodes;
      var totalTabs = tabs.length;
      var selectedTab = tabbrowser.getBrowserForTab(tabs[tabbrowser.mTabContainer.selectedIndex]);

      currentProcessedWindow.showcaseLastGoodWidth = selectedTab.contentWindow.innerWidth;
      currentProcessedWindow.showcaseLastGoodHeight = selectedTab.contentWindow.innerHeight;

      // link current tabs
      for (var j = 0; j< totalTabs; j++) {
        var targetTab = tabbrowser.getBrowserForTab(tabs[j]);
        if (targetTab.contentWindow && (!targetTab.contentWindow.isShowcaseWindow && (!targetTab.contentWindow.wrappedJSObject || !targetTab.contentWindow.wrappedJSObject.isShowcaseWindow))) {
          var currentProcessedTab = new ProcessedTab(targetTab);
          var newThumbnail = createThumbnail(tabs[j], currentProcessedTab, tabbrowser, currentProcessedWindow);

          // Cache
          if (!currentProcessedTab.showcaseIETab && !currentProcessedTab.showcaseBlank && !currentProcessedTab.showcaseEmbedded) {
            if (targetWindow.ShowcaseCache.currentShowcases.length > 0) {
              // Get the biggest one
              var bestShowcase = targetWindow.ShowcaseCache.currentShowcases[0];
              
              if (targetWindow.ShowcaseCache.currentShowcases.length > 1) {
                for (var c=0; c<targetWindow.ShowcaseCache.currentShowcases.length; c++) {
                  var targetShowcase = targetWindow.ShowcaseCache.currentShowcases[c];
                  if ((targetShowcase.thumbWidth > bestShowcase.thumbWidth) && (targetShowcase.thumbHeight > bestShowcase.thumbHeight)) {
                    bestShowcase = targetShowcase;
                  }
                }
              }

              var remoteCanvas = bestShowcase.getProcessedWindowForWindow(targetWindow).processedTabs[currentProcessedWindow.processedTabs.length].showcaseCanvas;
              if (remoteCanvas) {
                currentProcessedTab.showcaseCanvas.width = remoteCanvas.width;
                currentProcessedTab.showcaseCanvas.height = remoteCanvas.height; 
                var ctx = currentProcessedTab.showcaseCanvas.getContext("2d");
                ctx.drawImage(remoteCanvas, 0, 0, currentProcessedTab.showcaseCanvas.width, currentProcessedTab.showcaseCanvas.height);
                currentProcessedTab.showcaseCanvas.showcasePainted = true;
              }
            } else if (currentProcessedTab.targetTab.showcaseCache) {
              var cache = currentProcessedTab.targetTab.showcaseCache;
              if ((cache.thumb) && (!cache.waitingRepaint)) {
                currentProcessedTab.showcaseCanvas.width = cache.thumb.width;
                currentProcessedTab.showcaseCanvas.height = cache.thumb.height; 
                var ctx = currentProcessedTab.showcaseCanvas.getContext("2d");
                //var oriCtx = cache.thumb.getContext("2d");
                ctx.drawImage(cache.thumb, 0, 0, currentProcessedTab.showcaseCanvas.width, currentProcessedTab.showcaseCanvas.height);
                currentProcessedTab.showcaseCanvas.showcasePainted = true;
              }
            }
          }

          // insert in document
          showcaseBox.insertBefore(newThumbnail, selectionBox);

          currentProcessedWindow.processedTabs.push(currentProcessedTab);

          if (thumbnailBorderWidth < 0) {
            /*
            var showcaseCanvasBox = document.getBoxObjectFor(currentProcessedTab.showcaseCanvas);
            if (showcaseCanvasBox) {
              thumbnailBorderWidth = currentProcessedTab.showcaseCanvasBox.boxObject.width - showcaseCanvasBox.width;
              thumbnailBorderHeight = currentProcessedTab.showcaseCanvasBox.boxObject.height - showcaseCanvasBox.height;
            } else {
              thumbnailBorderWidth = 3;
              thumbnailBorderHeight = 3;
            }
            */
            var externalBoxWidth = window.getComputedStyle(currentProcessedTab.showcaseCanvasBox, "width").width;
            externalBoxWidth = externalBoxWidth.replace(/px/, "");
            var externalBoxHeight = window.getComputedStyle(currentProcessedTab.showcaseCanvasBox, "height").height;
            externalBoxHeight = externalBoxHeight.replace(/px/, "");

            var internalBoxWidth = window.getComputedStyle(currentProcessedTab.showcaseCanvas, "width").width;
            internalBoxWidth = internalBoxWidth.replace(/px/, "");
            var internalBoxHeight = window.getComputedStyle(currentProcessedTab.showcaseCanvas, "height").height;
            internalBoxHeight = internalBoxHeight.replace(/px/, "");

            thumbnailBorderWidth = externalBoxWidth - internalBoxWidth;
            thumbnailBorderHeight = externalBoxHeight - internalBoxHeight;

            if (thumbnailBorderWidth < 0) thumbnailBorderWidth = 0;
            if (thumbnailBorderHeight < 0) thumbnailBorderHeight = 0;

            // Padding and border are not being computed...
            // Add the padding.
            // FIXME. This is a hack, there must be a better way to handle this.
            if (thumbnailLabelStyle == 0) {
              thumbnailBorderWidth += 8;
              thumbnailBorderHeight += 8;
            } else {
              thumbnailBorderWidth += 10;
              thumbnailBorderHeight += 10;
            }
          }
        }
      }
    processedWindows.push(currentProcessedWindow);

    // Register as window observer
    targetWindow.ShowcaseCache.addShowcase(window);

    return true;
  }
  return false;
}

// To unlink a window
function unlinkProcessedWindow(targetProcessedWindow, cacheMode) {
  try {
    var tabbrowser = targetProcessedWindow.targetWindow.getBrowser();

    // Remove listeners to tabsDOMNodeInserted
    tabbrowser.tabContainer.removeEventListener("select", targetProcessedWindow.showcaseTabsChangeListener, false); 
    tabbrowser.tabContainer.removeEventListener("DOMNodeInserted", targetProcessedWindow.showcaseTabsChangeListener, false); 
    tabbrowser.tabContainer.removeEventListener("DOMNodeRemoved", targetProcessedWindow.showcaseTabsChangeListener, false); 
    
    // Unlink tabs
    if (targetProcessedWindow.processedTabs.length > 0) {
      for (var c=targetProcessedWindow.processedTabs.length-1; c>=0; c--) {
        var targetProcessedTab = targetProcessedWindow.processedTabs[c];
        if (targetProcessedTab.showcaseCanvasBox) {
          if (targetProcessedTab.targetTab.showcaseCache) {
            if (cacheMode == CACHEMODE_CLEAR) {
              targetProcessedTab.targetTab.showcaseCache.thumb = null;
            } else if ((cacheMode == CACHEMODE_UPDATE) && (targetProcessedTab.targetTab.showcaseCache)) {
              if (targetProcessedWindow.targetWindow.ShowcaseCache.currentShowcases.length < 2) {
                if (!targetProcessedTab.targetTab.showcaseCache.thumb) {
                  targetProcessedTab.targetTab.showcaseCache.createThumbnail();
                }
                var targetThumb = targetProcessedTab.targetTab.showcaseCache.thumb;
                targetThumb.width = targetProcessedTab.showcaseCanvas.width;
                targetThumb.height  = targetProcessedTab.showcaseCanvas.height;
                var ctx = targetThumb.getContext("2d");
                ctx.drawImage(targetProcessedTab.showcaseCanvas, 0, 0, targetThumb.width, targetThumb.height);
              }
            }
          }
          showcaseBox.removeChild(targetProcessedTab.showcaseCanvasBox);
          unlinkProcessedTab(targetProcessedTab, targetProcessedWindow );
        }
      }
    }

    // Unregister
    targetProcessedWindow.targetWindow.ShowcaseCache.removeShowcase(window);

    var position = processedWindows.indexOf(targetProcessedWindow);
    if (position > -1) {
      removeElementAt(processedWindows, position);
    }
  } catch (e) {
    setTimeout(alert, 0, "UnlinkProcessedWindow - " + e);
  }
}

function unlinkShowcase(cacheMode) {
  // Reset tab style
  if (showcaseCustomColors) {
    showcaseBox.style.backgroundColor = showcaseOldBackgroundColor;
    
    if ((window.top != topWindow) && (tabColorizeLabel)) {
      // We're a tab, set the style...
      var tabbrowser = topWindow.getBrowser();
      var l = tabbrowser.tabContainer.childNodes.length;
      for (var i = 0; i < l; i++) {
        var tab = tabbrowser.mTabContainer.childNodes[i];
        if (tab.linkedBrowser.contentWindow == window) {
          // We're in a tab
          restoreTabColor(tab, topWindow.document);
        }
      }
    }
  }

  // Unload all pending variables
  try {
    unregisterObservers();
    while (processedWindows.length > 0) {
      unlinkProcessedWindow(processedWindows[0], cacheMode);
    }

    removeAllElements(currentAnimations);
    removeAllElements(pendingThumbnails);

    window.removeEventListener("resize", sizeChanged, false);
    showcaseContentVertical.removeEventListener("overflow", sizeChanged, false);
    showcaseContentVertical.removeEventListener("underflow", sizeChanged, false);
    showcaseContentVertical.removeEventListener("DOMMouseScroll", handleMouseWheel, true);
  } catch (e) {
    alert("unlinkShowcase - " + e);
  }
  
  // End selection if necessary
  endSelection();

  // Cancel selections
  if (selectTimer) {
    selectTimer.cancel();
    selectTimer = undefined;
    selectTimerTarget = undefined;
  }

  // Show tab bar if necessary
  if (hideTabBar) {
    var tabbrowser = window.top.getBrowser();
    /*#if seamonkey*/
    var tabstrip = window.top.document.getAnonymousElementByAttribute(tabbrowser,"class","tabbrowser-strip");
    /*#else*/
    var tabstrip = window.top.document.getAnonymousElementByAttribute(tabbrowser,"class","tabbrowser-tabs");
    /*#endif*/
    if (tabstrip) {
      tabstrip.collapsed=false;
    }
  }

  if (showcaseCloseWhenParentFocus) {
    try {
      window.opener.removeEventListener("focus", showcaseParentGotFocus, true);
    } catch (e) {}
  }

//  window.removeEventListener("focus", showcaseGainedFocus, false);
  window.removeEventListener("blur", showcaseLostFocus, false);

  return true; 
}

var ShowcasePrefObserver = 
{
  prefObserver : {
    refreshTimer : null,

    observe: function(subject, topic, data) {
    // subject is the nsIPrefBranch we're observing (after appropriate QI)
    // data is the name of the pref that's been changed (relative to subject)
      if(topic == "nsPref:changed") {
        if ((data != "extensions.showcase.windowLastX") &&
            (data != "extensions.showcase.windowLastY") &&
            (data != "extensions.showcase.windowLastWidth") &&
            (data != "extensions.showcase.windowLastHeight") &&
            (data != "extensions.showcase.windowLastRelativeX") &&
            (data != "extensions.showcase.windowLastRelativeY")) {
          if (this.refreshTimer == null) {
            this.refreshTimer = Components.classes["@mozilla.org/timer;1"].createInstance(Components.interfaces.nsITimer);
          }
          this.refreshTimer.cancel();
          this.refreshTimer.initWithCallback(this, 100, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
        }
      }
    },

    QueryInterface : function (aIID) {
      if (aIID.equals(Components.interfaces.nsIObserver) || 
      aIID.equals(Components.interfaces.nsITimerCallback) ||
      aIID.equals(Components.interfaces.nsISupports) ||
      aIID.equals(Components.interfaces.nsISupportsWeakReference))
        return this;
      throw Components.results.NS_NOINTERFACE;
    },

    notify: function(timer) {
      setTimeout(refreshScreen, 0);
    }
  },

  addPrefObserver : function () {
    if (!gPref) return;
    gPref.addObserver("extensions.showcase.", ShowcasePrefObserver.prefObserver, true);
  },

  removePrefObserver : function () {
    if (ShowcasePrefObserver.prefObserver.refreshTimer) {
      ShowcasePrefObserver.prefObserver.refreshTimer.cancel();
      ShowcasePrefObserver.prefObserver.refreshTimer = null;
    }

    if (!gPref) return;
    gPref.removeObserver("extensions.showcase.", ShowcasePrefObserver.prefObserver);
  }
}

function registerObservers() {
  // We want to observe click actions in our window
  addEventListener("mouseup", mouseUpWindow, (topWindow != window));
  addEventListener("dblclick", mouseDblClickWindow, (topWindow != window));
  addEventListener("keydown", windowKeyDown, false);
  addEventListener("keyup", windowKeyUp, false);

  // Add selection listener
  showcaseBox.addEventListener("mousedown", selectionBoxStart, false);
  showcaseBox.addEventListener("mouseup", selectionBoxEnd, false);
  showcaseBox.addEventListener("mouseout", boxMouseOut, false);
  showcaseBox.addEventListener("mousemove", selectionBoxCheck, false);
  showcaseBox.addEventListener("keypress", showcaseBoxCheckKey, false);

  var watcherService =
    Components.classes["@mozilla.org/embedcomp/window-watcher;1"]
      .getService(Components.interfaces.nsIWindowWatcher);
  watcherService.registerNotification(windowObserver);

  ShowcasePrefObserver.addPrefObserver();
}

function unregisterObservers() {
  // Unregister mouse listener
  removeEventListener("mouseup", mouseUpWindow, (topWindow != window));
  removeEventListener("dblclick", mouseDblClickWindow, (topWindow != window));
  removeEventListener("keydown", windowKeyDown, false);
  removeEventListener("keyup", windowKeyUp, false);

  // Add selection listener
  showcaseBox.removeEventListener("mousedown", selectionBoxStart, false);
  showcaseBox.removeEventListener("mouseup", selectionBoxEnd, false);
  showcaseBox.removeEventListener("mouseout", boxMouseOut, false);
  showcaseBox.removeEventListener("mousemove", selectionBoxCheck, false);
  showcaseBox.removeEventListener("keypress", showcaseBoxCheckKey, false);

  var watcherService =
    Components.classes["@mozilla.org/embedcomp/window-watcher;1"]
      .getService(Components.interfaces.nsIWindowWatcher);
  watcherService.unregisterNotification(windowObserver);

  ShowcasePrefObserver.removePrefObserver();
}

function loadContextualSettings() {
  // Load showcase contextual settings
  var prefsService = Components.classes["@mozilla.org/preferences-service;1"].
                getService(Components.interfaces.nsIPrefService);
  var prefs = prefsService.getBranch("extensions.showcase.");

  // Load contextual menu actions
  contextualActionOpen = prefs.getBoolPref("contextualActionOpen");
  contextualActionShowcaseThis = prefs.getBoolPref("contextualActionShowcaseThis");
  contextualActionBack = prefs.getBoolPref("contextualActionBack");
  contextualActionForward = prefs.getBoolPref("contextualActionForward");
  contextualActionReload = prefs.getBoolPref("contextualActionReload");
  contextualActionStop = prefs.getBoolPref("contextualActionStop");
  contextualActionDuplicateTab = prefs.getBoolPref("contextualActionDuplicateTab");
  contextualActionDuplicateSelected = prefs.getBoolPref("contextualActionDuplicateSelected");
  contextualActionMoveTab = prefs.getBoolPref("contextualActionMoveTab");
  contextualActionMergeSelected = prefs.getBoolPref("contextualActionMergeSelected");
  contextualActionBookmarkPage = prefs.getBoolPref("contextualActionBookmarkPage");
  contextualActionBookmarkSelected = prefs.getBoolPref("contextualActionBookmarkSelected");
  contextualActionSavePage = prefs.getBoolPref("contextualActionSavePage");
  contextualActionSendPage = prefs.getBoolPref("contextualActionSendPage");
  contextualActionPrint = prefs.getBoolPref("contextualActionPrint");
  contextualActionViewSource = prefs.getBoolPref("contextualActionViewSource");
  contextualActionPageInfo = prefs.getBoolPref("contextualActionPageInfo");
  contextualActionCloseOther = prefs.getBoolPref("contextualActionCloseOther");
  contextualActionClose = prefs.getBoolPref("contextualActionClose");
  contextualActionCloseTab = prefs.getBoolPref("contextualActionCloseTab");
  contextualActionCloseWindow = prefs.getBoolPref("contextualActionCloseWindow");

  loadedContextualSettings = true;
}

function loadSettings() {
  // Load showcase settings
  var prefsService = Components.classes["@mozilla.org/preferences-service;1"].
                getService(Components.interfaces.nsIPrefService);

  var prefsRoot = prefsService.getBranch(null);

  browserChromeURL = prefsRoot.getCharPref("browser.chromeURL");

  var prefs = prefsService.getBranch("extensions.showcase.");
  
  coloredThumbnailsForMultipleWindows = prefs.getBoolPref("coloredThumbnailsForMultipleWindows");
  paintThumbnailsAfterLoading = prefs.getBoolPref("paintThumbnailsAfterLoading");
  paintSelectedTabsFirst = prefs.getBoolPref("paintSelectedTabsFirst");
  thumbnailActiveAnimation = prefs.getBoolPref("thumbnailActiveAnimation");
  animationFrames = prefs.getIntPref("animationFrames");
  thumbnailIdleSizeFactor = parseFloat(prefs.getCharPref("thumbnailIdleSizeFactor"));
  thumbnailActiveSizeFactor = parseFloat(prefs.getCharPref("thumbnailActiveSizeFactor"));
  thumbnailShowLabels = prefs.getBoolPref("thumbnailShowLabels");
  thumbnailLabelStyle = prefs.getIntPref("thumbnailLabelStyle");
  windowAttributeFullScreen = prefs.getBoolPref("windowAttributeFullScreen");
  windowAttributeMaximized = prefs.getBoolPref("windowAttributeMaximized");
  windowAttributeTranslucent = prefs.getBoolPref("windowAttributeTranslucent");
  updateThumbnailWhenContentLoaded = prefs.getBoolPref("updateThumbnailWhenContentLoaded");
  updateThumbnailWhenScroll = prefs.getBoolPref("updateThumbnailWhenScroll");
  updateThumbnailWhenContentChanges = prefs.getBoolPref("updateThumbnailWhenContentChanges");
  limitContentChangeUpdates = prefs.getBoolPref("limitContentChangeUpdates");
  limitContentChangeUpdatesTime = prefs.getIntPref("limitContentChangeUpdatesTime");
  leftClickAction = prefs.getIntPref("leftClickAction");
  middleClickAction = prefs.getIntPref("middleClickAction");
  rightClickAction = prefs.getIntPref("rightClickAction");
  doubleClickOpen = prefs.getBoolPref("doubleClickOpen");
  thumbnailTooltipTitle = prefs.getBoolPref("thumbnailTooltipTitle");
  thumbnailTooltipURL = prefs.getBoolPref("thumbnailTooltipURL");
  closeLastTabKeepOpen = prefs.getBoolPref("closeLastTabKeepOpen");
  dragDropExclude = prefs.getIntPref("dragDropExclude");
  zoomScrollIncrement = prefs.getIntPref("zoomScrollIncrement");

  thumbnailBackButton = prefs.getBoolPref("thumbnailBackButton");
  thumbnailForwardButton = prefs.getBoolPref("thumbnailForwardButton");
  thumbnailStopButton = prefs.getBoolPref("thumbnailStopButton");
  thumbnailReloadButton = prefs.getBoolPref("thumbnailReloadButton");

  if (thumbnailActiveAnimation && (thumbnailIdleSizeFactor > thumbnailActiveSizeFactor)) {
    // if idle size is bigger than active size, then we've a mistake here... deactivate animation
    thumbnailActiveAnimation = false;
  }

  if (window != window.top) {
    // Sidebar
    showcaseCustomColors = prefs.getBoolPref("sidebarCustomColors");
    showcaseCustomBackgroundColor = prefs.getCharPref("sidebarCustomBackgroundColor");
    showcaseCloseWhenBlur = false;
    showcaseCloseWhenParentFocus = false;
    showcaseCloseWhenSelect = prefs.getBoolPref("sidebarCloseWhenSelect");
    showcaseCloseWhenZeroThumbnails = false;
    showTitleStats = prefs.getBoolPref("sidebarShowTitleStats");
    scrollType = prefs.getIntPref("sidebarScrollType");
    thumbnailPreferredMinimumSize = prefs.getIntPref("sidebarThumbnailPreferredMinimumSize");
    alwaysShowScrollbar = prefs.getBoolPref("sidebarAlwaysShowScrollbar");
    if (globalMode) {
      showOnlyCurrentByDefault = prefs.getBoolPref("sidebarShowOnlyCurrentByDefault");
    }
    selectWhenMouseOver = prefs.getBoolPref("sidebarSelectWhenMouseOver");
    selectWhenMouseOverDelay = prefs.getIntPref("sidebarSelectWhenMouseOverDelay");
    hideTabBar = prefs.getBoolPref("sidebarHideTabBar");
    tabFlipping = prefs.getBoolPref("sidebarTabFlipping");
    findBarMode = prefs.getIntPref("sidebarFindBarMode");
  } else if (window.top != topWindow) {
    // Tab
    showcaseCustomColors = prefs.getBoolPref("tabCustomColors");
    showcaseCustomTitleColor = prefs.getCharPref("tabCustomTitleColor");
    showcaseCustomBackgroundColor = prefs.getCharPref("tabCustomBackgroundColor");
    showcaseCloseWhenBlur = prefs.getBoolPref("tabCloseWhenBlur");
    showcaseCloseWhenParentFocus = false;
    showcaseCloseWhenSelect = prefs.getBoolPref("tabCloseWhenSelect");
    showcaseCloseWhenZeroThumbnails = prefs.getBoolPref("tabCloseWhenZeroThumbnails");
    showTitleStats = prefs.getBoolPref("tabShowTitleStats");
    scrollType = prefs.getIntPref("tabScrollType");
    thumbnailPreferredMinimumSize = prefs.getIntPref("tabThumbnailPreferredMinimumSize");
    alwaysShowScrollbar = prefs.getBoolPref("tabAlwaysShowScrollbar");
    if (globalMode) {
      showOnlyCurrentByDefault = prefs.getBoolPref("tabShowOnlyCurrentByDefault");
    }
    synchFindBar = prefs.getBoolPref("tabSynchFindBar");
    tabColorizeLabel = prefs.getBoolPref("tabColorizeLabel");
    tabFlipping = prefs.getBoolPref("tabTabFlipping");
  } else {
    // Window
    showcaseCustomColors = prefs.getBoolPref("windowCustomColors");
    showcaseCustomBackgroundColor = prefs.getCharPref("windowCustomBackgroundColor");
    showcaseCloseWhenBlur = prefs.getBoolPref("windowCloseWhenBlur");
    showcaseCloseWhenParentFocus = prefs.getBoolPref("windowCloseWhenParentFocus");
    showcaseCloseWhenSelect = prefs.getBoolPref("windowCloseWhenSelect");
    showcaseCloseWhenZeroThumbnails = prefs.getBoolPref("windowCloseWhenZeroThumbnails");
    showTitleStats = prefs.getBoolPref("windowShowTitleStats");
    scrollType = prefs.getIntPref("windowScrollType");
    thumbnailPreferredMinimumSize = prefs.getIntPref("windowThumbnailPreferredMinimumSize");
    alwaysShowScrollbar = prefs.getBoolPref("windowAlwaysShowScrollbar");
    if (globalMode) {
      showOnlyCurrentByDefault = prefs.getBoolPref("windowShowOnlyCurrentByDefault");
    }
    tabFlipping = prefs.getBoolPref("windowTabFlipping");
  }

  // Detection settings
  detectBlank = prefs.getBoolPref("detectBlank");
  detectIETab = prefs.getBoolPref("detectIETab");
  detectPlugin = prefs.getBoolPref("detectPlugin");
  detectImage = prefs.getBoolPref("detectImage");

  if (detectImage) {
    imageThumbnailUpscale = prefs.getBoolPref("imageThumbnailUpscale");
  }

  // Rendering type
  renderingType = prefs.getIntPref("renderingType");

  // Scrolling
  verticalScrollbarWidth = prefs.getIntPref("verticalScrollbarWidth");
  horizontalScrollbarHeight = prefs.getIntPref("horizontalScrollbarHeight");

  // Special parameters
  useWindowZOrder = prefs.getBoolPref("useWindowZOrder");
}

function activateFullScreen() {
  if (windowAttributeMaximized) {
    window.maximize();
  }
  if (windowAttributeFullScreen) {
    window.fullScreen = true;
  }
  contentStartup(thumbnailActiveAnimation);
}

function contentStartup(startAnimationThread) {
  registerObservers();

  createContent();

  window.addEventListener("resize", sizeChanged, false);
  showcaseContentVertical.addEventListener("overflow", sizeChanged, false);
  showcaseContentVertical.addEventListener("underflow", sizeChanged, false);
  showcaseContentVertical.addEventListener("DOMMouseScroll", handleMouseWheel, true);

  // Start animation thread
  if (startAnimationThread) {
    setTimeout(animationThread, ANIMATION_INTERVAL);
  }
  
  // Hide tab bar if necessary
  if (hideTabBar) {
    var tabbrowser = window.top.getBrowser();
    /*#if seamonkey*/
    var tabstrip = window.top.document.getAnonymousElementByAttribute(tabbrowser,"class","tabbrowser-strip");
    /*#else*/
    var tabstrip = window.top.document.getAnonymousElementByAttribute(tabbrowser,"class","tabbrowser-tabs");
    /*#endif*/
    if (tabstrip) {
      tabstrip.collapsed=true;
    }
  }
}

function closeWindow() {
  if (window.top != window) {
/*
    if (!closingShowcase) {
      closingShowcase = true;
      unlinkShowcase();
    }
*/
    // Sidebar
    if (originalGlobalMode) {
      window.top.toggleSidebar(SHOWCASE_SIDEBAR);
    } else {
      window.top.toggleSidebar(SHOWCASETHISWINDOW_SIDEBAR);
    }
  } else {
    window.close();
  }
}

function showcaseLostFocus(event) {
  if (event.originalTarget == window.document) {
    if (showcaseBox) {
      showcaseBox.setAttribute("windowFocused", "false");
    }
    if (showcaseCloseWhenBlur && !isWaitingRefocus) {
      closeWindow();
    }
  }
}

function showcaseGainedFocus() {
  if (showcaseBox) {
    showcaseBox.setAttribute("windowFocused", "true");
  }
}

function showcaseBrowserStop() {
  try {
    const stopFlags = nsIWebNavigation.STOP_ALL;
    window.showcasePopupTab.targetTab.webNavigation.stop(stopFlags);
  }
  catch(ex) {
  }
}

function showcaseBrowserReloadSkipCache() {
  if (selectedTabs.length < 2) {
    showcasePopupTab.targetTab.webNavigation.reload(RELOAD_SKIP_CACHE_FLAGS);
  } else {
    for (var c=0; c<selectedTabs.length; c++) {
      var currentTab = selectedTabs[c].targetTab;
      var location;
      if (currentTab.currentURI) {
        location = currentTab.currentURI.spec;
      } else {
        location = "about:blank";
      }

      if ((location != "about:blank") && (location != "")) {
        currentTab.webNavigation.reload(RELOAD_SKIP_CACHE_FLAGS);
      }
    }
  }
}

function showcaseBrowserReload() {
  if (selectedTabs.length < 2) {
    showcasePopupTab.targetTab.webNavigation.reload(RELOAD_FLAGS);
  } else {
    for (var c=0; c<selectedTabs.length; c++) {
      var currentTab = selectedTabs[c].targetTab;
      var location;
      if (currentTab.currentURI) {
        location = currentTab.currentURI.spec;
      } else {
        location = "about:blank";
      }

      if ((location != "about:blank") && (location != "")) {
        currentTab.webNavigation.reload(RELOAD_FLAGS);
      }
    }
  }
}

function showcaseAddBookmark() {
  try {
    if ("addBookmarkForBrowser" in BookmarksUtils) { // SeaMonkey
      BookmarksUtils
      .addBookmarkForBrowser(window.showcasePopupTab.targetTab.webNavigation, true);
    }
    else {
    addBookmarkForBrowser(window.showcasePopupTab.targetTab.webNavigation, false);
}
  } catch (e) {
    alert(e);
  }
}

function showcaseBookmarkSelected() {
  var tabsInfo = [];
  var currentTabInfo = { name: "", url: "", charset: null };

  for (var i = 0; i < selectedTabs.length; ++i) {
    var webNav = selectedTabs[i].targetTab.webNavigation;

    var url = webNav.currentURI.spec;
    var name = "";
    var charSet, description;
    try {
      var doc = webNav.document;
      name = doc.title || url;
      charSet = doc.characterSet;
      description = BookmarksUtils.getDescriptionFromDocument(doc);
    } catch (e) {
      name = url;
    }
    tabsInfo[i] = { name: name, url: url, charset: charSet, description: description };
    if (i == 0)
      currentTabInfo = tabsInfo[0];
  }
  /*#if seamonkey*/
  openDialog("chrome://communicator/content/bookmarks/addBookmark.xul", "",
             "centerscreen,chrome,dialog=yes,resizable=yes,dependent",
             currentTabInfo.name, currentTabInfo.url, null,
             currentTabInfo.charset, "addGroup" + ",group", tabsInfo);
  /*#else*/
  var dialogArgs = currentTabInfo;

  var showcaseBundle = document.getElementById("bundle_showcase");

  dialogArgs = { name: showcaseBundle.getString("bookmarkSelectedTabsDefault") };
  dialogArgs.bBookmarkAllTabs = true;

  dialogArgs.objGroup = tabsInfo;
  openDialog("chrome://browser/content/bookmarks/addBookmark2.xul", "",
             BROWSER_ADD_BM_FEATURES, dialogArgs);
  /*#endif*/
}

function showcaseSendLink() {
  var gHasIntegratedMailClient = ("@mozilla.org/messengercompose/composeparams;1" in Components.classes);
  var url = window.showcasePopupTab.targetTab.contentWindow.location.href;
  var title = window.showcasePopupTab.targetTab.contentWindow.document.title;
  try {
    if (!gHasIntegratedMailClient) {
      /*#if seamonkey*/
      var extProtocolSvc = Components.classes["@mozilla.org/uriloader/external-protocol-service;1"]
                                     .getService(Components.interfaces.nsIExternalProtocolService);
      var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                                .getService(Components.interfaces.nsIIOService);
      var mailto = url ? "mailto:?body="+encodeURIComponent(url)+"&subject="+encodeURIComponent(title) : "mailto:";
      var uri = ioService.newURI(mailto, null, null);

      extProtocolSvc.loadUrl(uri);
      /*#else*/
      MailIntegration.sendMessage(url, title);
      /*#endif*/
    }
    else {
        var params = Components.classes["@mozilla.org/messengercompose/composeparams;1"]
                               .createInstance(Components.interfaces.nsIMsgComposeParams);
        if (params)
        {
          params.composeFields = Components.classes['@mozilla.org/messengercompose/composefields;1']
                                           .createInstance(Components.interfaces.nsIMsgCompFields);
          if (params.composeFields)
          {
            params.composeFields.body = url;
            params.composeFields.subject = title;
            params.bodyIsLink = true;
            var composeService = Components.classes["@mozilla.org/messengercompose;1"]
                                           .getService(Components.interfaces.nsIMsgComposeService);
            if (composeService) {
              // it is possible you won't have a default identity
              // like if you've never launched mail before on a new profile.
              // see bug #196073
              try {
                params.identity = composeService.defaultIdentity;
              }
              catch (ex) {
                params.identity = null;
              }
              composeService.OpenComposeWindowWithParams(null, params);
            }
          }                                                                         
        }                                                                         
    }
  }
  catch (e) {
    alert(e);
  }
}

function showcasePrint() {
  try {
    window.showcasePopupTab.targetTab.contentWindow.print();
  } catch (e) {
    alert(e);
  }
}

function toggleShowOnlyCurrent() {
  showOnlyCurrent = !showOnlyCurrent;
  updateTitle();

  if (!showOnlyCurrent) {
    // Reset visibility
    for (var i = 0; i < processedWindows.length; i++) {
      var targetWindow =  processedWindows[i];
      for (var j = 0; j<targetWindow.processedTabs.length; j++) {
        var currentTab = targetWindow.processedTabs[j];
        currentTab.showcaseCanvasBox.hidden = false;
      }
    }
  }

  refreshContent();
}

function updateShowOnlyCurrent() {
  if (inZoomMode) {
    return;
  }

  // Set visibility
  for (var i = 0; i < processedWindows.length; i++) {
    var targetWindow =  processedWindows[i];
    var tabbrowser = targetWindow.targetWindow.getBrowser();
    var tabs = tabbrowser.mTabContainer.childNodes;
    var selectedTab = tabbrowser.getBrowserForTab(tabs[tabbrowser.mTabContainer.selectedIndex]);

    for (var j = 0; j<targetWindow.processedTabs.length; j++) {
      var currentTab = targetWindow.processedTabs[j];
      if (currentTab.targetTab != selectedTab) {
        currentTab.showcaseCanvasBox.hidden = true;
      } else {
        currentTab.showcaseCanvasBox.hidden = false;
      }
    }
  }
}

function openSelectedTab() {
  openTab(showcasePopupTab);
}

function closeOtherTabs() {
  // Create an array with all the possibilities
  var targetTabs = new Array();

  for (var c=0; (c<processedWindows.length); c++) {
    targetWindow = processedWindows[c];
    for (var d=0; (d<targetWindow.processedTabs.length); d++) {
      targetTabs.push(targetWindow.processedTabs[d]);
    }    
  }

  // Take out the selected ones
  for (var c=0; c<selectedTabs.length; c++) {
    var targetIndex = targetTabs.indexOf(selectedTabs[c]);
    if (targetIndex > -1) {
      removeElementAt(targetTabs, targetIndex);
    }
  }

  // Remove them
  closeShowcaseTabs(targetTabs);
}

function closeSelectedTabs() {
  // Close the selected tabs
  if (selectedTabs.length > 0) {
    closeShowcaseTabs(selectedTabs);
  } else if (currentCursor) {
    closeShowcaseTab(currentCursor);
  } else {
    closeShowcaseTab(showcasePopupTab);
  }
}

function closeSelectedWindow() {
  // Look for the window that has the tab
  var found = false;
  var targetProcessedWindow;
  for (var c=0; ((c<processedWindows.length) && !found); c++) {
    if (processedWindows[c].processedTabs.indexOf(showcasePopupTab) > -1) {
      targetProcessedWindow = processedWindows[c];
      found = true;
    }
  }
  if (found) {
    if ((targetProcessedWindow.targetWindow.BrowserTryToCloseWindow) && (typeof(targetProcessedWindow.targetWindow.BrowserTryToCloseWindow) == "function")) {
      targetProcessedWindow.targetWindow.BrowserTryToCloseWindow();
    } else {
      targetProcessedWindow.targetWindow.close();
    }
  }
}

function getProcessedWindowForProcessedTab(targetProcessedTab) {
  var foundProcessedTab = false;
  var returnProcessedWindow = null;

  for (var c=0; (c<processedWindows.length)&&!foundProcessedTab; c++) {
    for (var d=0; (d<processedWindows[c].processedTabs.length)&&!foundProcessedTab; d++) {
      if (targetProcessedTab == processedWindows[c].processedTabs[d]) {
        foundProcessedTab = true;
        returnProcessedWindow = processedWindows[c];
      }
    }
  }

  return returnProcessedWindow;
}

function BrowserViewSourceOfDocument(targetProcessedTab, aDocument)
{
  var docCharset;
  var pageCookie;
  var webNav;
  var targetWindow = getProcessedWindowForProcessedTab(targetProcessedTab).targetWindow;

  // Get the document charset
  docCharset = "charset=" + aDocument.characterSet;

  // Get the nsIWebNavigation associated with the document
  try {
      var win;
      var ifRequestor;

      // Get the DOMWindow for the requested document.  If the DOMWindow
      // cannot be found, then just use the content window...
      //
      // XXX:  This is a bit of a hack...
      win = aDocument.defaultView;
      if (win == targetWindow) {
        win = targetWindow.content;
      }
      ifRequestor = win.QueryInterface(Components.interfaces.nsIInterfaceRequestor);

      webNav = ifRequestor.getInterface(nsIWebNavigation);
  } catch(err) {
      // If nsIWebNavigation cannot be found, just get the one for the whole
      // window...
      webNav = targetWindow.getWebNavigation();
  }
  //
  // Get the 'PageDescriptor' for the current document. This allows the
  // view-source to access the cached copy of the content rather than
  // refetching it from the network...
  //
  try{
    var PageLoader = webNav.QueryInterface(Components.interfaces.nsIWebPageDescriptor);

    pageCookie = PageLoader.currentDescriptor;
  } catch(err) {
    // If no page descriptor is available, just use the view-source URL...
  }

  BrowserViewSourceOfURL(webNav.currentURI.spec, docCharset, pageCookie);
}

function BrowserViewSourceOfURL(url, charset, pageCookie)
{
  // try to open a view-source window while inheriting the charset (if any)
  /*#if seamonkey*/
  openDialog("chrome://navigator/content/viewSource.xul",
             "_blank",
             "all,dialog=no",
             url, charset, pageCookie);
  /*#else*/
  openDialog("chrome://global/content/viewSource.xul",
             "_blank",
             "scrollbars,resizable,chrome,dialog=no",
             url, charset, pageCookie);
  /*#endif*/
}

function BrowserPageInfo(aDocument)
{
  var args = {doc: aDocument, initialTab: null};

  /*#if seamonkey*/
  window.openDialog("chrome://navigator/content/pageInfo.xul",
                    "_blank",
                    "chrome,dialog=no",
                    args);
  /*#else*/
  var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService();
  var windowManagerInterface = windowManager.QueryInterface(Components.interfaces.nsIWindowMediator);
  var windows = windowManagerInterface.getEnumerator("Browser:page-info");

  // Check for windows matching the url
  while (windows.hasMoreElements()) {
    var currentWindow = windows.getNext();
    if (currentWindow.document.firstChild.getAttribute("relatedUrl") == aDocument.location) {
    	currentWindow.focus();
    	return;
    }
  }

  // We didn't find a matching window, so open a new one.
  window.openDialog("chrome://browser/content/pageInfo.xul", "_blank", "chrome,dialog=no", args);
  /*#endif*/
}

function getFirstCursor() {
  return getTabAt(0, 0);
}

function getLastCursor() {
  return getTabAt(mosaicRows, mosaicColumns);
}

function getTabAt(targetRow, targetColumn) {
  // Iterate...
  var found = false;
  var targetWindow;
  var targetProcessedTab = null;

  for (var c=0; ((c<processedWindows.length) && !found); c++) {
    targetWindow = processedWindows[c];
    for (var d=0; ((d<targetWindow.processedTabs.length) && !found); d++) {
      targetProcessedTab = targetWindow.processedTabs[d];
      if ((targetProcessedTab.showcaseRow == targetRow) && (targetProcessedTab.showcaseColumn == targetColumn) && !targetProcessedTab.showcaseCanvasBox.hidden) {
        found = true;
      }
    }
    /*
    // I'm not entirely sure of the function of this sentence...
    if (processedWindows[c].processedTabs.indexOf(showcasePopupTab) > -1) {
      found = true;
    }
    */
  }

  return targetProcessedTab;
}

function keyboardHome(el) {
  if (inZoomMode) {
    zoomTargetThumbnail.targetTab.contentWindow.scroll(0, 0);
    return;
  }

  if (!currentCursor) {
    var result = getFirstCursor();
    if (result) {
      result.showcaseCanvasBox.focus();
    }
  } else {
    var result = getFirstCursor();

    if (result) {
      if (el.shiftKey) {
        focusSelectRange = true;
      } else if (el.ctrlKey) {
        focusIgnoreSelection = true;
      }

      if (currentCursor == result) {
        processFocusedTab(currentCursor);
      } else {
        result.showcaseCanvasBox.focus();
      }
    }
  }
}

function keyboardEnd(el) {
  if (inZoomMode) {
    zoomTargetThumbnail.targetTab.contentWindow.scrollBy(zoomTargetThumbnail.targetTab.contentWindow.scrollMaxX - zoomTargetThumbnail.targetTab.contentWindow.scrollX, zoomTargetThumbnail.targetTab.contentWindow.scrollMaxY - zoomTargetThumbnail.targetTab.contentWindow.scrollY);
    return;
  }

  if (!currentCursor) {
    var result = getLastCursor();
    if (result) {
      result.showcaseCanvasBox.focus();
    }
  } else {
    var result = getLastCursor();

    if (result) {
      if (el.shiftKey) {
        focusSelectRange = true;
      } else if (el.ctrlKey) {
        focusIgnoreSelection = true;
      }

      if (currentCursor == result) {
        processFocusedTab(currentCursor);
      } else {
        result.showcaseCanvasBox.focus();
      }
    }
  }
}
function keyboardLeft(el) {
  if (inZoomMode) {
    zoomTargetThumbnail.targetTab.contentWindow.scrollBy(-zoomScrollIncrement, 0);
    return;
  }

  if (!currentCursor) {
    var result = getLastCursor();
    if (result) {
      result.showcaseCanvasBox.focus();
    }
  } else {
    var targetRow = currentCursor.showcaseRow;
    var targetColumn = currentCursor.showcaseColumn;

    if (targetColumn > 0) {
      targetColumn--;
    }
    var result = getTabAt(targetRow, targetColumn);

    if (result) {
      if (el.shiftKey) {
        focusSelectRange = true;
      } else if (el.ctrlKey) {
        focusIgnoreSelection = true;
      }

      if (currentCursor == result) {
        processFocusedTab(currentCursor);
      } else {
        result.showcaseCanvasBox.focus();
      }
    } else {
      var result = getLastCursor();
      if (result) {
        result.showcaseCanvasBox.focus();
      }
    }
  }
}

function keyboardRight(el) {
  if (inZoomMode) {
    zoomTargetThumbnail.targetTab.contentWindow.scrollBy(zoomScrollIncrement, 0);
    return;
  }

  if (!currentCursor) {
    var result = getFirstCursor();
    if (result) {
      result.showcaseCanvasBox.focus();
    }
  } else {
    var targetRow = currentCursor.showcaseRow;
    var targetColumn = currentCursor.showcaseColumn;

    if (targetColumn < mosaicColumns - 1) {
      targetColumn++;
    }
    var result = getTabAt(targetRow, targetColumn);

    if (result) {
      if (el.shiftKey) {
        focusSelectRange = true;
      } else if (el.ctrlKey) {
        focusIgnoreSelection = true;
      }

      if (currentCursor == result) {
        processFocusedTab(currentCursor);
      } else {
        result.showcaseCanvasBox.focus();
      }
    } else {
      var result = getFirstCursor();
      if (result) {
        result.showcaseCanvasBox.focus();
      }
    }
  }
}

function keyboardUp(el) {
  if (inZoomMode) {
    zoomTargetThumbnail.targetTab.contentWindow.scrollBy(0, -zoomScrollIncrement);
    return;
  }

  if (!currentCursor) {
    var result = getLastCursor();
    if (result) {
      currentCursor = result;
      currentCursor.showcaseCanvasBox.focus();
    }
  } else {
    var targetRow = currentCursor.showcaseRow;
    var targetColumn = currentCursor.showcaseColumn;

    if (targetRow > 0) {
      targetRow--;
    }
    var result = getTabAt(targetRow, targetColumn);

    if (result) {
      if (el.shiftKey) {
        focusSelectRange = true;
      } else if (el.ctrlKey) {
        focusIgnoreSelection = true;
      }

      if (currentCursor == result) {
        processFocusedTab(currentCursor);
      } else {
        result.showcaseCanvasBox.focus();
      }
    } else {
      var result = getLastCursor();
      if (result) {
        currentCursor = result;
        currentCursor.showcaseCanvasBox.focus();
      }
    }
  }
}

function keyboardDown(el) {
  if (inZoomMode) {
    zoomTargetThumbnail.targetTab.contentWindow.scrollBy(0, zoomScrollIncrement);
    return;
  }

  if (!currentCursor) {
    var result = getFirstCursor();
    if (result) {
      result.showcaseCanvasBox.focus();
    }
  } else {
    var targetRow = currentCursor.showcaseRow;
    var targetColumn = currentCursor.showcaseColumn;

    if (targetRow < mosaicRows - 1) {
      targetRow++;
    }
    var result = getTabAt(targetRow, targetColumn);

    if (result && (result.showcaseColumn == targetColumn)) {
      if (el.shiftKey) {
        focusSelectRange = true;
      } else if (el.ctrlKey) {
        focusIgnoreSelection = true;
      }

      if (currentCursor == result) {
        processFocusedTab(currentCursor);
      } else {
        result.showcaseCanvasBox.focus();
      }
    } else if (!result) {
      var result = getFirstCursor();
      if (result) {
        result.showcaseCanvasBox.focus();
      }
    }
  }
}

function keyboardEnter() {
  if (!currentCursor)
    return;
  openTab(currentCursor);
}

function windowKeyDown(ev) {
  if (ev.keyCode == VK_SPACE) {
    if (!currentCursor)
      return;
    
    if (ev.ctrlKey) {
      toggleSelection(currentCursor);
    } else {
      enterZoomMode(currentCursor);
    }
  }
}

function windowKeyUp(ev) {
  if (ev.keyCode == VK_SPACE) {
    if (!currentCursor)
      return;

    if (!ev.ctrlKey) {
      leaveZoomMode();
    }
  } else if ((ev.keyCode == VK_PRIOR) && (inZoomMode)) {
    zoomTargetThumbnail.targetTab.contentWindow.scrollBy(0, -zoomTargetThumbnail.targetTab.contentWindow.innerHeight);
  } else if ((ev.keyCode == VK_NEXT) && (inZoomMode)) {
    zoomTargetThumbnail.targetTab.contentWindow.scrollBy(0, zoomTargetThumbnail.targetTab.contentWindow.innerHeight);
  }
}

function keyboardDelete() {
  if ((!currentCursor) && (selectedTabs.length == 0))
    return;

  if (inZoomMode)
    leaveZoomMode();
  
  closeSelectedTabs();
}

function toggleFullScreen() {
  if (topWindow == window) {
    window.fullScreen = !window.fullScreen;
  } else {
    topWindow.fullScreen = !topWindow.fullScreen;
  }
}

function setCanvasSize(targetCanvas, width, height) {
  targetCanvas.style.width = width+"px";
  targetCanvas.style.height = height+"px";
  targetCanvas.style.maxWidth = targetCanvas.style.width;
  targetCanvas.style.minWidth = targetCanvas.style.width;
  targetCanvas.style.maxHeight = targetCanvas.style.height;
  targetCanvas.style.minHeight = targetCanvas.style.height;
}

function setSize(targetElement,width,height) {
  targetElement.setAttribute("width", width);
  targetElement.setAttribute("height", height);

  targetElement.style.width = width+"px";
  targetElement.style.height = height+"px";
//  targetElement.style.minWidth = targetElement.style.width;
//  targetElement.style.minHeight = targetElement.style.height;
  targetElement.style.maxWidth = targetElement.style.width;
  targetElement.style.maxHeight = targetElement.style.height;
}

function createContent() {
  try {
    var windows = getTargetWindows();
    var shouldRefresh = false;

    for (var i = 0; i < windows.length; i++) {
      try {
        linkWindow(windows[i]);
        shouldRefresh = true;
      } catch (e) {
        // We failed, check window later
        setTimeout(checkWindow, 100, windows[i], 15);
      }
    }

    if (windows.length > 0) {
      document.getElementById("emptyMessage").setAttribute("hidden", true);
    } else {
      document.getElementById("emptyMessage").setAttribute("hidden", false);
      shouldRefresh = true;
    }

    for (var j=0; j<processedWindows.length; j++) {
      updateBorders(processedWindows[j]);
    }

    if (shouldRefresh) {
      updateTitle();
      //setTimeout(refreshContent, 0);
      refreshContent();
    }
  } catch (e) {
      alert("createContent - " + e);
  }
}

function newWindowLoaded(event) {
  event.currentTarget.removeEventListener("load", newWindowLoaded, false);
  setTimeout(createContent, 0);
}

function createThumbnail(targetTabHeader, targetProcessedTab, tabbrowser, tabwindow) {
  var canvasBox;

  if (thumbnailShowLabels) {
    if (thumbnailLabelStyle == 0) {
      // in a box
      canvasBox = document.getElementById('thumbnail-box-template').firstChild.cloneNode(true);
    } else if (thumbnailLabelStyle == 1) {
      canvasBox = document.getElementById('thumbnail-plain-template').firstChild.cloneNode(true);
    } else if (thumbnailLabelStyle == 2) {
      canvasBox = document.getElementById('thumbnail-plainclose-template').firstChild.cloneNode(true);
    }
  } else {
    canvasBox = document.getElementById('thumbnail-nolabel-template').firstChild.cloneNode(true);
  }
  
  var canvas = canvasBox.getElementsByTagNameNS("http://www.w3.org/1999/xhtml", "canvas").item(0);
  var subCanvasBox = canvas.parentNode;

  if (thumbnailShowLabels) {
    canvasBox.showcaseLabel = canvasBox.getElementsByTagName("label").item(0);
    canvasBox.showcaseImageLabel = canvasBox.getElementsByTagName("image").item(0);
    if (thumbnailLabelStyle == 0) {
      canvasBox.showcaseCloseButton = canvasBox.getElementsByTagName("toolbarbutton").item(0);
    } else if (thumbnailLabelStyle == 2) {
      canvasBox.showcaseCloseButton = canvasBox.getElementsByTagName("image").item(1);
    }
  }

  if (canvasBox.showcaseCloseButton) {
    canvasBox.showcaseCloseButton.targetProcessedTab = targetProcessedTab;
    canvasBox.showcaseCloseButton.addEventListener("click", mouseClickClose, true);
  }

  canvasBox.setAttribute("ondraggesture", "nsDragAndDrop.startDrag(event,thumbnailObserver)");
  if (((dragDropExclude & 1) > 0) && (canvasBox.showcaseCloseButton)) {
    canvasBox.showcaseCloseButton.setAttribute("ondraggesture", "if (selectedTabs.length < 2) event.stopPropagation();");
  }
  if ((dragDropExclude & 2) > 0) {
    subCanvasBox.setAttribute("ondraggesture", "if (selectedTabs.length < 2) event.stopPropagation();");
  }

  canvasBox.addEventListener("focus", thumbnailFocus, false);
  canvasBox.addEventListener("blur", thumbnailBlur, false);

  if (thumbnailActiveAnimation || selectWhenMouseOver || thumbnailBackButton || thumbnailForwardButton || thumbnailStopButton || thumbnailReloadButton) {
    canvasBox.addEventListener("mouseover", mouseOverCanvas, false);
    canvasBox.addEventListener("mouseout", mouseOutCanvas, false);
  }

  canvasBox.addEventListener("mousedown", mouseDownCanvas, (topWindow != window));
  canvasBox.addEventListener("mouseup", mouseUpCanvas, (topWindow != window));
  if (doubleClickOpen) {
    canvasBox.addEventListener("dblclick", mouseDoubleClickCanvas, (topWindow != window));
  }

  targetProcessedTab.showcaseCanvas = canvas;
  targetProcessedTab.showcaseCanvas.showcaseCanvasBox = canvasBox;
  targetProcessedTab.showcaseCanvasBox = canvasBox;
  targetProcessedTab.showcaseCanvasBox.showcaseCanvas = canvas;
  targetProcessedTab.showcaseCanvasBox.showcaseTab = targetProcessedTab;
  targetProcessedTab.tabHeader = targetTabHeader;

  targetProcessedTab.showcaseCanvasSubBox = subCanvasBox;

  targetProcessedTab.showcaseProgressListener = new TabProgressListener(targetProcessedTab);

  if (targetProcessedTab.targetTab.contentDocument) {
    if (targetProcessedTab.targetTab.contentDocument.URL) {
      if ((detectIETab) && (targetProcessedTab.targetTab.contentDocument.URL.substr(0, IETAB_URL.length) == IETAB_URL)) {
        targetProcessedTab.showcaseIETab = true;
        updateIEState(targetProcessedTab);
      } else if ((detectBlank) && ((targetProcessedTab.targetTab.contentDocument.URL == "") || (targetProcessedTab.targetTab.contentDocument.URL == "about:blank"))) {
        targetProcessedTab.showcaseBlank = true;
        updateBlankState(targetProcessedTab);
      }
    }
    checkEmbedding(targetProcessedTab, false);
    checkImage(targetProcessedTab);
  }

  targetProcessedTab.showcaseTabEventListener = new TabEventListener(targetProcessedTab, tabwindow, window);
  targetProcessedTab.targetTab.addEventListener("resize", targetProcessedTab.showcaseTabEventListener, false);
  targetProcessedTab.targetTab.addEventListener("load", targetProcessedTab.showcaseTabEventListener, true);
  if (thumbnailShowLabels) {
    targetProcessedTab.tabHeader.addEventListener("DOMAttrModified", targetProcessedTab.showcaseTabEventListener, false);
    if (targetTabHeader.hasAttribute("busy")) {
      targetProcessedTab.showcaseProgressListener.progressListener.isLoading = true;
      updateLoadingState(targetProcessedTab);
    }
    canvasBox.showcaseLabel.setAttribute("value", targetTabHeader.label);
    canvasBox.showcaseLabel.setAttribute("tooltiptext", targetTabHeader.label);
    canvasBox.showcaseImageLabel.setAttribute("tooltiptext", targetTabHeader.label);
    canvasBox.showcaseImageLabel.setAttribute("src", targetTabHeader.getAttribute("image"));
    canvasBox.showcaseLabel.setAttribute("crop", targetTabHeader.getAttribute("crop"));
  }

  if (updateThumbnailWhenScroll) {
    targetProcessedTab.targetTab.addEventListener("scroll", targetProcessedTab.showcaseTabEventListener, true);
  }

  targetProcessedTab.targetTabWindow = tabwindow;

  return canvasBox;
}

function showcaseSelectedWindow() {
  if (closingShowcase) {
    return;
  }
  
  // Set new target
  if (selectedTabs.length > 0) {
    localTargetWindow = selectedTabs[0].targetTabWindow.targetWindow;
  } else {
    localTargetWindow = window.showcasePopupTab.targetTabWindow.targetWindow;
  }

  // Unlink showcase
  unlinkShowcase(CACHEMODE_UPDATE);

  // Reset showcase sidebar title
  showcaseOriginalTitle = null;

  // Set new mode
  globalMode = false;
 
  // Startup...
  contentStartup(false);
}

function refreshScreen() {
  if (closingShowcase) {
    return;
  }

  // Unlink showcase
  unlinkShowcase(CACHEMODE_CLEAR);

  // Reset window color
  windowCurrentColor = 1;

  // Reset status bar
  if (scrollActivated) {
    showcaseContentVertical.removeAttribute("scrolling");
    scrollActivated = false;
  }

  // Reset margins
  thumbnailBorderWidth = -1;
  thumbnailBorderHeight = -1;

  // Reload contextual settings
  loadedContextualSettings = false;

  // Reload settings
  loadSettings();

  initShowcase();

  // Startup...
  contentStartup(false);
}

function refreshContent() {
  if (searchActive) {
    updateFind();
  } else if (showOnlyCurrent) {
    updateShowOnlyCurrent();
  }

  // Extend showcase box
  var innerBox = document.getElementById("showcase-content-horizontal");

  // Mosaic code
  if ((innerBox.boxObject.width > 100) && (innerBox.boxObject.height > 100)) {
    mosaicWidth = innerBox.boxObject.width;
    mosaicHeight = innerBox.boxObject.height;
  } else if ((showcaseBox.boxObject.width > 100) && (showcaseBox.boxObject.height > 100)){
    mosaicWidth = showcaseBox.boxObject.width;
    mosaicHeight = showcaseBox.boxObject.height;
  } else {
    if (innerBox.boxObject.width > 100) {
      mosaicWidth = innerBox.boxObject.width;
    } else {
      mosaicWidth = 100;
    }
    if (innerBox.boxObject.height > 100) {
      mosaicHeight = innerBox.boxObject.height;
    } else {
      mosaicHeight = 100;
    }
  }

  if (!inZoomMode) {
    var mosaicSizeResult = mosaicCalculateBestGrid(mosaicWidth, mosaicHeight);
    mosaicRows = mosaicSizeResult[0];
    mosaicColumns = mosaicSizeResult[1];
    thumbWidth =  Math.ceil(mosaicWidth / mosaicColumns);
    thumbHeight = Math.ceil(mosaicHeight / mosaicRows);
    
    if (scrollType == SCROLL_VERTICAL) {
      var estimatedThumbWidth = (thumbHeight - thumbnailBorderHeight) * mosaicSizeResult[2] / mosaicSizeResult[3];
      if (estimatedThumbWidth > (thumbWidth - thumbnailBorderWidth)) {
        estimatedThumbWidth = thumbWidth - thumbnailBorderWidth;
      }

      if ((estimatedThumbWidth < thumbnailPreferredMinimumSize) || alwaysShowScrollbar) {
        // Adjust width
        var newMosaicWidth = mosaicWidth;
        if (newMosaicWidth > verticalScrollbarWidth) {
          newMosaicWidth -= verticalScrollbarWidth;
        }

        var newMosaicColumns = Math.floor(newMosaicWidth / thumbnailPreferredMinimumSize);

        if (newMosaicColumns > mosaicSizeResult[4]) {
          newMosaicColumns = mosaicSizeResult[4];
        }

        if (newMosaicColumns <= 0) {
          newMosaicColumns = 1;
        }

        var newMosaicRows = Math.floor(mosaicSizeResult[4] / newMosaicColumns);
        if ((mosaicSizeResult[4] % newMosaicColumns) > 0) {
          newMosaicRows++;
        }
        newThumbWidth = Math.ceil(newMosaicWidth / newMosaicColumns);
        newThumbHeight = Math.ceil((newThumbWidth - thumbnailBorderWidth) * mosaicSizeResult[3] / mosaicSizeResult[2]) + thumbnailBorderHeight;
/*
        var newMosaicHeight = thumbHeight * mosaicRows;
        if (newMosaicHeight > mosaicHeight) {
          mosaicHeight = newMosaicHeight;
        } else {
          thumbHeight = Math.ceil(mosaicHeight / mosaicRows);
        }
*/
        var newMosaicHeight = mosaicHeight;
        if (newMosaicRows > 0)
          newMosaicHeight = newThumbHeight * newMosaicRows;

        if (((newThumbWidth - thumbnailBorderWidth) > estimatedThumbWidth) || alwaysShowScrollbar) {
          thumbWidth = newThumbWidth;
          thumbHeight = newThumbHeight;
          mosaicRows = newMosaicRows;
          mosaicColumns = newMosaicColumns;
          mosaicWidth = newMosaicWidth;
          mosaicHeight = newMosaicHeight;

          // Activate scrolling
          if (!scrollActivated) {
            scrollActivated = true;
            showcaseContentVertical.setAttribute("scrolling", "vertical");
          }
        } else if (scrollActivated) {
          scrollActivated = false;
          showcaseContentVertical.removeAttribute("scrolling");
        }
      } else if (scrollActivated) {
        scrollActivated = false;
        showcaseContentVertical.removeAttribute("scrolling");
      }
    } else if (scrollType == SCROLL_HORIZONTAL) {
      var estimatedThumbHeight = (thumbWidth - thumbnailBorderWidth) * mosaicSizeResult[3] / mosaicSizeResult[2];
      if (estimatedThumbHeight > (thumbHeight - thumbnailBorderHeight)) {
        estimatedThumbHeight = thumbHeight - thumbnailBorderHeight;
      }

      if ((estimatedThumbHeight < thumbnailPreferredMinimumSize) || alwaysShowScrollbar) {
        // Activate scrolling
        if (!scrollActivated) {
          scrollActivated = true;
          showcaseContentVertical.setAttribute("scrolling", "horizontal");
        }

        // Adjust width
        var newMosaicHeight = mosaicHeight;
        if (newMosaicHeight > horizontalScrollbarHeight) {
          newMosaicHeight -= horizontalScrollbarHeight;
        }

        var newMosaicRows = Math.floor(newMosaicHeight / thumbnailPreferredMinimumSize);

        if (newMosaicRows > mosaicSizeResult[4]) {
          newMosaicRows = mosaicSizeResult[4];
        }

        if (newMosaicRows <= 0) {
          newMosaicRows = 1;
        }

        var newMosaicColumns = Math.floor(mosaicSizeResult[4] / newMosaicRows);
        if ((mosaicSizeResult[4] % newMosaicRows) > 0) {
          newMosaicColumns++;
        }
        var newThumbHeight = Math.ceil(newMosaicHeight / newMosaicRows);
        var newThumbWidth = Math.ceil((newThumbHeight - thumbnailBorderHeight) * mosaicSizeResult[2] / mosaicSizeResult[3]) + thumbnailBorderWidth;
/*
        var newMosaicWidth = thumbWidth * mosaicColumns;
        if (newMosaicWidth > mosaicWidth) {
          mosaicWidth = newMosaicWidth;
        } else {
          thumbWidth = Math.ceil(mosaicWidth / mosaicColumns);
        }
*/
        var newMosaicWidth = mosaicWidth;
        if (newMosaicColumns > 0)
          newMosaicWidth = newThumbWidth * newMosaicColumns;

        if (((newThumbHeight - thumbnailBorderHeight) > estimatedThumbHeight) || alwaysShowScrollbar) {
          thumbWidth = newThumbWidth;
          thumbHeight = newThumbHeight;
          mosaicRows = newMosaicRows;
          mosaicColumns = newMosaicColumns;
          mosaicWidth = newMosaicWidth;
          mosaicHeight = newMosaicHeight;

          // Activate scrolling
          if (!scrollActivated) {
            scrollActivated = true;
            showcaseContentVertical.setAttribute("scrolling", "horizontal");
          }
        } else if (scrollActivated) {
          scrollActivated = false;
          showcaseContentVertical.removeAttribute("scrolling");
        }
      } else if (scrollActivated) {
        scrollActivated = false;
        showcaseContentVertical.removeAttribute("scrolling");
      }
    }
  } else {
    if (scrollActivated) {
      showcaseContentVertical.removeAttribute("scrolling");
      scrollActivated = false;
    }

    // In zoom mode, set a bit of margin to avoid errors...
    thumbWidth =  mosaicWidth;
    thumbHeight = mosaicHeight;
  }

  setSize(showcaseBox, mosaicWidth, mosaicHeight);

  updateThumbnails(thumbWidth, thumbHeight, thumbnailIdleSizeFactor / 100, thumbnailActiveSizeFactor / 100);
  mosaicRefresh();

  if (currentIconsThumbnail) {
    if (inZoomMode || (currentIconsThumbnail.hidden)) {
      hideThumbnailIcons();
    } else {
      showThumbnailIcons();
    }
  }
}

function zoomIn() {
  if (inZoomMode) return;
  if ((scrollType == SCROLL_VERTICAL) && (mosaicColumns > 1)) {
    if (!scrollActivated) mosaicWidth -= verticalScrollbarWidth;
    thumbnailPreferredMinimumSize = Math.floor(mosaicWidth / (mosaicColumns - 1));
    refreshContent();
  } else if ((scrollType == SCROLL_HORIZONTAL) && (mosaicRows > 1)) {
    if (!scrollActivated) mosaicHeight -= horizontalScrollbarHeight;
    thumbnailPreferredMinimumSize = Math.floor(mosaicHeight / (mosaicRows - 1));
    refreshContent();
  }
}

function zoomOut() {
  if (inZoomMode) return;
  if ((scrollType == SCROLL_VERTICAL) && (thumbnailPreferredMinimumSize > 10)) {
    if (!scrollActivated) mosaicWidth -= verticalScrollbarWidth;
    thumbnailPreferredMinimumSize = Math.floor(mosaicWidth / (mosaicColumns + 1));
    if (thumbnailPreferredMinimumSize < 10) thumbnailPreferredMinimumSize = 10;
    refreshContent();
  } else if ((scrollType == SCROLL_HORIZONTAL) && (thumbnailPreferredMinimumSize > 10)) {
    if (!scrollActivated) mosaicHeight -= horizontalScrollbarHeight;
    thumbnailPreferredMinimumSize = Math.floor(mosaicHeight / (mosaicRows + 1));
    if (thumbnailPreferredMinimumSize < 10) thumbnailPreferredMinimumSize = 10;
    refreshContent();
  }
}

function sizeChanged(el) {
  refreshContent();
}

function handleMouseWheel(el) {
  if (el.ctrlKey || el.shiftKey || el.altKey || el.metaKey) {
    var actualNode = el.originalTarget;
    while (actualNode != showcaseContentVertical && !actualNode.showcaseTab && actualNode.parentNode) {
      actualNode = actualNode.parentNode;
    }
    if (actualNode.showcaseTab) {
      if (el.detail == -32768) {
        actualNode.showcaseTab.targetTab.contentDocument.defaultView.scrollBy(-zoomScrollIncrement, 0);
      } else if (el.detail == 32768) {
        actualNode.showcaseTab.targetTab.contentDocument.defaultView.scrollBy(zoomScrollIncrement, 0);
      } else {
        actualNode.showcaseTab.targetTab.contentDocument.defaultView.scrollByLines(el.detail*3);
      }
    }
    el.preventDefault();
  }
}

function hiddenTabPopup(ep) {
  var tabMenu = document.getElementById("tabMenu");

  for (var i = 0; i < tabMenu.childNodes.length; i++) {
    tabMenu.childNodes[i].setAttribute("hidden", true);
  }
}

function showingTabPopup(ep) {
  if (rightClickAction != 4) {
    ep.preventDefault();
    return;
  }

  var lastSeparator = null;
  
  if (selectedTabs.length < 1) {
    if (document.popupNode.showcaseCanvasBox) {
      showcasePopupTab = document.popupNode.showcaseCanvasBox.showcaseTab;
    } else {
      showcasePopupTab = document.popupNode.showcaseTab;
    }
  } else {
    showcasePopupTab = selectedTabs[0];
  }

  if (!loadedContextualSettings) {
    loadContextualSettings();
  }

  // "Open" action
  var showMainSeparator = false;
  if (contextualActionOpen && (selectedTabs.length < 2)) {
    document.getElementById("context-opentab").setAttribute("hidden", false);
    showMainSeparator = true;
  }
  if (contextualActionShowcaseThis && globalMode && (selectedTabs.length < 2)) {
    document.getElementById("showcaseMenuItem").setAttribute("hidden", false);
    /*
    if (processedWindows.length < 2) {
      document.getElementById("cmd_showcasethis").setAttribute("disabled", true);
    } else {
      document.getElementById("cmd_showcasethis").setAttribute("disabled", false);
    }
    */
    showMainSeparator = true;
  }
  if (showMainSeparator) {
    lastSeparator = document.getElementById("openTabSeparator");
    lastSeparator.setAttribute("hidden", false);
  }

  // Navigation actions
  var showNavigationSeparator = false;
  if (selectedTabs.length < 2) {
    if (contextualActionBack) {
      document.getElementById("context-back").setAttribute("hidden", false);

      var backCommand = document.getElementById("Browser:Back");
      var backDisabled = backCommand.hasAttribute("disabled");
    
      if (backDisabled == showcasePopupTab.targetTab.canGoBack) {
        if (backDisabled)
          backCommand.removeAttribute("disabled");
        else
          backCommand.setAttribute("disabled", true);
      }

      showNavigationSeparator = true;
    }

    if (contextualActionForward) {
      document.getElementById("context-forward").setAttribute("hidden", false);

      var forwardCommand = document.getElementById("Browser:Forward");
      var forwardDisabled = forwardCommand.hasAttribute("disabled");
    
      if (forwardDisabled == showcasePopupTab.targetTab.canGoForward) {
        if (forwardDisabled)
          forwardCommand.removeAttribute("disabled");
        else
          forwardCommand.setAttribute("disabled", true);
      }

      showNavigationSeparator = true;
    }

    if (contextualActionReload) {
      document.getElementById("context-reload").setAttribute("hidden", false);

      var reloadCommand = document.getElementById("Browser:Reload");
      var location;
      if (showcasePopupTab.targetTab.currentURI) {
        location = showcasePopupTab.targetTab.currentURI.spec;
      } else {
        location = "about:blank";
      }

      if (location == "about:blank" || location == "") {
        reloadCommand.setAttribute("disabled", true);
      } else {
        reloadCommand.removeAttribute("disabled");
      }
    
      showNavigationSeparator = true;
    }

    if (contextualActionStop) {
      document.getElementById("context-stop").setAttribute("hidden", false);

      var stopCommand = document.getElementById("Browser:Stop");
      if (showcasePopupTab.showcaseProgressListener.progressListener.isLoading) {
        stopCommand.removeAttribute("disabled");
      } else {
        stopCommand.setAttribute("disabled", true);
      }
      showNavigationSeparator = true;
    }
  } else {
    if (contextualActionReload) {
      document.getElementById("context-reload").setAttribute("hidden", false);

      var activeReload = false;
      for (var c=0; (c<selectedTabs.length) && !activeReload; c++) {
        var location = selectedTabs[c].targetTab.contentDocument.URL;
        if (location != "about:blank" && location != "") {
          activeReload = true;
        }
      }

      var reloadCommand = document.getElementById("Browser:Reload");
      if (activeReload) {
        reloadCommand.removeAttribute("disabled");
      } else {
        reloadCommand.setAttribute("disabled", true);
      }
    
      showNavigationSeparator = true;
    }
  }

  if (showNavigationSeparator) {
    lastSeparator = document.getElementById("navigationSeparator");
    lastSeparator.setAttribute("hidden", false);
  }

  // Tool actions
  var showToolsSeparator = false;

  if (selectedTabs.length > 1) {
    if (contextualActionDuplicateSelected) {
      document.getElementById("duplicateSelected").setAttribute("hidden", false);
      showToolsSeparator = true;
    }

    if (contextualActionMergeSelected) {
      document.getElementById("mergeSelected").setAttribute("hidden", false);
      showToolsSeparator = true;
    }

    if (contextualActionBookmarkSelected) {
      document.getElementById("bookmarkSelectedTabs").setAttribute("hidden", false);
      showToolsSeparator = true;
    }
  } else {
    if (contextualActionBookmarkPage) {
      document.getElementById("context-bookmarkpage").setAttribute("hidden", false);
      showToolsSeparator = true;
    }
  
    if (contextualActionSavePage) {
      document.getElementById("context-savepage").setAttribute("hidden", false);
      showToolsSeparator = true;
    }
  
    if (contextualActionSendPage) {
      document.getElementById("context-sendpage").setAttribute("hidden", false);
      showToolsSeparator = true;
    }
  
    if (contextualActionPrint) {
      document.getElementById("print").setAttribute("hidden", false);
      showToolsSeparator = true;
    }

    if (contextualActionViewSource) {
      document.getElementById("viewSource").setAttribute("hidden", false);
      showToolsSeparator = true;
    }

    if (contextualActionPageInfo) {
      document.getElementById("pageInfo").setAttribute("hidden", false);
      showToolsSeparator = true;
    }

    if (contextualActionDuplicateTab) {
      document.getElementById("duplicateTab").setAttribute("hidden", false);
      showToolsSeparator = true;
    }

    if (contextualActionMoveTab) {
      document.getElementById("moveTab").setAttribute("hidden", false);
      showToolsSeparator = true;
    }
  }
  
  if (showToolsSeparator) {
    lastSeparator = document.getElementById("toolsSeparator");
    lastSeparator.setAttribute("hidden", false);
  }

  // Close actions
  var hideLastSeparator = true;

  if (selectedTabs.length < 2) {
    var found = false;
    var targetWindow;
    for (var c=0; ((c<processedWindows.length) && !found); c++) {
      if (processedWindows[c].processedTabs.indexOf(showcasePopupTab) > -1) {
        targetWindow = processedWindows[c];
        found = true;
      }
    }

    if (found) {
      // Modify popup options depending of item
      var tabbrowser = targetWindow.targetWindow.getBrowser();

      if (tabbrowser.mTabContainer.childNodes.length > 1) {
        // Hide popupclose, show popupclosetab and popupclosewindow
        if (contextualActionCloseTab) {
          document.getElementById("popupCloseTab").setAttribute("hidden", false);
          hideLastSeparator = false;
        }
        if (contextualActionCloseWindow) {
          document.getElementById("popupCloseWindow").setAttribute("hidden", false);
          hideLastSeparator = false;
        }
      } else {
        if (contextualActionCloseWindow && closeLastTabKeepOpen) {
          document.getElementById("popupCloseWindow").setAttribute("hidden", false);
          hideLastSeparator = false;
        }

        // show popupclose
        if (contextualActionClose) {
          document.getElementById("popupClose").setAttribute("hidden", false);
          hideLastSeparator = false;
        }
      }
    } else {
      // Show simple close option
        if (contextualActionCloseTab) {
          document.getElementById("popupCloseTab").setAttribute("hidden", false);
          hideLastSeparator = false;
        }
        if (contextualActionCloseWindow) {
          document.getElementById("popupCloseWindow").setAttribute("hidden", false);
          hideLastSeparator = false;
        }
    }
  } else {
    if (contextualActionClose) {
      document.getElementById("popupClose").setAttribute("hidden", false);
      hideLastSeparator = false;
    }
  }

  if (contextualActionCloseOther) {
    document.getElementById("popupCloseOther").setAttribute("hidden", false);
    hideLastSeparator = false;
  }

  if (hideLastSeparator && lastSeparator) {
    lastSeparator.setAttribute("hidden", true);
  }
}

function enterZoomMode(targetTab) {
  if (inZoomMode) {
    return;
  }

  inZoomMode = true;
  zoomTargetThumbnail = targetTab;
  zoomTargetPreviousCursorStyle = zoomTargetThumbnail.showcaseCanvas.style.cursor;
  zoomTargetThumbnail.showcaseCanvas.style.cursor = "-moz-zoom-in";

  // Move it a bit...
  zoomTargetThumbnail.showcaseCanvasBox.setAttribute("top", zoomTargetThumbnail.showcaseCanvasBox.getAttribute("top") - 1);
  zoomTargetThumbnail.showcaseCanvasBox.setAttribute("left", zoomTargetThumbnail.showcaseCanvasBox.getAttribute("left") - 1);

  // Make other thumbnails invisible
  for (var i = 0; i < processedWindows.length; i++) {
    var targetWindow =  processedWindows[i];
    for (var j = 0; j<targetWindow.processedTabs.length; j++) {
      var currentTab = targetWindow.processedTabs[j];
      if (currentTab != zoomTargetThumbnail) {
        currentTab.showcaseCanvasBox.hidden = true;
      }
    }
  }

  checkScrollCursorsVisibility();

  // Remember scroll
  previousZoomScrollX = {};
  previousZoomScrollY = {};
  scrollBoxObject.getPosition(previousZoomScrollX, previousZoomScrollY);
  
  refreshContent();
}

function leaveZoomMode() {
  if (!inZoomMode) {
    return;
  }

  // Move it a bit...
  zoomTargetThumbnail.showcaseCanvasBox.setAttribute("top", zoomTargetThumbnail.showcaseCanvasBox.getAttribute("top") - 1);
  zoomTargetThumbnail.showcaseCanvasBox.setAttribute("left", zoomTargetThumbnail.showcaseCanvasBox.getAttribute("left") - 1);


  inZoomMode = false;
  zoomTargetThumbnail.showcaseCanvas.style.cursor = zoomTargetPreviousCursorStyle;
  zoomTargetPreviousCursorStyle = null;
  zoomTargetThumbnail = null;

  // Make other thumbnails visible
  for (var i = 0; i < processedWindows.length; i++) {
    var targetWindow =  processedWindows[i];
    for (var j = 0; j<targetWindow.processedTabs.length; j++) {
      var currentTab = targetWindow.processedTabs[j];
      if (currentTab != zoomTargetThumbnail) {
        currentTab.showcaseCanvasBox.hidden = false;
      }
    }
  }

  checkScrollCursorsVisibility();

  refreshContent();

  // Restore zoom
  setTimeout(scrollBoxObject.scrollTo, 0, previousZoomScrollX.value, previousZoomScrollY.value);
}

function checkScrollCursorsVisibility() {
  var cursorLeft = document.getElementById("cursor-left");
  var cursorRight = document.getElementById("cursor-right");
  var cursorUp = document.getElementById("cursor-up");
  var cursorDown = document.getElementById("cursor-down");

  if (inZoomMode && (renderingType == 0) && (zoomScrollIncrement != 0) && (!zoomTargetThumbnail.showcaseImage) && (!zoomTargetThumbnail.showcaseEmbedded)) {
    // Check...
    if (zoomTargetThumbnail.targetTab) {
      var targetView = zoomTargetThumbnail.targetTab.contentWindow;
      if (targetView.scrollY > 0) {
        cursorUp.removeAttribute("hidden");
      } else {
        cursorUp.setAttribute("hidden", true);
        zoomScrollingUp = false;
      }
      if (targetView.scrollY < targetView.scrollMaxY) {
        cursorDown.removeAttribute("hidden");
      } else {
        cursorDown.setAttribute("hidden", true);
        zoomScrollingDown = false;
      }
      if (targetView.scrollX > 0) {
        cursorLeft.removeAttribute("hidden");
      } else {
        cursorLeft.setAttribute("hidden", true);
        zoomScrollingLeft = false;
      }
      if (targetView.scrollX < targetView.scrollMaxX) {
        cursorRight.removeAttribute("hidden");
      } else {
        cursorRight.setAttribute("hidden", true);
        zoomScrollingRight = false;
      }
    }
  } else {
    cursorUp.setAttribute("hidden", true);
    cursorDown.setAttribute("hidden", true);
    cursorLeft.setAttribute("hidden", true);
    cursorRight.setAttribute("hidden", true);
    zoomScrollingUp = false;
    zoomScrollingDown = false;
    zoomScrollingLeft = false;
    zoomScrollingRight = false;
  }
}

function doZoomScrollUp() {
  if (inZoomMode && zoomScrollingUp) {
    zoomTargetThumbnail.targetTab.contentWindow.scrollBy(0, -zoomScrollIncrement);
    setTimeout(function foo(a) { a.doZoomScrollUp() }, 20, this);
  }
}

function doZoomScrollDown() {
  if (inZoomMode && zoomScrollingDown) {
    zoomTargetThumbnail.targetTab.contentWindow.scrollBy(0, zoomScrollIncrement);
    setTimeout(function foo(a) { a.doZoomScrollDown() }, 20, this);
  }
}

function doZoomScrollLeft() {
  if (inZoomMode && zoomScrollingLeft) {
    zoomTargetThumbnail.targetTab.contentWindow.scrollBy(-zoomScrollIncrement, 0);
    setTimeout(function foo(a) { a.doZoomScrollLeft() }, 20, this);
  }
}

function doZoomScrollRight() {
  if (inZoomMode && zoomScrollingRight) {
    zoomTargetThumbnail.targetTab.contentWindow.scrollBy(zoomScrollIncrement, 0);
    setTimeout(function foo(a) { a.doZoomScrollRight() }, 20, this);
  }
}

function thumbnailFocus(el) {
  if (currentCursor != el.target.showcaseTab) {
    processFocusedTab(el.target.showcaseTab);

    // Ensure it's visible
    ensureThumbnailIsVisible(el.target);
  }
}

function ensureThumbnailIsVisible(targetThumbnail) {
  if (scrollBoxObject) {
    var targetBoxObject = targetThumbnail.boxObject;
    var scrollX = {};
    var scrollY = {};
    scrollBoxObject.getPosition(scrollX,scrollY);
    var newX = scrollX.value;
    var newY = scrollY.value;
    var boxX = parseInt(targetThumbnail.getAttribute("left"));
    var boxY = parseInt(targetThumbnail.getAttribute("top"));

    if ((boxX + targetBoxObject.width - scrollX.value - scrollBoxObject.width) > 0) {
      newX = targetBoxObject.width + boxX - scrollBoxObject.width;
    }
    if ((boxY + targetBoxObject.height - scrollY.value - scrollBoxObject.height) > 0) {
      newY = targetBoxObject.height + boxY - scrollBoxObject.height;
    }

    if ((boxX - scrollX.value) < 0) {
      newX = boxX - 1;
    }
    if ((boxY - scrollY.value) < 0) {
      newY = boxY - 1;
    }
    if ((newX != scrollX.value) || (newY != scrollY.value))
      scrollBoxObject.scrollTo(newX, newY);
  }
}

function ensureSelectedThumbnailVisible(targetProcessedWindow) {
  // Get selected tab
  var tabbrowser = targetProcessedWindow.targetWindow.getBrowser();
  var tabs = tabbrowser.mTabContainer.childNodes;
  var selectedTab = tabbrowser.getBrowserForTab(tabs[tabbrowser.mTabContainer.selectedIndex]);
  var found = false;

  // Iterate array
  for (var c=0; ((c<targetProcessedWindow.processedTabs.length) && !found); c++) {
    var processedTab = targetProcessedWindow.processedTabs[c];
    
    if (processedTab.targetTab == selectedTab) {
      ensureThumbnailIsVisible(processedTab.showcaseCanvasBox);
    }
  }
}

function processFocusedTab(targetProcessedTab) {
  if (focusToggleSelection) {
    toggleSelection(targetProcessedTab);
  } else if (focusSelectRange) {
    if (lastFocusedTab == null) {
      // Add only the new focused cursor...
      addToSelection(targetProcessedTab);
    } else {
      // Add the range between both elements...
      addRangeToSelection(lastFocusedTab, targetProcessedTab);
    }
  } else if (focusSelectIfUnselected) {
    if (selectedTabs.indexOf(targetProcessedTab) < 0) {
      removeAllSelections();
      addToSelection(targetProcessedTab);
    }
  } else if (!focusIgnoreSelection) {
    removeAllSelections();
    addToSelection(targetProcessedTab);
  }
  
  focusToggleSelection = false;
  focusSelectRange = false;
  focusSelectIfUnselected = false;
  focusIgnoreSelection = false;

  currentCursor = targetProcessedTab;
}

function thumbnailBlur(el) {
  if ((currentCursor == el.target.showcaseTab) && (document.commandDispatcher.focusedElement != el.target)) {
    lastFocusedTab = currentCursor;
    currentCursor = null;
  }
}

function addRangeToSelection(fromTab, toTab) {
  var foundFirst = false;
  var foundLast = false;

  for (var c=0; (c<processedWindows.length)&&!foundLast; c++) {
    for (var d=0; (d<processedWindows[c].processedTabs.length)&&!foundLast; d++) {
      if (!foundFirst) {
        if ((processedWindows[c].processedTabs[d] == fromTab) || 
            (processedWindows[c].processedTabs[d] == toTab)) {
          addToSelection(processedWindows[c].processedTabs[d]);
          foundFirst = true;
        }
      } else if (!foundLast) {
        addToSelection(processedWindows[c].processedTabs[d]);
        if ((processedWindows[c].processedTabs[d] == fromTab) || 
            (processedWindows[c].processedTabs[d] == toTab)) {
          foundLast = true;
        }
      }
    }
  }
}

function toggleSelection(targetProcessedTab) {
  if (selectedTabs.indexOf(targetProcessedTab) > -1) {
    removeFromSelection(targetProcessedTab);
  } else {
    addToSelection(targetProcessedTab);
  }
}

function removeFromSelection(targetProcessedTab) {
  var targetIndex = selectedTabs.indexOf(targetProcessedTab);
  if (targetIndex > -1) {
    targetProcessedTab.showcaseCanvasBox.removeAttribute("selected");
    removeElementAt(selectedTabs, targetIndex);
  }
}

function addToSelection(targetProcessedTab) {
  if (selectedTabs.indexOf(targetProcessedTab) < 0) {
    selectedTabs.push(targetProcessedTab);
    targetProcessedTab.showcaseCanvasBox.setAttribute("selected", "true");
  }
}

function removeAllSelections() {
  while (selectedTabs.length > 0) {
    var currentTab = selectedTabs.shift();
    currentTab.showcaseCanvasBox.removeAttribute("selected");
  }
}

function selectAll() {
  removeAllSelections();
  for (var c=0; c<processedWindows.length; c++) {
    for (var d=0; d<processedWindows[c].processedTabs.length; d++) {
      if (!processedWindows[c].processedTabs[d].showcaseCanvasBox.hidden) {
        addToSelection(processedWindows[c].processedTabs[d]);
      }
    }
  }
}

function refreshFocus(targetElement) {
  targetElement.focus();
}

function mouseOverCanvas(el) {
  var hasEntered = true;
  var currentNode = el.relatedTarget;

  if (currentNode) {
    while (hasEntered && currentNode.parentNode) {
      hasEntered = (el.currentTarget != currentNode.parentNode);
      currentNode = currentNode.parentNode;
    }
  }

  if (hasEntered) {
    if (thumbnailActiveAnimation) {
      animateBox(el.currentTarget, true);
    } else {
      // Show thumbnail icons
      setCurrentIconsThumbnail(el.currentTarget);
    }

    if (selectWhenMouseOver) {
      var targetBox;
      if (el.currentTarget.showcaseCanvas) { 
        targetBox = el.currentTarget.showcaseCanvas.showcaseCanvasBox;
      } else {
        targetBox = el.currentTarget.showcaseCanvasBox;
      }

      if (selectWhenMouseOverDelay > 0) {
        if (selectTimer == null) {
          selectTimer = Components.classes["@mozilla.org/timer;1"].createInstance(Components.interfaces.nsITimer);
        }
        selectTimer.cancel();
        selectTimerTarget = targetBox;

        var selectTimerNotifier = {
          QueryInterface : function (aIID) {
            if (aIID.equals(Components.interfaces.nsITimerCallback) ||
                aIID.equals(Components.interfaces.nsISupports) ||
                aIID.equals(Components.interfaces.nsISupportsWeakReference))
              return this;
            throw Components.results.NS_NOINTERFACE;
          },

          notify: function(timer) {
            if (selectTimerTarget && !selectTimerTarget.hasAttribute("selectedtab")) {
              openTab(selectTimerTarget.showcaseTab);
            }
          }
        };

        selectTimer.initWithCallback(selectTimerNotifier, selectWhenMouseOverDelay, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
      } else {
        if (!targetBox.hasAttribute("selectedtab")) {
          openTab(targetBox.showcaseTab);
        }
      }
    }
  }
}

function mouseOutCanvas(el) {
  var hasExited = true;
  var currentNode = el.relatedTarget;

  lastMouseDownTab = null;

  if (currentNode) {
    while (hasExited && currentNode.parentNode) {
      hasExited = ((el.currentTarget != currentNode.parentNode) && (!currentNode.hasAttribute("class") || currentNode.getAttribute("class") != "thumb-icon"));
      currentNode = currentNode.parentNode;
    }
  }

  if (hasExited) {
    if (currentIconsThumbnail == el.currentTarget) {
      hideThumbnailIcons();
      currentIconsThumbnail = null;
    }

    if (thumbnailActiveAnimation) {
      animateBox(el.currentTarget, false);
    }
    if (selectTimer) {
      selectTimer.cancel();
      selectTimerTarget = null;
    }
  }
}

function mouseDownCanvas(el) {
  // Zoom mode
  var targetTab = el.currentTarget.showcaseTab;

  lastMouseDownTab = targetTab;

  if ((el.button == 2) && (rightClickAction == 4)) {
    focusSelectIfUnselected = true;
  } else if (el.ctrlKey || el.shiftKey) {
    if (el.ctrlKey) {
      focusIgnoreSelection = true;
    } else { // if (el.shiftKey) {
      focusSelectRange = true;
    }
  } else if ((el.button >= 0) && (el.button <= 2)) {
    var clickAction;
    
    if (el.button == 0) {
      clickAction = leftClickAction;
    } else if (el.button == 1) {
      clickAction = middleClickAction;
    } else { // if (el.button == 2) {
      clickAction = rightClickAction;
    }

    if (clickAction == 1) { 
      focusIgnoreSelection = true;
      enterZoomMode(targetTab);

      if (topWindow != window) {
        el.stopPropagation();
        el.preventDefault();
      }
    } else {
      if (selectedTabs.indexOf(targetTab) > -1) {
        focusIgnoreSelection = true;
      }
      if (clickAction == 2) {
        if ((topWindow != window) && (el.button != 0)) {
          el.stopPropagation();
          el.preventDefault();
        }
      }
    }
  }

  if ((targetTab) && (targetTab == currentCursor)) {
    processFocusedTab(currentCursor);
  }
}

function mouseDblClickWindow(el) {
  if (el.originalTarget == showcaseBox) {
    // If double clicking on box, select all thumbnails
    selectAll();
  }
}

function mouseUpWindow(el) {
  if (((el.button == 0) || (el.button == 1) || ((el.button == 2) && (rightClickAction != 4)) ) && !(el.ctrlKey || el.shiftKey)) {
    var clickAction;
    if (el.button == 0) {
      clickAction = leftClickAction;
    } else if (el.button == 1) {
      clickAction = middleClickAction;
    } else { // if (button == 2) {
      clickAction = rightClickAction;
    }
    if (clickAction == 1) { 
      // Zoom mode
      leaveZoomMode();
      if (topWindow != window) {
        el.stopPropagation();
      }
    }
  }
}

function mouseUpCanvas(el) {
  if (!selectionBox.hasAttribute("hidden")) {
    return;
  }
  var targetProcessedTab = el.currentTarget.showcaseTab;
  if (((el.button == 0) || (el.button == 1) || ((el.button == 2) && (rightClickAction != 4)) ) && !(el.ctrlKey || el.shiftKey) && (lastMouseDownTab == targetProcessedTab)) {
    var clickAction;

    if (el.target != targetProcessedTab.showcaseCanvasBox.showcaseCloseButton) {
      if (el.button == 0) {
        clickAction = leftClickAction;
      } else if (el.button == 1) {
        clickAction = middleClickAction;
      } else { // if (el.button == 2) {
        clickAction = rightClickAction;
      }

      if (clickAction == 1) { 
        // Zoom mode
        leaveZoomMode();
      } else if (!((el.button == 2) && (rightClickAction == 4))) {
        switch (clickAction) { 
          case 0:
            // Close
            closeShowcaseTab(targetProcessedTab);
            break;
          case 2:
            // Open
            openTab(targetProcessedTab);
            break;
          case 3:
            // Nothing
            if ((el.button == 0) && ((selectedTabs.length > 1) || (selectedTabs[0] != targetProcessedTab))) {
              removeAllSelections();
              addToSelection(targetProcessedTab);
            }
            break;
        }
      }
    }
  } else if ((el.button == 0) && el.ctrlKey && (lastMouseDownTab == targetProcessedTab)) {
    var targetProcessedTab = el.currentTarget.showcaseTab;
    toggleSelection(targetProcessedTab);
  }

  lastMouseDownTab = null;

  if (topWindow != window) {
    el.preventDefault();
    el.stopPropagation();
  }
}

function mouseClickClose(el) {
  if (el.button == 0) {
    if (el.target.targetProcessedTab) {
      closeShowcaseTab(el.target.targetProcessedTab);
    }
  }
}

function mouseDoubleClickCanvas(el) {
  // As easy as opening the tab
  if (el.currentTarget.showcaseTab) {
    openTab(el.currentTarget.showcaseTab);
  }
}

function openTab(targetProcessedTab) {
  // Look for the tab that has the canvas
  try {
    var found = false;
    var targetProcessedWindow;
    var targetTabIndex;
    var targetTabBrowser;

    for (var i = 0; (i < processedWindows.length) && !found; i++) {
      var currentWindow = processedWindows[i];

      if (currentWindow.processedTabs.indexOf(targetProcessedTab) > -1) {
        targetTabBrowser = currentWindow.targetWindow.getBrowser();
        
        found = true;
        targetProcessedWindow = currentWindow;

        var foundTab = false;
        for (var j = 0; (j<targetTabBrowser.tabContainer.childNodes.length) && !foundTab; j++) {
          var targetTab = targetTabBrowser.getBrowserForTab(targetTabBrowser.tabContainer.childNodes.item(j));
          if (targetProcessedTab.targetTab == targetTab) {
            targetTabIndex = j;
            foundTab = true;
          }
        }
      }
    }

    if (found) {
      if ((targetTabBrowser.tabContainer.selectedIndex == targetTabIndex) && tabFlipping && (targetTabBrowser.previousTab || targetProcessedWindow.targetWindow.flst)) {
        if (targetTabBrowser.previousTab) {
          targetTabBrowser.previousTab(targetProcessedTab.tabHeader);
        } else {
          targetProcessedWindow.targetWindow.flst.tabFlip();
        }
      } else {
        targetTabBrowser.tabContainer.selectedIndex = targetTabIndex;
      }

      if (showcaseCloseWhenSelect) {
        targetFocusWindow = targetProcessedWindow.targetWindow;
      } else {
        try {
          targetProcessedWindow.targetWindow.focus();
        } catch (focusEx) {
          showFocusAlert(targetProcessedWindow.targetWindow);
        }
      }
    } else {
      // Alert user we haven't found the page
      // TODO: localized string
      alert("The selected browser couldn't be found.");
    }

    // Last, close ourselves
    if (showcaseCloseWhenSelect) {
      closeWindow();
    }

  } catch (e) {
    alert("openTab: " + e);
  }
}

function selectTab(targetTabBrowser, targetTabIndex) {
  targetTabBrowser.tabContainer.selectedIndex = targetTabIndex;
}

function showFocusAlert(targetWindow) {
  try {
    var showcaseBundle = document.getElementById("bundle_showcase");
    targetWindow.alert(showcaseBundle.getString("showcase.focus.alert"));
  } catch (e) {
    // Fail silently
  }
}

function unloadShowcase() {
  if (window.opener) {
    try {
      // Store window values to remember later
      var prefs = Components.classes["@mozilla.org/preferences-service;1"].
                getService(Components.interfaces.nsIPrefBranch);
      prefs.setIntPref("extensions.showcase.windowLastX", window.screenX);
      prefs.setIntPref("extensions.showcase.windowLastY", window.screenY);
      if (window.innerWidth > 0) {
        prefs.setIntPref("extensions.showcase.windowLastWidth", window.innerWidth);
      }
      if (window.innerHeight > 0) {
        prefs.setIntPref("extensions.showcase.windowLastHeight", window.innerHeight);
      }
      var lastRelativeX = window.screenX - window.opener.screenX;
      var lastRelativeY = window.screenY - window.opener.screenY;
      prefs.setIntPref("extensions.showcase.windowLastRelativeX", lastRelativeX);
      prefs.setIntPref("extensions.showcase.windowLastRelativeY", lastRelativeY);
    } catch (ex) {
      // We may have trouble in the case window is closed, so just fail silently
    }
  }

  // Free resources
  if (!closingShowcase) {
    closingShowcase = true;
    unlinkShowcase(CACHEMODE_UPDATE);

    /*#if !seamonkey*/
    // Check synch find bar in tab mode
    if (synchFindBar && (topWindow != window.top) && searchActive) {
      if (topWindow.openFindBar) {
        topWindow.openFindBar();
      } else if (topWindow.gFindBar) {
        topWindow.gFindBar.openFindBar();
      }
    }
    /*#endif*/

    // See if we've to toggle the find bar...

    if (targetFocusWindow) {
      try {
        targetFocusWindow.focus();
      } catch (e) {
        showFocusAlert(targetFocusWindow);
      }
    }
  }
}

function animateBox(targetElement, growBox) {
  var targetBox;

  if (targetElement.showcaseCanvas) { 
    targetBox = targetElement.showcaseCanvas.showcaseCanvasBox;
  } else {
    targetBox = targetElement.showcaseCanvasBox;
  }

  targetBox.showcaseGrowing = growBox;
  if (currentAnimations.indexOf(targetBox) < 0) {
    if (growBox) {
      if (thumbnailActiveSizeFactor > 100) {
        // Hack to bring it to the front
        if (showcaseBox.childNodes[showcaseBox.childNodes.length - 2] != targetBox) {
          targetBox.removeEventListener("mouseover", mouseOverCanvas, false);
          targetBox.removeEventListener("mouseout", mouseOutCanvas, false);
          targetBox.removeEventListener("focus", thumbnailFocus, false);
          targetBox.removeEventListener("blur", thumbnailBlur, false);
          if (targetBox.showcaseCloseButton) {
            targetBox.showcaseCloseButton.removeEventListener("click", mouseClickClose, true);
          }
          targetBox.removeEventListener("mousedown", mouseDownCanvas, (topWindow != window));
          targetBox.removeEventListener("mouseup", mouseUpCanvas, (topWindow != window));
          if (doubleClickOpen) {
            targetBox.removeEventListener("dblclick", mouseDoubleClickCanvas, (topWindow != window));
          }

          showcaseBox.removeChild(targetBox);
          showcaseBox.insertBefore(targetBox, selectionBox);
          targetBox.addEventListener("mouseover", mouseOverCanvas, false);
          targetBox.addEventListener("mouseout", mouseOutCanvas, false);
          targetBox.addEventListener("focus", thumbnailFocus, false);
          targetBox.addEventListener("blur", thumbnailBlur, false);
          if (targetBox.showcaseCloseButton) {
            targetBox.showcaseCloseButton.addEventListener("click", mouseClickClose, true);
          }
          targetBox.addEventListener("mousedown", mouseDownCanvas, (topWindow != window));
          targetBox.addEventListener("mouseup", mouseUpCanvas, (topWindow != window));
          if (doubleClickOpen) {
            targetBox.addEventListener("dblclick", mouseDoubleClickCanvas, (topWindow != window));
          }
          if (currentCursor == targetBox.showcaseTab) {
            focusIgnoreSelection = true;
            targetBox.focus();
          }
        }
      }
      targetBox.showcaseAnimationFrame = 0;
    } else {
      targetBox.showcaseAnimationFrame = animationFrames;
    }
    currentAnimations.push(targetBox);
  }
}

function animationThread() {
  var checkpointTime = new Date().getTime();

  if (currentAnimations && (currentAnimations.length > 0)) {
    var c = 0;

    while (c < currentAnimations.length) {
      var currentBox = currentAnimations[c];
      var endAnimation = false;

      if (!currentBox.showcaseIdleWidth || !currentBox.showcaseIdleHeight || !currentBox.showcaseActiveWidth ||!currentBox.showcaseActiveHeight) {
        c++;
        continue;
      }

      if (currentBox.showcaseGrowing) {
        currentBox.showcaseAnimationFrame++;
        if (currentBox.showcaseAnimationFrame >= animationFrames) {
          currentBox.showcaseAnimationFrame = animationFrames;
          endAnimation = true;
        }
      } else {
        currentBox.showcaseAnimationFrame--;
        if (currentBox.showcaseAnimationFrame <= 0) {
          currentBox.showcaseAnimationFrame = 0;
          endAnimation = true;
        }
      }
      
      var newWidth = currentBox.showcaseIdleWidth + (currentBox.showcaseActiveWidth - currentBox.showcaseIdleWidth) * currentBox.showcaseAnimationFrame / animationFrames;
      var newHeight = currentBox.showcaseIdleHeight + (currentBox.showcaseActiveHeight - currentBox.showcaseIdleHeight) * currentBox.showcaseAnimationFrame / animationFrames;
      
      if (newWidth > showcaseBox.boxObject.width) {
        // We're getting out of the limits!! Set maximum size that will fit the window...
        newHeight = ((newHeight - thumbnailBorderHeight) * (showcaseBox.boxObject.width - thumbnailBorderWidth)  / (newWidth - thumbnailBorderWidth)) + thumbnailBorderHeight;
        newWidth = showcaseBox.boxObject.width;
      }

      if (newHeight > showcaseBox.boxObject.height) {
        // We're getting out of the limits!! Set maximum size that will fit the window...
        newWidth = ((newWidth - thumbnailBorderWidth) * (showcaseBox.boxObject.height - thumbnailBorderHeight) / (newHeight - thumbnailBorderHeight)) + thumbnailBorderWidth;
        newHeight = showcaseBox.boxObject.height;
      }

      var newTop = currentBox.showcaseCenterY - newHeight / 2;
      var newLeft = currentBox.showcaseCenterX - newWidth / 2;
      var limitX = showcaseBox.boxObject.width - newWidth;
      var limitY = showcaseBox.boxObject.height - newHeight;

      if (newTop < 0) {
        if ((currentBox.getAttribute("top") == 0) && !currentBox.showcaseGrowing) {
          newTop = -1;
        } else {
          newTop = 0;
        }
      } else if (newTop > limitY) {
        if ((currentBox.getAttribute("top") == limitY) && !currentBox.showcaseGrowing) {
          newTop = limitY + 1;
        } else {
          newTop = limitY;
        }
      }
      if (newLeft < 0) {
        if ((currentBox.getAttribute("left") == 0) && !currentBox.showcaseGrowing) {
          newLeft = -1;
        } else {
          newLeft = 0;
        }
      } else if (newLeft > limitX) {
        if ((currentBox.getAttribute("left") == limitX) && !currentBox.showcaseGrowing) {
          newLeft = limitX + 1;
        } else {
          newLeft = limitX;
        }
      }

      currentBox.setAttribute("top", newTop);
      currentBox.setAttribute("left", newLeft);

      if (isFirefox3) {
        setCanvasSize(currentBox.showcaseCanvas, (newWidth - thumbnailBorderWidth), (newHeight - thumbnailBorderHeight));
      }
      setSize(currentBox, newWidth, newHeight);

      if (endAnimation) {
        removeElementAt(currentAnimations, c);
        // Check if is the end of a thumbnail growing
        if (currentBox.showcaseGrowing) {
          // Show thumbnail icons
          setCurrentIconsThumbnail(currentBox);

          if (currentBox.showcaseCanvas.showcasePainted) {
            var showcaseCanvasScreenBox = document.getBoxObjectFor(currentBox.showcaseCanvas);
            if ((showcaseCanvasScreenBox.width > currentBox.showcaseCanvas.width) || (showcaseCanvasScreenBox.height > currentBox.showcaseCanvas.height)) {
              currentBox.showcaseCanvas.showcasePainted = false;
              setTimeout(paintThumbnail, 0, currentBox.showcaseTab);
            }
          }
        }
      } else {
        c++;
      }
    }
  }
  if (!closingShowcase && thumbnailActiveAnimation) {
    var currentWaitTime = ANIMATION_INTERVAL - (new Date().getTime() - checkpointTime);
    if (currentWaitTime < 0) {
      currentWaitTime = 0;
    }

    setTimeout(animationThread, currentWaitTime);
  }
}

function updateThumbnail(targetThumbnail, thumbWidth, thumbHeight, idleFactor, activeFactor) {
try {
  var canvasActiveW, canvasActiveH;
  var canvasIdleW, canvasIdleH;
  var windowW, windowH;
  var innerThumbWidth = thumbWidth - thumbnailBorderWidth;
  var innerThumbHeight = thumbHeight - thumbnailBorderHeight;

  if (targetThumbnail.showcaseImage) {
    var img = targetThumbnail.targetTab.contentDocument.imageRequest.decoderObserver;
    windowW = img.width;
    windowH = img.height;
    if ((windowW < 1) || (windowH < 1)) {
      windowW = 100;
      windowH = 100;
    }
  } else {
    windowW = targetThumbnail.targetTab.contentWindow.innerWidth;
    windowH = targetThumbnail.targetTab.contentWindow.innerHeight;
  }

    if ((innerThumbWidth * windowH / windowW) > innerThumbHeight) {
      canvasIdleW = Math.ceil(innerThumbHeight * windowW * idleFactor / windowH);
      canvasIdleH = Math.ceil(innerThumbHeight * idleFactor);
      canvasActiveW = Math.ceil(innerThumbHeight * windowW * activeFactor / windowH);
      canvasActiveH = Math.ceil(innerThumbHeight * activeFactor);
    } else {
      canvasIdleW = Math.ceil(innerThumbWidth * idleFactor);
      canvasIdleH = Math.ceil(innerThumbWidth * windowH * idleFactor / windowW);
      canvasActiveW = Math.ceil(innerThumbWidth * activeFactor);
      canvasActiveH = Math.ceil(innerThumbWidth * windowH * activeFactor / windowW);
    }

    if (targetThumbnail.showcaseImage && !imageThumbnailUpscale) {
      var img = targetThumbnail.targetTab.contentDocument.imageRequest.decoderObserver;
      if ((img.width > 0) && (img.height > 0) && ((canvasIdleW > img.width) || (canvasIdleH > img.height))) {
        canvasIdleW = img.width;
        canvasIdleH = img.height;
        canvasActiveW = canvasIdleW;
        canvasActiveH = canvasIdleH;
      }
    }

      targetThumbnail.showcaseCanvasBox.showcaseIdleWidth = canvasIdleW + thumbnailBorderWidth;
      targetThumbnail.showcaseCanvasBox.showcaseIdleHeight = canvasIdleH + thumbnailBorderHeight;
      targetThumbnail.showcaseCanvasBox.showcaseActiveWidth = canvasActiveW + thumbnailBorderWidth;
      targetThumbnail.showcaseCanvasBox.showcaseActiveHeight = canvasActiveH + thumbnailBorderHeight;

      if (isFirefox3) {
        setCanvasSize(targetThumbnail.showcaseCanvas, (targetThumbnail.showcaseCanvasBox.showcaseIdleWidth - thumbnailBorderWidth), (targetThumbnail.showcaseCanvasBox.showcaseIdleHeight - thumbnailBorderHeight));
      }

      setSize(targetThumbnail.showcaseCanvasBox, 
        targetThumbnail.showcaseCanvasBox.showcaseIdleWidth, 
        targetThumbnail.showcaseCanvasBox.showcaseIdleHeight);
} catch (e) {
  // Probably we failed because the thumbnail has disappeared, so fail silently
}
}

function updateThumbnails(thumbWidth, thumbHeight, idleFactor, activeFactor) {
  var targetItem;

  var pendingSelectedThumbnailIndex = 0;

  if (inZoomMode) {
    targetItem = zoomTargetThumbnail;
    if ((targetItem) && (targetItem.showcaseCanvas) && (targetItem.showcaseCanvasBox)) {
      try {
        updateThumbnail(targetItem, thumbWidth, thumbHeight, 1, 1);
      } catch (e) {
        alert("updateThumbs1: " + e);
      }

      if (!targetItem.showcaseCanvasBox.hasAttribute("top")) {
        targetItem.showcaseCanvasBox.setAttribute("top", 0);
        targetItem.showcaseCanvasBox.setAttribute("left", 0);
      }

      var showcaseCanvasScreenBox = document.getBoxObjectFor(targetItem.showcaseCanvas);
      if (!targetItem.showcaseCanvas.showcasePainted || (showcaseCanvasScreenBox.width > targetItem.showcaseCanvas.width) || (showcaseCanvasScreenBox.height > targetItem.showcaseCanvas.height)) {
//      if (!targetItem.showcaseCanvas.showcasePainted || (targetItem.showcaseCanvasBox.showcaseIdleWidth > targetItem.showcaseCanvas.width) || (targetItem.showcaseCanvasBox.showcaseIdleHeight > targetItem.showcaseCanvas.height)) {
        try {
          createTooltip(targetItem);
        } catch (e) {
        // We can fail while creating the tooltip, since window 
        }
        // We're gonna paint it, so set it to false
        targetItem.showcaseCanvas.showcasePainted = false;

        if (paintThumbnailsAfterLoading) {
          // If it's a window's selected thumbnail, give it priority over the others
          if (pendingThumbnails.indexOf(targetItem) < 0) {
            pendingThumbnails.unshift(targetItem);
          }
        } else {
          setTimeout(paintThumbnail, 0, targetItem);
        }
      }
    }
  } else {
    for (var i = 0; i < processedWindows.length; i++) {
      var targetWindow = processedWindows[i];
      if (targetWindow.processedTabs) {
        var tabbrowser = targetWindow.targetWindow.getBrowser();
        var currentSelectedTab = tabbrowser.getBrowserForTab(tabbrowser.mCurrentTab);

        for (var j = 0; j< targetWindow.processedTabs.length; j++) {
          // Resize canvas and canvasBox
          targetItem = targetWindow.processedTabs[j];
        
          if ((targetItem) && (targetItem.showcaseCanvas) && (targetItem.showcaseCanvasBox)) {
            try {
              updateThumbnail(targetItem, thumbWidth, thumbHeight, idleFactor, activeFactor);
            } catch (e) {
              alert("updateThumbs1: " + e);
            }

            if (!targetItem.showcaseCanvasBox.hasAttribute("top")) {
              targetItem.showcaseCanvasBox.setAttribute("top", 0);
              targetItem.showcaseCanvasBox.setAttribute("left", 0);
            }

            var showcaseCanvasScreenBox = document.getBoxObjectFor(targetItem.showcaseCanvas);
            if (!targetItem.showcaseCanvas.showcasePainted || (showcaseCanvasScreenBox.width > targetItem.showcaseCanvas.width) || (showcaseCanvasScreenBox.height > targetItem.showcaseCanvas.height) || (renderingType == 2)) {
//              if (!targetItem.showcaseCanvas.showcasePainted || (targetItem.showcaseCanvasBox.showcaseIdleWidth > targetItem.showcaseCanvas.width) || (targetItem.showcaseCanvasBox.showcaseIdleHeight > targetItem.showcaseCanvas.height) || (renderingType == 2)) {
              try {
                createTooltip(targetItem);
              } catch (e) {
                // We can fail while creating the tooltip, since window 
              }
              // We're gonna paint it, so set it to false
              targetItem.showcaseCanvas.showcasePainted = false;
              if (paintThumbnailsAfterLoading) {
                // If it's a window's selected thumbnail, give it priority over the others
                if (pendingThumbnails.indexOf(targetItem) < 0) {
                  if (paintSelectedTabsFirst && (targetItem.targetTab == currentSelectedTab)) {
                    insertElementAt(pendingThumbnails, targetItem, pendingSelectedThumbnailIndex);
                    pendingSelectedThumbnailIndex++;
                  } else {
                    pendingThumbnails.push(targetItem);
                  }
                }
              } else {
                setTimeout(paintThumbnail, 0, targetItem);
              }
            }
          }
        }
      }
    }
  }

  if (paintThumbnailsAfterLoading && !paintThumbnailsThread) {
    setTimeout(paintThumbnails, 0);
  }
}

function paintThumbnails() {
  if (pendingThumbnails.length > 0) {
    paintThumbnailsThread = true;
    var targetItem = pendingThumbnails.shift();
    paintThumbnail(targetItem);
    setTimeout(paintThumbnails, 0);
  } else {
    paintThumbnailsThread = false;
  }
}

function paintThumbnail(targetThumbnail) {
  try {
  if (targetThumbnail.showcaseCanvasBox.hidden)
    return;

  if (targetThumbnail.showcaseCanvas && targetThumbnail.showcaseCanvas.showcasePainted)
    return;

  var currentWebBrowserPrint = targetThumbnail.targetTab.contentWindow.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
                   .getInterface(Components.interfaces.nsIWebBrowserPrint);

  if (currentWebBrowserPrint.doingPrint || currentWebBrowserPrint.doingPrintPreview) return;

  var ctx = targetThumbnail.showcaseCanvas.getContext("2d");
  var showcaseCanvasBox = document.getBoxObjectFor(targetThumbnail.showcaseCanvas);
  var targetWidth = showcaseCanvasBox.width;
  var targetHeight = showcaseCanvasBox.height;
  
  targetThumbnail.showcaseCanvas.width = targetWidth;
  targetThumbnail.showcaseCanvas.height = targetHeight;

  if (targetThumbnail.showcaseImage) {
    var img = targetThumbnail.targetTab.contentDocument.imageRequest.decoderObserver;
    ctx.drawImage(img, 0, 0, targetWidth, targetHeight);    
  } else if (!targetThumbnail.showcaseIETab && !targetThumbnail.showcaseBlank && !targetThumbnail.showcaseEmbedded) {
    if (renderingType == 0) {
      ctx.save();
      ctx.scale(targetWidth/targetThumbnail.targetTab.contentWindow.innerWidth, targetHeight/targetThumbnail.targetTab.contentWindow.innerHeight);

      ctx.drawWindow(targetThumbnail.targetTab.contentWindow, 
        targetThumbnail.targetTab.contentWindow.scrollX, 
        targetThumbnail.targetTab.contentWindow.scrollY, 
        targetThumbnail.targetTab.contentWindow.innerWidth, 
        targetThumbnail.targetTab.contentWindow.innerHeight, 
        "rgb(255,255,255)");
      ctx.restore();
    } else if (renderingType == 1) {
      ctx.save();
      ctx.scale(targetWidth/targetThumbnail.targetTab.contentWindow.innerWidth, targetHeight/targetThumbnail.targetTab.contentWindow.innerHeight);

      // bug 313178: when painting thumbnails without scroll, there's an important bug
      ctx.drawWindow(targetThumbnail.targetTab.contentWindow, 
        0, 
        0, 
        targetThumbnail.targetTab.contentWindow.innerWidth, 
        targetThumbnail.targetTab.contentWindow.innerHeight + targetThumbnail.targetTab.contentWindow.scrollMaxY, 
        "rgb(255,255,255)");
      ctx.restore();
    } else { // if (renderingType == 2) {
      // bug 313178: when painting thumbnails without scroll, there's an important bug
      ctx.drawWindow(targetThumbnail.targetTab.contentWindow, 
        0, 
        0, 
        targetWidth, 
        targetHeight + targetThumbnail.targetTab.contentWindow.scrollMaxY, 
        "rgb(255,255,255)");
    }
  } else {
    ctx.clearRect(0, 0, targetWidth, targetHeight);
  }

  } catch (e) {
    //Paint thumbnail failed, probably because the thumbnail disappeared. Fail silently.
  }

  // Mark it has been painted
  if (targetThumbnail.showcaseCanvas) {
    targetThumbnail.showcaseCanvas.showcasePainted = true;

    // Painting is a slow process, so we check if thumbnail has changed size while we were painting
    if ((targetWidth != showcaseCanvasBox.width) || (targetHeight != showcaseCanvasBox.height)) {
      // repaint
      setTimeout(paintThumbnail, 0, targetThumbnail);
    }
  }
}

function updateTitle() {
  if (closingShowcase)
    return;

  if (!showcaseOriginalTitle) {
    if (window != window.top) {
      // Sidebar
	if (globalMode) {
        showcaseOriginalTitle = topWindow.document.getElementById(SHOWCASE_SIDEBAR).getAttribute('label');
      } else {
        showcaseOriginalTitle = topWindow.document.getElementById(SHOWCASETHISWINDOW_SIDEBAR).getAttribute('label');
      }
    } else {
      showcaseOriginalTitle = document.title;
    }
  }

  var finalTitle = showcaseOriginalTitle;
  var currentTitle;

  if (window != window.top) {
    // Sidebar
    if (topWindow.MultiSidebar) {
      if (originalGlobalMode) {
        currentTitle = topWindow.MultiSidebar.getSidebarTitle(SHOWCASE_SIDEBAR);
      } else {
        currentTitle = topWindow.MultiSidebar.getSidebarTitle(SHOWCASETHISWINDOW_SIDEBAR);
      }
    } else {
      currentTitle = topWindow.document.getElementById('sidebar-title').getAttribute('value');
    }
  } else {
    currentTitle = document.title;
  }

  if (showOnlyCurrent) {
    if (!showOnlyCurrentLabel) {
      var showcaseBundle = document.getElementById("bundle_showcase");
      showOnlyCurrentLabel = showcaseBundle.getString("onlyCurrentTitle");
    }
    finalTitle += " " + showOnlyCurrentLabel;
  }

  if (showTitleStats) {
    finalTitle += " [";

    if (globalMode) {
      if (processedWindows) {
        var totalTabs = 0;
        for (var c=0; c<processedWindows.length; c++) {
          if (processedWindows[c].processedTabs) {
            totalTabs += processedWindows[c].processedTabs.length;
          }
        }
        finalTitle += totalTabs;
        finalTitle += "/";
        finalTitle += processedWindows.length;
      } else {
        finalTitle += "?";
      }
    } else {
      if (processedWindows && (processedWindows.length > 0) && (processedWindows[0].processedTabs)) {
        finalTitle += processedWindows[0].processedTabs.length;
      } else {
        finalTitle += "?";
      }
    }

    finalTitle += "]";
  }

  if (currentTitle != finalTitle) {
    if (window != window.top) {
      // Sidebar
      if (topWindow.MultiSidebar) {
        if (originalGlobalMode) {
          topWindow.MultiSidebar.setSidebarTitle(SHOWCASE_SIDEBAR, finalTitle);
        } else {
          topWindow.MultiSidebar.setSidebarTitle(SHOWCASETHISWINDOW_SIDEBAR, finalTitle);
        }
      } else {
        topWindow.document.getElementById('sidebar-title').setAttribute('value', finalTitle);
      }
    } else {
      document.title = finalTitle;
    }
  }
}

function createTooltip(targetItem) {
  var targetTitle = targetItem.tabHeader.label;

  var targetURL = "";
  if (targetItem.targetTab.currentURI) {
    if (targetItem.showcaseIETab) {
      try {
        targetURL = targetItem.targetTab.contentDocument.URL.substring(IETAB_URL.length);
      } catch (stringException) {
        targetURL = targetItem.targetTab.currentURI.spec;
      }
    } else {
      targetURL = targetItem.targetTab.currentURI.spec;
    }
  }
  if (targetURL == "") targetURL = "about:blank";

  targetItem.showcaseCanvasSubBox.thumbnailTooltipTitle = targetTitle;
  targetItem.showcaseCanvasSubBox.thumbnailTooltipURL = targetURL;
}

function showingThumbnailTooltip(event) {
  event.stopPropagation();

  var currentTitle = document.getElementById("thumbnailTooltipTitle");
  var currentURL = document.getElementById("thumbnailTooltipURL");
  var showTooltip = false;

  var targetNode = document.tooltipNode;
  if (targetNode.childNodes.length == 0) {
    targetNode = targetNode.parentNode;
  }

  if (thumbnailTooltipTitle && targetNode.thumbnailTooltipTitle) {
    currentTitle.removeAttribute("hidden");
    currentTitle.value = targetNode.thumbnailTooltipTitle;
    showTooltip = true;
  } else {
    currentTitle.setAttribute("hidden", true);
  }

  if (thumbnailTooltipURL && targetNode.thumbnailTooltipURL) {
    currentURL.removeAttribute("hidden");
    currentURL.value = targetNode.thumbnailTooltipURL;
    showTooltip = true;
  } else {
    currentURL.setAttribute("hidden", true);
  }
  return showTooltip;
}

function mosaicRefresh() {
  var thumbWidth = mosaicWidth / mosaicColumns;
  var thumbHeight = mosaicHeight / mosaicRows;
  var currentRow = 0;
  var currentColumn = 0;
  var c = 0;
  
  if (inZoomMode) {
    for (var i = 0; i < processedWindows.length; i++) {
      var targetWindow =  processedWindows[i];
      for (var j = 0; j<targetWindow.processedTabs.length; j++) {
        var targetTab = targetWindow.processedTabs[j];
        if (targetTab.showcaseCanvasBox) {
          // We just center them
          var yPosition = mosaicHeight / 2;
          var xPosition = mosaicWidth / 2;
          var topPosition = yPosition - targetTab.showcaseCanvasBox.height / 2;
          var leftPosition = xPosition - targetTab.showcaseCanvasBox.width / 2;
          targetTab.showcaseCanvasBox.setAttribute("top", topPosition);
          targetTab.showcaseCanvasBox.setAttribute("left", leftPosition);
          targetTab.showcaseCanvasBox.showcaseCenterX = xPosition;
          targetTab.showcaseCanvasBox.showcaseCenterY = yPosition;

          if (targetTab == zoomTargetThumbnail) {
            // Relocate the cursors...
            var targetBoxObject = document.getBoxObjectFor(targetTab.showcaseCanvas);
            var targetX = targetBoxObject.x - showcaseBox.boxObject.x;
            var targetY = targetBoxObject.y - showcaseBox.boxObject.y;
            var cursorUp = document.getElementById("cursor-up");
            cursorUp.setAttribute("top", targetY);
            cursorUp.setAttribute("left", targetX + targetBoxObject.width / 2 - 8);
            var cursorDown = document.getElementById("cursor-down");
            cursorDown.setAttribute("top", targetY + targetBoxObject.height - 19);
            cursorDown.setAttribute("left", targetX + targetBoxObject.width / 2 - 8);
            var cursorLeft = document.getElementById("cursor-left");
            cursorLeft.setAttribute("top", targetY + targetBoxObject.height / 2 - 8);
            cursorLeft.setAttribute("left", targetX + 1);
            var cursorRight = document.getElementById("cursor-right");
            cursorRight.setAttribute("top", targetY + targetBoxObject.height / 2 - 8);
            cursorRight.setAttribute("left", targetX + targetBoxObject.width - 17);
          }
        }
      }
    }
  } else {
    for (var i = 0; i < processedWindows.length; i++) {
      var targetWindow =  processedWindows[i];
      for (var j = 0; j<targetWindow.processedTabs.length; j++) {
        var targetTab = targetWindow.processedTabs[j];

        if (!targetTab.showcaseCanvasBox.hidden) {
          var yPosition = currentRow * thumbHeight + thumbHeight / 2;
          var xPosition = currentColumn * thumbWidth + thumbWidth / 2;
          var topPosition = yPosition - targetTab.showcaseCanvasBox.height / 2;
          var leftPosition = xPosition - targetTab.showcaseCanvasBox.width / 2;
          targetTab.showcaseCanvasBox.setAttribute("top", topPosition);
          targetTab.showcaseCanvasBox.setAttribute("left", leftPosition);

          targetTab.showcaseCanvasBox.showcaseCenterX = xPosition;
          targetTab.showcaseCanvasBox.showcaseCenterY = yPosition;
          targetTab.showcaseColumn = currentColumn;
          targetTab.showcaseRow = currentRow;

          currentColumn++;
          if (currentColumn >= mosaicColumns) {
            currentColumn = 0;
            currentRow++;
          }
        }
      }
    }
  }
}

function mosaicCalculateBestGrid(width, height) {
  var retValues = new Array(2);
  var numberRows, numberColumns;
  var currentWidth;
  var numTabs = 0;
  var maxTabWidth = -1;
  var maxTabHeight = -1;
  numberRows = 1;
  var maxWidth;
  
  for (var i=0; i<processedWindows.length; i++) {
    var targetWindow = processedWindows[i];
    for (var j=0; j<targetWindow.processedTabs.length; j++) {
      if (!targetWindow.processedTabs[j].showcaseCanvasBox.hidden) {
        numTabs++;
      }
    }
// TODO: use fast way when not searching?
//    numTabs += targetWindow.processedTabs.length;

    if (targetWindow.showcaseLastGoodWidth > maxTabWidth) {
      maxTabWidth = targetWindow.showcaseLastGoodWidth;
    }
    if (targetWindow.showcaseLastGoodHeight > maxTabHeight) {
      maxTabHeight = targetWindow.showcaseLastGoodHeight;
    }
  }

  var firstIteration = true;

  do {
    numberColumns = Math.floor(numTabs / numberRows);
    if ((numTabs % numberRows) > 0) {
      numberColumns++;
    }
    currentWidth = width / numberColumns - thumbnailBorderWidth;
    var thumbHeight = height / numberRows - thumbnailBorderHeight;
    var widthForHeight = thumbHeight * maxTabWidth / maxTabHeight;

    if (currentWidth > widthForHeight) {
      currentWidth = widthForHeight;
    }

    if (firstIteration || (currentWidth > maxWidth)) {
      retValues[0] = numberRows;
      retValues[1] = numberColumns;
      maxWidth = currentWidth;
      firstIteration = false;
    }
    numberRows++;
  } while (currentWidth >= maxWidth);

  // Return information for proportions
  retValues[2] = maxTabWidth;
  retValues[3] = maxTabHeight;
  retValues[4] = numTabs;

  return retValues;
}

// getTargetWindows
// Retrieves the target windows we want to "showcase"
function getTargetWindows() {
  var windowArray = new Array();
  if (globalMode) {
    // Target all windows
    var wm = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
    var windowIter;
    var windowIndex = 0;
    
    if (useWindowZOrder) {
      windowIter = wm.getZOrderDOMWindowEnumerator('navigator:browser', true);
    } else {
      windowIter = wm.getEnumerator('navigator:browser');
    }
    
    while (windowIter.hasMoreElements()) {
      windowArray[windowIndex] = windowIter.getNext();
      windowIndex++;
    }
    
    if ((windowIndex == 0) && useWindowZOrder) {
      // No windows?! Verify that with getEnumerator!
      windowIter = wm.getEnumerator('navigator:browser');
    
      while (windowIter.hasMoreElements()) {
        windowArray[windowIndex] = windowIter.getNext();
        windowIndex++;
      }
    }
  } else {
    // Target "this" window (which is an argument)
    windowArray[0] = getParentWindow();
  }

  return windowArray;
}

function getParentWindow() {
  if (localTargetWindow) {
    return localTargetWindow;
  } else if (window.opener) {
    return window.opener;
  } else {
    return QueryInterface(Components.interfaces.nsIInterfaceRequestor).getInterface(Components.interfaces.nsIWebNavigation).QueryInterface(Components.interfaces.nsIDocShellTreeItem).rootTreeItem.QueryInterface(Components.interfaces.nsIInterfaceRequestor).getInterface(Components.interfaces.nsIDOMWindow);
  }
}

function updateLoadingState(targetProgressTab) {
  targetProgressTab.showcaseCanvasBox.setAttribute("loading", targetProgressTab.showcaseProgressListener.progressListener.isLoading);

  if (currentIconsThumbnail && (currentIconsThumbnail.showcaseTab == targetProgressTab)) {
    checkThumbnailIconsState();
  }
}

function updateIEState(targetProgressTab) {
  targetProgressTab.showcaseCanvasBox.setAttribute("ietab", targetProgressTab.showcaseIETab);
}

function updateBlankState(targetProgressTab) {
  targetProgressTab.showcaseCanvasBox.setAttribute("blank", targetProgressTab.showcaseBlank);
}

function setEmbeddingState(targetProgressTab, newState, repaintThumbnail) {
  targetProgressTab.showcaseEmbedded = newState;

  if (newState) {
    if ((targetProgressTab.targetTab.contentDocument.contentType == 'video/quicktime') || (targetProgressTab.targetTab.contentDocument.contentType == 'video/x-quicktime')) {
      targetProgressTab.showcaseCanvasBox.setAttribute("plugintype", "quicktime");
    } else if (targetProgressTab.targetTab.contentDocument.contentType == "application/x-shockwave-flash") {
      targetProgressTab.showcaseCanvasBox.setAttribute("plugintype", "flash");
    } else if (targetProgressTab.targetTab.contentDocument.contentType == "application/pdf") {
      targetProgressTab.showcaseCanvasBox.setAttribute("plugintype", "pdf");
    } else {
      targetProgressTab.showcaseCanvasBox.setAttribute("plugintype", "generic");
    }
  } else {
    targetProgressTab.showcaseCanvasBox.removeAttribute("plugintype");
  }

  if (repaintThumbnail) {
    setTimeout(paintThumbnail, 0, targetProgressTab);
  }
}

function setImageState(targetProgressTab, newState) {
  targetProgressTab.showcaseImage = newState;

  if (newState) {
    targetProgressTab.showcaseCanvasBox.setAttribute("isimage", "true");
  } else {
    targetProgressTab.showcaseCanvasBox.removeAttribute("isimage");
  }
}

function closeShowcaseTab(targetProcessedTab) {
  var tabbrowser = targetProcessedTab.targetTabWindow.targetWindow.getBrowser();

  if (tabbrowser.mTabContainer.childNodes.length < 2) {
    if (closeLastTabKeepOpen) {
      // Blank tab
      tabbrowser.loadURI("about:blank");
    } else {
      closeProcessedWindow(targetProcessedTab.targetTabWindow);
    }
  } else if (targetProcessedTab.showcaseCanvasBox.hasAttribute("selectedtab")) {
    var showcaseRefocus = new ShowcaseRefocus(tabbrowser, tabbrowser.tabContainer, this);
    isWaitingRefocus = true;
    tabbrowser.tabContainer.addEventListener("select", showcaseRefocus, false);
    tabbrowser.removeCurrentTab();
  } else {
    tabbrowser.removeTab(targetProcessedTab.tabHeader);
  }
  
}

function closeShowcaseTabs(targetProcessedTabs) {
  for (var c=0; c<processedWindows.length; c++) {
    var currentProcessedWindow = processedWindows[c];
    var selectedFound = false;
    var selectedProcessedTab = null;
    var targetTabs = new Array();
    var deleteWindow = true;

    for (var d=0; d<currentProcessedWindow.processedTabs.length; d++) {
      var currentProcessedTab = currentProcessedWindow.processedTabs[d];
      if (targetProcessedTabs.indexOf(currentProcessedTab) > -1) {
        if (currentProcessedTab.showcaseCanvasBox.hasAttribute("selectedtab")) {
          selectedFound = true;
          selectedProcessedTab = currentProcessedTab;
        } else {
          targetTabs.push(currentProcessedTab);
        }
      } else {
        deleteWindow = false;
      }
    }
    
    if (deleteWindow && !closeLastTabKeepOpen) {
      //currentProcessedWindow.targetWindow.close();
      currentProcessedWindow.targetWindow.setTimeout(currentProcessedWindow.targetWindow.close, 0);
    } else {
      for (var e=0; e<targetTabs.length; e++) {
        closeShowcaseTab(targetTabs[e]);
      }
      
      if (selectedFound) {
        closeShowcaseTab(selectedProcessedTab);
      }
    }
  }
}

// Object ShowcaseRefocus
function ShowcaseRefocus(gBrowser, targetContainer, showcaseWindow) {
  this.gBrowser = gBrowser;
  this.targetContainer = targetContainer;
  this.showcaseWindow = showcaseWindow;
  this.targetWindow = null;
}

ShowcaseRefocus.prototype.handleEvent = function(evt){
  if (evt.type == 'select') {
    var browserWindow = this.gBrowser.selectedBrowser.contentWindow;
    browserWindow.addEventListener("focus", this, false);
    this.targetWindow = browserWindow;
    this.targetContainer.removeEventListener("select", this, false);
  } else if (evt.type == 'focus') {
    this.targetWindow.removeEventListener("focus", this, false);
    setTimeout(this.showcaseWindow.showcaseRefocusSelf, 0);
  }
}

function showcaseRefocusSelf() {
  focus();
  isWaitingRefocus = false;
}

function closeProcessedWindow(targetProcessedWindow) {
    if ((targetProcessedWindow.targetWindow.BrowserTryToCloseWindow) && (typeof(targetProcessedWindow.targetWindow.BrowserTryToCloseWindow) == "function")) {
      targetProcessedWindow.targetWindow.BrowserTryToCloseWindow();
    } else {
      targetProcessedWindow.targetWindow.close();
    }
}

function closeProcessedTabContentWindow(targetProcessedTab) {
  targetProcessedTab.targetTab.contentWindow.close();
}

function closeProcessedTabsContentWindow(targetProcessedTabs) {
  for (var c=0; c<targetProcessedTabs.length; c++) {
    targetProcessedTabs[c].targetTab.contentWindow.close();
  }
}

// Object TabProgressListener
function TabProgressListener(targetProgressTab ) {
  this.targetProgressTab = targetProgressTab;
  this.isLoading = false;
  this.processedContentType = false;
  this.processedImageSize = false;
  this.progressListener = 
{
    QueryInterface: function(aIID)
    {
     if (aIID.equals(Components.interfaces.nsIWebProgressListener) ||
         aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
         aIID.equals(Components.interfaces.nsISupports))
       return this;
     throw Components.results.NS_NOINTERFACE;
    },

    onStateChange: function(aProgress, aRequest, aStateFlags, aStatus) {
     // Update thumbnail when something happens with the browser it represents
     if ((aStateFlags & STATE_START) && (aStateFlags & STATE_IS_WINDOW)) {
       //setTimeout(checkIETab, 0, targetProgressTab);

       this.processedContentType = false;

       if (targetProgressTab.showcaseEmbedded) {
         setEmbeddingState(targetProgressTab, false, true);
       }

       if (targetProgressTab.showcaseImage) {
         setImageState(targetProgressTab, false);
         refreshContent();
       }

       if (updateThumbnailWhenContentLoaded || updateThumbnailWhenContentChanges) {
         createTooltip(targetProgressTab);
       }
     } else if ((aStateFlags & STATE_STOP) && (aStateFlags & STATE_IS_WINDOW)) {
       // checkIETab(targetProgressTab);
       if (targetProgressTab.showcaseImage && !this.processedImageSize) {
         refreshContent();
       }
       if (updateThumbnailWhenContentLoaded || updateThumbnailWhenContentChanges) {
         if (targetProgressTab.showcaseCanvas.showcasePainted) {
           setTimeout(createTooltip, 0, targetProgressTab);
           targetProgressTab.showcaseCanvas.showcasePainted = false;
           setTimeout(paintThumbnail, 0, targetProgressTab);
         }
       }
     } else if ((aStateFlags & STATE_TRANSFERRING) && (aStateFlags & STATE_IS_DOCUMENT)) {
       // Process targetProgressTab.targetTab.contentDocument.contentType
       if (targetProgressTab.targetTab.contentDocument && targetProgressTab.targetTab.contentDocument.contentType && !this.processedContentType) {
         checkEmbedding(targetProgressTab, true);
         checkImage(targetProgressTab, true);
         this.processedContentType = true;
         if (targetProgressTab.showcaseImage) {
           this.processedImageSize = checkImageSize(targetProgressTab);
         }
       } else if (targetProgressTab.showcaseImage && !this.processedImageSize) {
         this.processedImageSize = checkImageSize(targetProgressTab);
       }
     }

     
     if (this.isLoading &&
              (!limitContentChangeUpdates || !targetProgressTab.showcaseTransferringLastUpdated || (targetProgressTab.showcaseTransferringLastUpdated < (new Date()).valueOf()))
       ) {
       if (targetProgressTab.showcaseCanvas.showcasePainted) {
         targetProgressTab.showcaseCanvas.showcasePainted = false;
         setTimeout(paintThumbnail, 0, targetProgressTab);
       }
       setTimeout(createTooltip, 0, targetProgressTab);
       targetProgressTab.showcaseTransferringLastUpdated = (new Date()).valueOf() + limitContentChangeUpdatesTime;
     }

     return 0;
    },

    onLocationChange: function(aProgress, aRequest, aURI)
    {
     // This fires when the location bar changes i.e load event is confirmed
     // or when the user switches tabs
     checkIETab(targetProgressTab, aURI.spec);
     checkBlank(targetProgressTab, aURI.spec);

     return 0;
    },

    // For definitions of the remaining functions see XulPlanet.com
    onProgressChange: function() {return 0;},
    onStatusChange: function() {return 0;},
    onSecurityChange: function() {return 0;},
    onLinkIconAvailable: function(icon) { return 0;}
  }
  
  this.targetProgressTab.targetTab.addProgressListener(this.progressListener, Components.interfaces.nsIWebProgress.NOTIFY_ALL);
}

TabProgressListener.prototype.unloadListener = function(){
  try {
    this.targetProgressTab.targetTab.removeProgressListener(this.progressListener);
  } catch (e) {}
}

function checkIETab(targetProgressTab, aURL) {
  if (!detectIETab) return;

  var currentIETabState = (aURL.toString().substr(0, IETAB_URL.length) == IETAB_URL);
  if (currentIETabState != targetProgressTab.showcaseIETab) {
    targetProgressTab.showcaseIETab = currentIETabState;
    updateIEState(targetProgressTab);
    setTimeout(paintThumbnail, 0, targetProgressTab);
  }
  if (currentIETabState) {
    setTimeout(createTooltip, 0, targetProgressTab);
  }
}

function checkBlank(targetProgressTab, aURL) {
  if (!detectBlank) return;

  var currentURL = aURL.toString();
  var currentBlankState = ((currentURL == "") || (currentURL == "about:blank"));
  if (currentBlankState != targetProgressTab.showcaseBlank) {
    targetProgressTab.showcaseBlank = currentBlankState;
    updateBlankState(targetProgressTab);
    setTimeout(paintThumbnail, 0, targetProgressTab);
  }
}

function checkEmbedding(targetProgressTab, repaintThumbnail) {
  if ((detectPlugin) && (targetProgressTab.targetTab.contentDocument) && (targetProgressTab.targetTab.contentDocument.embeds) && (targetProgressTab.targetTab.contentDocument.embeds.length > 0) && (targetProgressTab.targetTab.contentDocument.contentType != CONTENTTYPE_HTML) && (targetProgressTab.targetTab.contentDocument.contentType != CONTENTTYPE_XHTML) && (targetProgressTab.targetTab.contentDocument.contentType != CONTENTTYPE_XUL)) {
    // Update embedding
    setEmbeddingState(targetProgressTab, true, repaintThumbnail);
  }
}

function checkImage(targetProgressTab) {
  if (!detectImage) return;
  if ((targetProgressTab.targetTab.contentDocument) && (targetProgressTab.targetTab.contentDocument instanceof ImageDocument)) {
    setImageState(targetProgressTab, true);
  } else {
    setImageState(targetProgressTab, false);
  }
}

function checkImageSize(targetProgressTab) {
  if ((targetProgressTab.targetTab.contentDocument.imageRequest.width > 0) && (targetProgressTab.targetTab.contentDocument.imageRequest.height > 0)) {
    refreshContent();
    return true;
  }
  return false;
}

// Object TabEventListener
function TabEventListener(targetTab, targetWindow, showcaseWindow) {
  this.listenTab = targetTab;
  this.tabwindow = targetWindow;
  this.showcaseWindow = showcaseWindow
}

TabEventListener.prototype.QueryInterface = function(aIID) {
  if (aIID.equals(Components.interfaces.nsITimerCallback) ||
      aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
      aIID.equals(Components.interfaces.nsISupports))
    return this;
  throw Components.results.NS_NOINTERFACE;
}

TabEventListener.prototype.handleEvent = function(evt){
  switch(evt.type){
    case 'resize': 
      // Update size
      try {
        this.tabwindow.showcaseLastGoodWidth = this.listenTab.targetTab.contentWindow.innerWidth;
        this.tabwindow.showcaseLastGoodHeight = this.listenTab.targetTab.contentWindow.innerHeight;
      } catch (e) {
        alert("tablisten1: " + e);
      }
      
      if (this.tabwindow.processedTabs) {
        for (var c=0; c<this.tabwindow.processedTabs.length; c++) {
          this.tabwindow.processedTabs[c].showcaseCanvasBox.showcaseCanvas.showcasePainted = false;
        }
      }
      setTimeout(this.showcaseWindow.refreshContent, 0);
      break;
    case 'DOMAttrModified':
      var attrName = evt.attrName;
      switch (attrName) {
        case "busy":
          var isBusy;
          if (evt.attrChange == evt.REMOVAL) {
            isBusy = false;
          } else {
            isBusy = (evt.newValue == "true");
          }
          if (isBusy != this.listenTab.showcaseProgressListener.progressListener.isLoading) {
            this.listenTab.showcaseProgressListener.progressListener.isLoading = isBusy;
            this.showcaseWindow.updateLoadingState(this.listenTab);
          }
          break;
        case "label":
          if (evt.attrChange == evt.REMOVAL) {
            this.listenTab.showcaseCanvasBox.showcaseLabel.removeAttribute("value");
            this.listenTab.showcaseCanvasBox.showcaseLabel.removeAttribute("tooltiptext");
            this.listenTab.showcaseCanvasBox.showcaseImageLabel.removeAttribute("tooltiptext");
          } else {
            this.listenTab.showcaseCanvasBox.showcaseLabel.setAttribute("value", evt.newValue);
            this.listenTab.showcaseCanvasBox.showcaseLabel.setAttribute("tooltiptext", evt.newValue);
            this.listenTab.showcaseCanvasBox.showcaseImageLabel.setAttribute("tooltiptext", evt.newValue);
          }
          break;
        case "image":
          if (evt.attrChange == evt.REMOVAL) {
            this.listenTab.showcaseCanvasBox.showcaseImageLabel.removeAttribute("src");
          } else {
            this.listenTab.showcaseCanvasBox.showcaseImageLabel.setAttribute("src", evt.newValue);
          }
          break;
        case "crop":
          if (evt.attrChange == evt.REMOVAL) {
            this.listenTab.showcaseCanvasBox.showcaseLabel.removeAttribute("crop");
          } else {
            this.listenTab.showcaseCanvasBox.showcaseLabel.setAttribute("crop", evt.newValue);
          }
          break;
      }
      break;
    case 'load':
      // repaint thumbnail
      this.listenTab.showcaseCanvasBox.showcaseCanvas.showcasePainted = false;
      setTimeout(this.showcaseWindow.paintThumbnail, 0, this.listenTab);
      break;
    case 'scroll':
      // set timer
      if ((this.showcaseWindow.inZoomMode) && (this.showcaseWindow.zoomTargetThumbnail == this.listenTab)) {
        this.listenTab.showcaseCanvasBox.showcaseCanvas.showcasePainted = false;
        this.showcaseWindow.checkScrollCursorsVisibility();
        setTimeout(this.showcaseWindow.paintThumbnail, 0, this.listenTab);
      } else {
        if (!this.listenTab._scrollTimer) {
          this.listenTab._scrollTimer = Components.classes["@mozilla.org/timer;1"].createInstance(Components.interfaces.nsITimer);
        }
        this.listenTab._scrollTimer.cancel();
        this.listenTab._scrollTimer.initWithCallback(this, 200, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
      }
      break;

//    case 'select':
//    case 'close':
//    case 'unload':
//      checkTabClosed(this.listenTab, this.tabbrowser);
//      setTimeout(checkTabClosed, 0, this.listenTab, this.tabwindow);
//      break;
  }
}

TabEventListener.prototype.notify = function(timer) {
  // repaint thumbnail
  this.listenTab.showcaseCanvasBox.showcaseCanvas.showcasePainted = false;
  setTimeout(this.showcaseWindow.paintThumbnail, 0, this.listenTab);
}

/*
function resizeTab(targetTab) {
  updateThumbnail(targetTab, thumbWidth, thumbHeight, thumbnailIdleSizeFactor / 100, thumbnailActiveSizeFactor / 100);
  if (targetTab.showcaseCanvas.showcasePainted) {
    targetTab.showcaseCanvas.showcasePainted = false;
    paintThumbnail(targetTab);
  }

  mosaicRefresh();
}
*/

// Object TabsChangeListener
function TabsChangeListener(targetWindow, showcaseWindow) {
  this.targetWindow = targetWindow;
  this.showcaseWindow = showcaseWindow;
}

TabsChangeListener.prototype.handleEvent = function(evt){
  switch(evt.type){
    case 'DOMNodeInserted':
      setTimeout(this.showcaseWindow.checkTabCreation, 0, this.targetWindow, 15);
      break;
    case 'DOMNodeRemoved':
      setTimeout(this.showcaseWindow.checkTabDestruction, 0, this.targetWindow);
      break;
    case 'select':
      setTimeout(this.showcaseWindow.updateBorders, 0, this.targetWindow);
      if (this.showcaseWindow.showOnlyCurrent) {
        setTimeout(this.showcaseWindow.refreshContent, 0, this.targetWindow);
      }
      /*#if !seamonkey*/
      if (this.showcaseWindow.synchFindBar) {
        checkSynchFindBar(this.targetWindow.targetWindow, this.showcaseWindow);
      }
      /*#endif*/
      setTimeout(this.showcaseWindow.ensureSelectedThumbnailVisible, 0, this.targetWindow);
      break;
  }

//  checkTabCreation(this.targetWindow);
}

function checkSynchFindBar(targetWindow, showcaseWindow) {
  // check if we're showcase tab
  if (targetWindow == showcaseWindow.topWindow) {
    if (showcaseWindow.top != showcaseWindow.topWindow) {
      // Check if this showcase tab has been selected
      var browser = targetWindow.getBrowser().selectedBrowser.contentWindow;
      if (browser.wrappedJSObject) {
        browser = browser.wrappedJSObject;
      }
      if (browser == showcaseWindow) {
        var findToolbar = targetWindow.document.getElementById("FindToolbar");
        if (!findToolbar.hidden) {
          if (targetWindow.closeFindBar) {
            targetWindow.closeFindBar();
          } else if (targetWindow.gFindBar) {
            targetWindow.gFindBar.closeFindBar();
          }
          setTimeout(toggleFind, 0);
        }
      } else if (showcaseWindow.searchActive) {
        if (browser.isShowcaseWindow) {
          browser.toggleFind();
        } else if (targetWindow.openFindBar) {
          targetWindow.openFindBar();
        } else if (targetWindow.gFindBar) {
          targetWindow.gFindBar.openFindBar();
        }
        showcaseWindow.toggleFind();
      }
    }
  }
}


function getProcessedTabForTab(targetTab, targetWindow) {
  var foundProcessedTab = null;

  for (var c=0; (c<targetWindow.processedTabs.length)&&!foundProcessedTab; c++) {
    if (targetWindow.processedTabs[c].targetTab == targetTab) {
      foundProcessedTab = targetWindow.processedTabs[c];
    }
  }

  return foundProcessedTab;
}

function checkTabCreation(targetProcessedWindow, attempts) {
  try {
  var found = false;
  var tabbrowser = targetProcessedWindow.targetWindow.getBrowser();
  var totalTabs = tabbrowser.tabContainer.childNodes.length;
  var tabsReordered = false;
  var currentProcessedIndex = 0;
  var orderedProcessedTabs = new Array();

  for (var j = 0; j< totalTabs; j++) {
    var currentTab = tabbrowser.tabContainer.childNodes.item(j);
    var targetTab = tabbrowser.getBrowserForTab(currentTab);
 
    if (targetTab.contentWindow && (!targetTab.contentWindow.isShowcaseWindow && (!targetTab.contentWindow.wrappedJSObject || !targetTab.contentWindow.wrappedJSObject.isShowcaseWindow))) {
      var currentProcessedTab = getProcessedTabForTab(targetTab, targetProcessedWindow);
      if (!currentProcessedTab) {
        var currentProcessedTab = new ProcessedTab(targetTab);

        // link new tab
        var newThumbnail = createThumbnail(currentTab, currentProcessedTab, tabbrowser, targetProcessedWindow);

        // insert in document
        showcaseBox.insertBefore(newThumbnail, selectionBox);

        // Set border, just in case this creation doesn't triggers a "select" event
        // (like "open link in tab"?)
        updateTabBorder(currentProcessedTab , targetProcessedWindow);

        targetProcessedWindow.processedTabs.push(currentProcessedTab);
        orderedProcessedTabs.push(currentProcessedTab);

        found = true;
        if (j < (totalTabs - 1)) {
          tabsReordered = true;
        }
      } else {
        orderedProcessedTabs.push(currentProcessedTab);
        if (!tabsReordered) {
          if (targetProcessedWindow.processedTabs[currentProcessedIndex].targetTab != targetTab) {
            tabsReordered = true;
          }
          currentProcessedIndex++;
        }
      }
    }
  }

  //Were tabs reordered?
  if (tabsReordered) {
    // Reset the listener
    if (orderedProcessedTabs.length > 1) {
      var foundProcessedTab = false;
      for (var c=0; (c<(orderedProcessedTabs.length-1)) && !foundProcessedTab; c++) {
        if (targetProcessedWindow.processedTabs[c] != orderedProcessedTabs[c]) {
          if (orderedProcessedTabs[c+1] == targetProcessedWindow.processedTabs[c]) {
            orderedProcessedTabs[c].tabHeader.removeEventListener("DOMAttrModified", orderedProcessedTabs[c].showcaseTabEventListener, false);
            orderedProcessedTabs[c].tabHeader.addEventListener("DOMAttrModified", orderedProcessedTabs[c].showcaseTabEventListener, false);
            foundProcessedTab = true;
          }
          if (orderedProcessedTabs[c] == targetProcessedWindow.processedTabs[c+1]) {
            targetProcessedWindow.processedTabs[c].tabHeader.removeEventListener("DOMAttrModified", targetProcessedWindow.processedTabs[c].showcaseTabEventListener, false);
            targetProcessedWindow.processedTabs[c].tabHeader.addEventListener("DOMAttrModified", targetProcessedWindow.processedTabs[c].showcaseTabEventListener, false);
            foundProcessedTab = true;
          }
        }
      }
    }
    targetProcessedWindow.processedTabs = orderedProcessedTabs;
    found = true;
  }

  if (found) {
    updateTitle();
    refreshContent();
  }
  } catch (e) {
    if (attempts > 0) {
      setTimeout(checkTabCreation, 10, --attempts);
    } else {
      alert("checkTabCreation - " + e);
    }
  }
}

function checkTabDestruction(targetProcessedWindow) {
  try {
  var found = false;
  var tabbrowser = targetProcessedWindow.targetWindow.getBrowser();
  var tabArray = new Array();

  for (var j = 0; j< tabbrowser.tabContainer.childNodes.length; j++) {
    tabArray[j] = tabbrowser.getBrowserForTab(tabbrowser.tabContainer.childNodes.item(j));
  }
  var tabArrayArgument = new DualArgument(tabArray, targetProcessedWindow);

  if (targetProcessedWindow.processedTabs.some(singleTabDestructionCheck, tabArrayArgument)) {
    updateTitle();
    setTimeout(refreshContent, 0);
  }

  } catch (e) { alert("checkTabDestruction - " + e); }
}

// Helper function that will check if an element is inside another
function singleTabDestructionCheck(element, index, array) {
  if ((this.firstArgument.indexOf(element.targetTab) == -1) && element.showcaseCanvasBox) {
    // Destruction found
    showcaseBox.removeChild(element.showcaseCanvasBox);
    unlinkProcessedTab(element, this.secondArgument);
    return true;
  }

  return false;
}

// Helper object that simply holds an argument
function DualArgument(firstArgument, secondArgument) {
  this.firstArgument = firstArgument;
  this.secondArgument = secondArgument;
}

function showShowcaseOptions() {
  /*#if seamonkey*/
  var NSIFILE = Components.interfaces.nsIFile;
  var dirLocator = Components.classes["@mozilla.org/file/directory_service;1"]
                             .getService(Components.interfaces.nsIProperties);
  var userChromePath = dirLocator.get("UChrm", NSIFILE).path;
  var file = Components.classes["@mozilla.org/file/local;1"]
                       .createInstance(Components.interfaces.nsILocalFile);
  file.initWithPath(userChromePath);
  file.append("xsidebar.jar");
  if(!file.exists()) {
    var seamonkeyShowcaseBundle = document.getElementById("bundle_seamonkeyshowcase");
    var confirmMessage = seamonkeyShowcaseBundle.getString("requiresXSidebar");
    var visitXsidebar = window.confirm(confirmMessage);

    if (visitXsidebar)
      openURL("http://xsidebar.mozdev.org");
    return;
  }
  /*#endif*/
  var features;
  try {
    var prefs = Components.classes["@mozilla.org/preferences-service;1"]
                          .getService(Components.interfaces.nsIPrefBranch);
    var instantApply = prefs.getBoolPref("browser.preferences.instantApply");
    features = "chrome,titlebar,toolbar,centerscreen," + (instantApply ? "dialog=no" : "modal,resizable");
  } catch (e) {
    features = "chrome,titlebar,toolbar,centerscreen,modal,resizable";
  }
  openDialog(OPTIONS_URL, "", features);
}

// Object ProcessedWindow
function ProcessedWindow(targetWindow) {
  this.targetWindow = targetWindow;
  this.processedTabs = new Array();
}

// Object ProcessedTab
function ProcessedTab(targetTab) {
  this.targetTab = targetTab;
}

// Search functions
function updateFind() {
  if (inZoomMode) {
    return;
  }

  var field = document.getElementById("find-field");
  var statusIcon = document.getElementById("find-status-icon");
  var statusText = document.getElementById("find-status");
  var invertField = document.getElementById("find-invert");

  var targetWindow;
  var targetProcessedTab;
  var noMatchingTabs = true;

  var value = field.value;
  var invert = invertField.getAttribute("checked");

  if (!searchActive || (value.length < 1)) {
    invertField.setAttribute("disabled", true);

    if (showOnlyCurrent) {
      updateShowOnlyCurrent();
    } else {
      for (var c=0; (c<processedWindows.length); c++) {
        targetWindow = processedWindows[c];
        for (var d=0; (d<targetWindow.processedTabs.length); d++) {
          targetProcessedTab = targetWindow.processedTabs[d];
          targetProcessedTab.showcaseCanvasBox.hidden = false;
        }
      }
    }

    noMatchingTabs = false;
  } else {
    invertField.setAttribute("disabled", false);

    var moreSpecificSearch = false;
    var lessSpecificSearch = false;
    // Check if we've just to update
    if ((!lastSearchCaseSensitive && searchCaseSensitive) ||
        ((lastSearchFindType == FINDTYPE_ANY) && (searchFindType != FINDTYPE_ANY)) ||
        ((value.indexOf(lastSearch) == 0) && (value.length > lastSearch.length))) {
      moreSpecificSearch = true;
    }
    if ((lastSearchCaseSensitive && !searchCaseSensitive) ||
        ((lastSearchFindType != FINDTYPE_ANY) && (searchFindType == FINDTYPE_ANY)) ||
        ((lastSearch.indexOf(value) == 0) && (lastSearch.length > value.length))) {
      lessSpecificSearch = true;
    }

    gFinder.caseSensitive = searchCaseSensitive;

    for (var c=0; (c<processedWindows.length); c++) {
      targetWindow = processedWindows[c];

      if (showOnlyCurrent) {
        var tabbrowser = targetWindow.targetWindow.getBrowser();
        var tabs = tabbrowser.mTabContainer.childNodes;
        var selectedTab = tabbrowser.getBrowserForTab(tabs[tabbrowser.mTabContainer.selectedIndex]);

        for (var j = 0; j<targetWindow.processedTabs.length; j++) {
          var targetProcessedTab = targetWindow.processedTabs[j];
          if (targetProcessedTab.targetTab == selectedTab) {
            if ((!moreSpecificSearch || !(targetProcessedTab.showcaseCanvasBox.hidden == invert)) ||
                (!lessSpecificSearch || !(targetProcessedTab.showcaseCanvasBox.hidden != invert))) {
              var res = checkTabFind(targetProcessedTab.targetTab, value);
  
              if ((res && !invert) || (!res && invert)) {
                noMatchingTabs = false;
                targetProcessedTab.showcaseCanvasBox.hidden = false;
              } else {
                targetProcessedTab.showcaseCanvasBox.hidden = true;
              }
            } else if (!targetProcessedTab.showcaseCanvasBox.hidden) {
              noMatchingTabs = false;
            }
          } else {
            targetProcessedTab.showcaseCanvasBox.hidden = true;
          }
        }
      } else {
        for (var d=0; (d<targetWindow.processedTabs.length); d++) {
          targetProcessedTab = targetWindow.processedTabs[d];

          if ((!moreSpecificSearch || (targetProcessedTab.showcaseCanvasBox.hidden == invert)) &&
              (!lessSpecificSearch || (targetProcessedTab.showcaseCanvasBox.hidden != invert))) {
            var res = checkTabFind(targetProcessedTab.targetTab, value);
  
            if ((res && !invert) || (!res && invert)) {
              noMatchingTabs = false;
              targetProcessedTab.showcaseCanvasBox.hidden = false;
            } else {
              targetProcessedTab.showcaseCanvasBox.hidden = true;
            }
          } else if (!targetProcessedTab.showcaseCanvasBox.hidden) {
            noMatchingTabs = false;
          }
        }
      }
    }
  }

  if (noMatchingTabs) {
    // We couldn't find any tabs. Show this to the user,and show ALL the tabs
    statusIcon.setAttribute("status", "notfound");

    if (!findPhraseNotFoundLabel) {
      var showcaseBundle = document.getElementById("bundle_showcase");
      findPhraseNotFoundLabel = showcaseBundle.getString("findPhraseNotFound");
    }

    if (window.sidebarFindBar) {
      statusIcon.setAttribute("hidden", false);
      statusIcon.setAttribute("tooltiptext", findPhraseNotFoundLabel);
    } else {
      statusText.value = findPhraseNotFoundLabel;
    }
    field.setAttribute("status", "notfound");      
    
    if (showOnlyCurrent) {
      updateShowOnlyCurrent();
    } else {
      // Show all the thumbnails
      for (var c=0; (c<processedWindows.length); c++) {
        targetWindow = processedWindows[c];
        for (var d=0; (d<targetWindow.processedTabs.length); d++) {
          targetWindow.processedTabs[d].showcaseCanvasBox.hidden = false;
        }
      }
    }
  } else {
    // Remove status
    statusIcon.removeAttribute("status");
    if (window.sidebarFindBar) {
      statusIcon.setAttribute("hidden", true);
      statusIcon.removeAttribute("tooltiptext");
    } else {
      statusText.value = "";
    }
    field.removeAttribute("status");

    // Save last correct search parameters
    lastSearchCaseSensitive = searchCaseSensitive;
    lastSearchFindType = searchFindType;
    lastSearch = value;
  }
}

function findTypeChanged(findType) {
  searchFindType = findType;
  refreshContent();
}

function checkTabFind(targetTab, value) {
  var found = false;
  
  if ((searchFindType == FINDTYPE_TITLE) || (searchFindType == FINDTYPE_ANY)) {
    if (targetTab.contentDocument && targetTab.contentDocument.title) {
      var targetTitle = targetTab.contentDocument.title;
      if (searchCaseSensitive) {
        found = (targetTitle.indexOf(value) > -1);
      } else {
        found = (targetTitle.toLowerCase().indexOf(value.toLowerCase()) > -1);
      }
    }
  }

  if (!found && ((searchFindType == FINDTYPE_LOCATION) || (searchFindType == FINDTYPE_ANY))) {
    if (targetTab.currentURI) {
      var targetLocation = targetTab.currentURI.spec;
      if (searchCaseSensitive) {
        found = (targetLocation.indexOf(value) > -1);
      } else {
        found = (targetLocation.toLowerCase().indexOf(value.toLowerCase()) > -1);
      }
    }
  }

  if (!found && ((searchFindType == FINDTYPE_CONTENT) || (searchFindType == FINDTYPE_ANY))) {
    try {
      found = findWindowContent(targetTab.contentWindow, value);
    } catch (e) {
      // Fail silently
    }
  }

  return found;
}

function findWindowContent(targetWindow, value) {
  var found;

  var body = targetWindow.document.body;
  var count = body.childNodes.length;
  var searchRange = targetWindow.document.createRange();
  searchRange.setStart(body, 0);
  searchRange.setEnd(body, count);
  var startPt = targetWindow.document.createRange();
  var endPt = targetWindow.document.createRange();
  startPt.setStart(body, 0);
  startPt.setEnd(body, 0);
  endPt.setStart(body, count);
  endPt.setEnd(body, count);

  found = gFinder.Find(value, searchRange, startPt, endPt);

  if (found) {
    return true;
  } else if (targetWindow.frames) {
    for (var c=0; (c<targetWindow.frames.length) && !found; c++) {
      found = findWindowContent(targetWindow.frames[c], value);
    }
  }

  return found;
}

function toggleSearchCaseSensitivity(caseSensitive) {
  this.searchCaseSensitive = caseSensitive;
  refreshContent();
}

function findShortcutAction() {
  if (!searchActive) {
    toggleFind();
  } else {
    selectFindBar();
    focusFindBar();
  }
}

function toggleFind() {
  if (window.sidebarFindBar) {
    if (findBarMode == 0) {
      selectFindBar();
      focusFindBar();
      return;
    } else if (findBarMode == 1) {
      return;
    }
  }

  var findToolbar = document.getElementById("FindToolbar");

  searchActive = !searchActive;

  findToolbar.setAttribute("hidden", !searchActive);
  if (searchActive) {
    selectFindBar();
    focusFindBar();
  } else {
    updateFind();
    showcaseBox.focus();
  }

  refreshContent();
}

function focusFindBar()
{
  var findField = document.getElementById("find-field");
  findField.focus();    
}

function selectFindBar()
{
  var findField = document.getElementById("find-field");
  findField.select();    
}

function onFindBarKeyPress(evt)
{
  if (evt.keyCode == KeyEvent.DOM_VK_RETURN) {
    openFoundSearchResult();
  }
  else if (evt.keyCode == KeyEvent.DOM_VK_ESCAPE) {
    toggleFind();
    evt.preventDefault();
  } 
  else if (evt.keyCode == KeyEvent.DOM_VK_PAGE_UP) {
    if (scrollBoxObject) scrollBoxObject.scrollBy(0, -scrollBoxObject.height);
    evt.preventDefault();
  }
  else if (evt.keyCode == KeyEvent.DOM_VK_PAGE_DOWN) {
    if (scrollBoxObject) scrollBoxObject.scrollBy(0, scrollBoxObject.height);
    evt.preventDefault();
  }
  else if (evt.keyCode == KeyEvent.DOM_VK_UP) {
    if (scrollBoxObject) scrollBoxObject.scrollByLine(-1);
    evt.preventDefault();
  }
  else if (evt.keyCode == KeyEvent.DOM_VK_DOWN) {
    if (scrollBoxObject) scrollBoxObject.scrollByLine(1);
    evt.preventDefault();
  }

} 

function onFindTypeKeyPress(evt, findTypeField)
{
  if (evt.keyCode == KeyEvent.DOM_VK_RETURN) {
    openFoundSearchResult();
  }
  else if (evt.keyCode == KeyEvent.DOM_VK_ESCAPE) {
    toggleFind();
    evt.preventDefault();
  } 
  else if (evt.keyCode == KeyEvent.DOM_VK_UP) {
    if (findTypeField.selectedIndex > 0) {
      findTypeField.selectedIndex--;
    } else {
      findTypeField.selectedIndex = findTypeField.firstChild.childNodes.length - 1;
    }
    evt.preventDefault();
  }
  else if (evt.keyCode == KeyEvent.DOM_VK_DOWN) {
    if (findTypeField.selectedIndex >= (findTypeField.firstChild.childNodes.length - 1)) {
      findTypeField.selectedIndex = 0;
    } else {
      findTypeField.selectedIndex++;
    }
    evt.preventDefault();
  }
} 

function openFoundSearchResult() {
  var firstVisibleFound = false;
  var firstVisibleTab = null;
  var secondVisibleFound = false;

  // if there's just one result, open it
  for (var c=0; (c<processedWindows.length) && !secondVisibleFound; c++) {
    var currentProcessedWindow = processedWindows[c];
    for (var d=0; (d<currentProcessedWindow.processedTabs.length) && !secondVisibleFound; d++) {
      var currentProcessedTab = currentProcessedWindow.processedTabs[d];
      if (!currentProcessedTab.showcaseCanvasBox.hidden) {
        // Is visible
        if (!firstVisibleFound) {
          firstVisibleFound = true;
          firstVisibleTab = currentProcessedTab;
        } else {
          secondVisibleFound = true;
        }
      }
    }
  }

  if (firstVisibleFound && !secondVisibleFound) {
    openTab(firstVisibleTab);
  }
}

function findTypeKeyInhibit(evt) {
  if ((evt.keyCode == KeyEvent.DOM_VK_RETURN) || (evt.keyCode == KeyEvent.DOM_VK_ESCAPE) || (evt.keyCode == KeyEvent.DOM_VK_UP) || (evt.keyCode == KeyEvent.DOM_VK_DOWN)) {
    evt.preventDefault();
  }
}


// Duplicate/Merge tabs functions

function moveTabsToNewWindow(closeDuplicated) {
  var currentIndex = 0, curBrowser, browsersArray = new Array();

  if (selectedTabs.length > 0) {
    for (var c=0; c<selectedTabs.length; c++) {
      var curBrowser = selectedTabs[c].targetTab;
      browsersArray[currentIndex] = [copyTabHistory(curBrowser.webNavigation.sessionHistory),
        curBrowser.contentWindow.scrollX, curBrowser.contentWindow.scrollY,
        curBrowser.markupDocumentViewer.textZoom,selectedTabs[c]];
      currentIndex++;
    }
  } else {
      var curBrowser = showcasePopupTab.targetTab;
      browsersArray[currentIndex] = [copyTabHistory(curBrowser.webNavigation.sessionHistory),
        curBrowser.contentWindow.scrollX, curBrowser.contentWindow.scrollY,
        curBrowser.markupDocumentViewer.textZoom,showcasePopupTab];
      currentIndex++;
  }

  // create new window
  isWaitingRefocus = true;
  var newWindow = processedWindows[0].targetWindow.openDialog(browserChromeURL, '_blank', 'chrome,all,dialog=no');
  
  var duplicateWindowListener = new DuplicateWindowListener(newWindow, browsersArray, closeDuplicated, this);
  newWindow.addEventListener('load', duplicateWindowListener, false);
}

function DuplicateWindowListener(newWindow, browsersArray, closeDuplicated, showcaseWindow) {
  this.newWindow = newWindow;
  this.browsersArray = browsersArray;
  this.closeDuplicated = closeDuplicated;
  this.showcaseWindow = showcaseWindow;
}

DuplicateWindowListener.prototype.handleEvent = function(evt){
  waitForSessionHistory(this.newWindow, this.browsersArray, 10, this.closeDuplicated);
  setTimeout(this.showcaseWindow.showcaseRefocusSelf, 0);

  // Unregister listener
  this.newWindow.removeEventListener("load", this, false);
}

function duplicateInNewWindow() {
  moveTabsToNewWindow(false);
}

function mergeInNewWindow() {
  // duplicate tabs, close the existing ones...
  moveTabsToNewWindow(true);
}


// add cloned tabs to a browser window
function setTabsInBrowser(aWindow, pages) {
  var y = 0, openedBrowser, newTab;
  var targetBrowser = aWindow.getBrowser();

  while (y < pages.length) {
    if (y == 0) {
      // Fill the first tab
      newTab = targetBrowser.mTabContainer.firstChild;
    } else {
      newTab = targetBrowser.addTab();
    }
    openedBrowser = targetBrowser.getBrowserForTab(newTab);
    setClonedContent(openedBrowser, pages[y]);
    y++;
  }
}

// sets previously cloned content into a browser (tab)
// Argument1 aBrowser: a newly created xul:browser to set the contents to
// Argument2 aClonedContents: an Array containing browser history, scrollposition and zoomfactor, to be set to the browser
function setClonedContent(aBrowser, aClonedContents) {
  if (aClonedContents[0].length == 0) return;

  cloneTabHistory(aBrowser.webNavigation, aClonedContents[0]);

  setScrollPosition(15, aBrowser, aClonedContents[1], aClonedContents[2]);
  setTextZoom(15, aBrowser, aClonedContents[3]);
}

function setTextZoom(attempts, newBrowser, aTextZoomValue) {
  newBrowser.markupDocumentViewer.textZoom = aTextZoomValue;
  if (attempts && (newBrowser.markupDocumentViewer.textZoom != aTextZoomValue)) {
    window.setTimeout(setTextZoom, 10,--attempts, newBrowser, aTextZoomValue);
    return;
  }
}

function setScrollPosition(attempts, newBrowser, aScrollValueX, aScrollValueY) {
  newBrowser.contentWindow.scrollTo(aScrollValueX, aScrollValueY);
  if (attempts && ((newBrowser.contentWindow.scrollX != aScrollValueX)||(newBrowser.contentWindow.scrollY != aScrollValueY))) {
    window.setTimeout(setScrollPosition, 10, --attempts, newBrowser, aScrollValueX, aScrollValueY);
    return;
  }
}

// Clone an array of history entries into a browsers webNavigation.sessionHistory
// Argument1 webNav: The webNavigation object of a newly created browser.
// Argument2 originalHistory: an array containing history entries from the original browser
function cloneTabHistory(webNav, originalHistory) {
  var newHistory = webNav.sessionHistory

  newHistory.QueryInterface(Components.interfaces.nsISHistoryInternal);

  // delete history entries if they are present
  if (newHistory.count > 0) newHistory.PurgeHistory(newHistory.count);

  for (var i = 0; i < originalHistory.length; i++) {
    var entry = originalHistory[i].QueryInterface(Components.interfaces.nsISHEntry);
    var newEntry = cloneHistoryEntry(entry);
    if (newEntry)
      newHistory.addEntry(newEntry, true);
  }

  // Goto current history location
  if (originalHistory.index < originalHistory.length) {
    try {
      webNav.gotoIndex(originalHistory.index);
    } catch(e) {
      window.setTimeout(webNav.gotoIndex, 0, originalHistory.index);
    }
  }
}

// copy a sessionHistory and put it into an array
// Argument1 originalHistory: webNavigation.sessionHistory browser history to be copied
// returns: an array containing a copy of the history
function copyTabHistory(originalHistory, aOnlyBack)  {
  // variables used in this function
  var backHistoryEnabled, forwardHistoryEnabled, forwardPagesNum, backPagesNum;
  var pageCount, currentPageNum, firstPageNum, lastPageNum;

  // check if copying forward or back history is enabled and checking for history length to be copied
  currentPageNum = originalHistory.index;
  lastPageNum = originalHistory.count-1;

  firstPageNum = 0;

  if (!aOnlyBack) {
    pageCount = lastPageNum+1;
  }
  else
    pageCount = currentPageNum+1;

  currentPageNum = currentPageNum-firstPageNum;

  var copiedHistory = new Array();
  for (var i = firstPageNum; i < pageCount; i++) {
    copiedHistory.push(originalHistory.getEntryAtIndex(i, false));
  }
  copiedHistory.index = currentPageNum;

  return copiedHistory;
}

function cloneHistoryEntry(aEntry) {
  if (!aEntry)
    return null;
  aEntry = aEntry.QueryInterface(Components.interfaces.nsISHContainer);
  var newEntry = aEntry.clone();
  newEntry = newEntry.QueryInterface(Components.interfaces.nsISHContainer);
  newEntry.loadType = Math.floor(aEntry.loadType);
  if (aEntry.childCount) {
    for (var j = 0; j < aEntry.childCount; j++) {
        var childEntry = cloneHistoryEntry(aEntry.GetChildAt(j));
        if (childEntry)
          newEntry.AddChild(childEntry, j);
    }
  }
  return newEntry;
}

function waitForSessionHistory(targetWindow, pages, attempts, closeDuplicated) {
  // Test if sessionHistory exists yet
  var webNav = targetWindow.getBrowser().webNavigation;
  try    {
    webNav.sessionHistory;
  } catch (err) {
    // webNav.sessionHistory is not yet available, try again later
    if (attempts) 
      window.setTimeout(waitForSessionHistory, 100, targetWindow, pages, --attempts, closeDuplicated);

    return;
  }
  if ((webNav.sessionHistory == null) && attempts) {
    window.setTimeout(waitForSessionHistory, 100, targetWindow, pages, --attempts, closeDuplicated);
    return;
  }

  var openedBrowser = targetWindow.getBrowser().mCurrentBrowser;
  setTabsInBrowser(targetWindow, pages);

  if (closeDuplicated) {
    var tabsArray = new Array();
    for (var c=0; c<pages.length; c++) {
      tabsArray[c] = pages[c][4];
    }
    closeShowcaseTabs(tabsArray);
  }
}

function selectionBoxStart(e) {
  if (e.button != 0) {
    return;
  }

  if (e.originalTarget != showcaseBox) {
    return;
  }

  if (selectionBox.hasAttribute("hidden")) {
    selectionBox.removeAttribute("hidden");
  }

  removeAllElements(originalSelection);
  if (!e.ctrlKey && !e.shiftKey) {
    removeAllSelections();
  } else {
    for (var c=0; c<selectedTabs.length; c++) {
      originalSelection.push(selectedTabs[c]);
    }
  }
  selectionStartX = e.layerX;
  selectionStartY = e.layerY;
  selectionEndX = e.layerX;
  selectionEndY = e.layerY;
  selectionBox.setAttribute("top", selectionStartY);
  selectionBox.setAttribute("left", selectionStartX);
  setSize(selectionBox, 0, 0);
}

function selectionBoxEnd(e) {
  if (e.button != 0) {
    return;
  }
  endSelection();
}

function endSelection() {
  if (!selectionBox.hasAttribute("hidden")) {
    selectionBox.setAttribute("hidden", true);
  }
}

function boxMouseOut(el) {
  if (dropBox.hasAttribute("hidden") && selectionBox.hasAttribute("hidden") && !inZoomMode) return;

  var hasExited = (el.relatedTarget != el.currentTarget);
  var currentNode = el.relatedTarget;

  if (currentNode) {
    while (hasExited && currentNode.parentNode) {
      hasExited = ((el.currentTarget != currentNode.parentNode) && (currentNode.localName != "tooltip"));
      currentNode = currentNode.parentNode;
    }
  }

  if (hasExited) {
    if (inZoomMode)
      leaveZoomMode();

    if (!selectionBox.hasAttribute("hidden"))
      endSelection();

    if (!dropBox.hasAttribute("hidden"))
      dropBox.setAttribute("hidden", "true");
  }
}

function selectionBoxCheck(e) {
  if (e.button != 0) {
    return;
  }
  if (selectionBox.hasAttribute("hidden")) {
    return;
  }

  var newWidth, newHeight;
  if (e.layerX < selectionStartX) {
    selectionBox.setAttribute("left", e.layerX);
    newWidth = selectionStartX - e.layerX;
  } else {
    selectionBox.setAttribute("left", selectionStartX);
    newWidth = e.layerX - selectionStartX - 1;
  }

  if (e.layerY < selectionStartY) {
    selectionBox.setAttribute("top", e.layerY);
    newHeight = selectionStartY - e.layerY;
  } else {
    selectionBox.setAttribute("top", selectionStartY);
    newHeight = e.layerY - selectionStartY - 1;
  }
  setSize(selectionBox, newWidth, newHeight);

  selectionEndX = e.layerX;
  selectionEndY = e.layerY;

  // Check for selection
  for (var c=0; c<processedWindows.length; c++) {
    var currentProcessedWindow = processedWindows[c];
    for (var d=0; d<currentProcessedWindow.processedTabs.length; d++) {
      var currentProcessedTab = processedWindows[c].processedTabs[d];
      if (!currentProcessedTab.showcaseCanvasBox.hidden) {
        if (checkTabInSelectionBox(currentProcessedTab)) {
          if (e.ctrlKey) {
            if (selectedTabs.indexOf(currentProcessedTab) > -1) {
              if (originalSelection.indexOf(currentProcessedTab) > -1) {
                removeFromSelection(currentProcessedTab);
              }
            } else if (originalSelection.indexOf(currentProcessedTab) < 0) {
              addToSelection(currentProcessedTab);
            }
          } else {
            if (selectedTabs.indexOf(currentProcessedTab) < 0) {
              addToSelection(currentProcessedTab);
            }
            var originalSelectionIndex = originalSelection.indexOf(currentProcessedTab);
            if (originalSelectionIndex > -1) {
              removeElementAt(originalSelection, originalSelectionIndex);
            }
          }
        } else {
          if (e.ctrlKey) {
            if (selectedTabs.indexOf(currentProcessedTab) > -1) {
              if (originalSelection.indexOf(currentProcessedTab) < 0) {
                removeFromSelection(currentProcessedTab);
              }
            } else if (originalSelection.indexOf(currentProcessedTab) > -1) {
              addToSelection(currentProcessedTab);
            }
          } else if ((selectedTabs.indexOf(currentProcessedTab) > -1) && (originalSelection.indexOf(currentProcessedTab) < 0)) {
            removeFromSelection(currentProcessedTab);
          }
        }
      }
    }
  }
}

function showcaseBoxCheckKey(el) {
  if (el.ctrlKey || el.altKey || el.metaKey) return;

  if (el.charCode >= 33) {
    var createdChar = String.fromCharCode(el.charCode);

    if ((createdChar != "+") && (createdChar != "-")) {
      var field = document.getElementById("find-field");

      if (!searchActive) {
        if (!window.sidebarFindBar || (findBarMode != 1)) {
          var findToolbar = document.getElementById("FindToolbar");
          searchActive = true;
          findToolbar.setAttribute("hidden", false);
        }
        field.value = createdChar;
      } else {
        field.value += createdChar;
      }
      field.inputField.focus();
      setTimeout(field.setSelectionRange, 0, field.length, field.length);

      refreshContent();
    }
  }
}

function checkTabInSelectionBox(targetTab) {
  var selectionLeft, selectionRight, selectionUp, selectionDown;
  if (selectionStartX < selectionEndX) {
    selectionLeft = selectionStartX;
    selectionRight = selectionEndX;
  } else {
    selectionRight = selectionStartX;
    selectionLeft = selectionEndX;
  }
  if (selectionStartY < selectionEndY) {
    selectionUp = selectionStartY;
    selectionDown = selectionEndY;
  } else {
    selectionUp = selectionEndY;
    selectionDown = selectionStartY;
  }
  if ((targetTab.showcaseCanvasBox.boxObject.x > selectionRight) || ((targetTab.showcaseCanvasBox.boxObject.width + targetTab.showcaseCanvasBox.boxObject.x) < selectionLeft)) {
    return false;
  }
  if ((targetTab.showcaseCanvasBox.boxObject.y > selectionDown) || ((targetTab.showcaseCanvasBox.boxObject.height + targetTab.showcaseCanvasBox.boxObject.y) < selectionUp)) {
    return false;
  }

  return true;
}

// Drag & drop
var thumbnailObserver = {
  onDragStart: function (evt,transferData,action) {
    var dataArray = new Array();
    var currentTime = new Date().getTime();

    if (selectedTabs.length > 1) {
      for (var c=0; c<selectedTabs.length; c++) {
        dataArray.push(createTransferDataForThumbnail(selectedTabs[c], currentTime.toString() + "-" + c));
      }
      transferData.data = new TransferDataSet(dataArray);
    } else {
      transferData.data = createTransferDataForThumbnail(evt.currentTarget.showcaseTab, currentTime.toString());
    }
  }
};

var boardObserver = {
  getSupportedFlavours : function () {
    var flavours = new FlavourSet();
    flavours.appendFlavour("text/x-showcase-tab");
    flavours.appendFlavour("text/x-moz-url");
    flavours.appendFlavour("application/x-moz-file", "nsIFile");
    return flavours;
  },

  onDragOver: function (evt,flavour,session) {
    // Drop line
    if (!session.canDrop) {
      dropBox.setAttribute("hidden", true);
      return;
    }
    dropBox.removeAttribute("hidden");
    var currentMosaicCol = Math.floor(evt.layerX * mosaicColumns / mosaicWidth);
    var currentMosaicRow = Math.floor(evt.layerY * mosaicRows / mosaicHeight);
    var targetTab = getTabAt(currentMosaicRow, currentMosaicCol);
    currentMosaicCol = targetTab.showcaseColumn;
    currentMosaicRow = targetTab.showcaseRow;
    var atLeftSide = ((evt.layerX - currentMosaicCol * mosaicWidth / mosaicColumns) < (mosaicWidth / (mosaicColumns * 2)))
    setSize(dropBox, 6, mosaicHeight / mosaicRows);
    dropBox.setAttribute("top", currentMosaicRow * mosaicHeight / mosaicRows);
    
    var isFrontier = false;
    if (atLeftSide) {
      if ((currentMosaicCol == 0) && (currentMosaicRow == 0)) {
        isFrontier = true;
      } else {
        var targetRow = currentMosaicRow;
        var targetColumn = currentMosaicCol;
        if (targetColumn > 0) {
          targetColumn--;
        } else {
          targetRow--;
          targetColumn = mosaicColumns - 1;
        }
        var prevTab = getTabAt(targetRow, targetColumn);
        if (prevTab.targetTabWindow != targetTab.targetTabWindow) {
          isFrontier = true;
        }
      }
    } else {
      var targetRow = currentMosaicRow;
      var targetColumn = currentMosaicCol;
      if (targetColumn < (mosaicColumns - 1)) {
        targetColumn++;
      } else {
        targetRow++;
        targetColumn = 0;
      }
      var nextTab = getTabAt(targetRow, targetColumn);
      if (nextTab == targetTab) {
        isFrontier = true;
      } else if (nextTab.targetTabWindow != targetTab.targetTabWindow) {
        isFrontier = true;
      }
    }

    if (atLeftSide && isFrontier) {
      dropBox.setAttribute("dropside", "left");
      dropBox.setAttribute("left", currentMosaicCol * mosaicWidth / mosaicColumns);
    } else if (isFrontier) {
      dropBox.setAttribute("dropside", "right");
      dropBox.setAttribute("left", (currentMosaicCol + 1) * mosaicWidth / mosaicColumns - 6);
    } else {
      dropBox.setAttribute("dropside", "middle");
      if (atLeftSide) {
        if (currentMosaicCol > 0) {
          dropBox.setAttribute("left", currentMosaicCol * mosaicWidth / mosaicColumns - 1);
        } else {
          dropBox.setAttribute("left", 0);
        }
      } else {
        if ((currentMosaicCol + 1) < mosaicColumns) {
          dropBox.setAttribute("left", (currentMosaicCol + 1) * mosaicWidth / mosaicColumns - 1);
        } else {
          dropBox.setAttribute("left", (currentMosaicCol + 1) * mosaicWidth / mosaicColumns - 2);
        }
      }
    }
  },

  onDragExit: function (aEvent, aDragSession) {
    dropBox.setAttribute("hidden", true);
  },

  onDrop: function (evt,dropdata,session) {
    dropBox.setAttribute("hidden", true);

    var currentMosaicCol = Math.floor(evt.layerX * mosaicColumns / mosaicWidth);
    var currentMosaicRow = Math.floor(evt.layerY * mosaicRows / mosaicHeight);
    var targetTab = getTabAt(currentMosaicRow, currentMosaicCol);
    currentMosaicCol = targetTab.showcaseColumn;
    currentMosaicRow = targetTab.showcaseRow;
    var atLeftSide = ((evt.layerX - currentMosaicCol * mosaicWidth / mosaicColumns) < (mosaicWidth / (mosaicColumns * 2)));
    var targetTabWindow = getProcessedWindowForProcessedTab(targetTab);
    var tabbrowser = targetTabWindow.targetWindow.getBrowser();


    const kDSIID      = Components.interfaces.nsIDragService;
    const kCopyAction = kDSIID.DRAGDROP_ACTION_COPY + kDSIID.DRAGDROP_ACTION_LINK;
    var moveIfPossible = !(session.dragAction & kCopyAction);

    /*#if seamonkey*/
    var insertionIndex = tabbrowser.getTabIndex(targetTab.tabHeader);
    /*#else*/
    var insertionIndex = targetTab.tabHeader._tPos;
    /*#endif*/

//try {
    var targets = getSelectionFromXferData(session);
    var processedTabsMoved = new Array();

    for (var d=0; d<targets.length; d++) {
      var currentProcessedTab = null;
      var currentTab = null;
      var currentTabHeader = null;
      var currentTabWindow = null;
      var urlTab = false;
      var isProcessed = true;
      if ((targets[d].type == "showcaseId") && (session.sourceDocument != null)) {

        // Try to find it in processed windows
        currentProcessedTab = findProcessedTabById(targets[d].value);

        if (currentProcessedTab == null) {
          isProcessed = false;
          // Make search in all windows...
          var searchResult = findTabById(targets[d].value);
          if (searchResult) {
            currentTab = searchResult.tab;
            currentTabHeader = searchResult.tabHeader;
            currentTabWindow = searchResult.window;
          }
        } else {
          currentTab = currentProcessedTab.targetTab;
          currentTabHeader = currentProcessedTab.tabHeader;
          currentTabWindow = getProcessedWindowForProcessedTab(currentProcessedTab).targetWindow;
        }
      } else if (targets[d].data) {
        // We're inserting a new URL if possible...
        var url = transferUtils.retrieveURLFromData(targets[d].data, targets[d].contentType);
        
        if (!url || !url.length || url.indexOf(" ", 0) != -1 ||
            /^\s*(javascript|data):/.test(url))
          continue;

        // Insert new tab
        var newTab = tabbrowser.addTab(url);
        currentTabWindow = targetTabWindow.targetWindow;
        currentTabHeader = newTab;
        currentTab = tabbrowser.getBrowserForTab(newTab);
        urlTab = true;
      }
      
      if (currentTab != null) {
        if ((currentTabWindow == targetTabWindow.targetWindow) && (moveIfPossible || urlTab)) {
          // Just move the tab
          if (atLeftSide) {
            /*#if seamonkey*/
            var currentTabPosition = tabbrowser.getTabIndex(currentTabHeader);
            if ((currentTabPosition < insertionIndex) && (insertionIndex > 0)) {
              tabbrowser.moveTabTo(currentTabPosition, insertionIndex - 1);
            } else {
              tabbrowser.moveTabTo(currentTabPosition, insertionIndex);
            }
            if (tabbrowser.getTabIndex(currentTabHeader) >= insertionIndex) {
              insertionIndex++;
            }
            /*#else*/
            if ((currentTabHeader._tPos < insertionIndex) && (insertionIndex > 0)) {
              tabbrowser.moveTabTo(currentTabHeader, insertionIndex - 1);
            } else {
              tabbrowser.moveTabTo(currentTabHeader, insertionIndex);
            }
            if (currentTabHeader._tPos >= insertionIndex) {
              insertionIndex++;
            }
            /*#endif*/
          } else {
            /*#if seamonkey*/
            var currentTabPosition = tabbrowser.getTabIndex(currentTabHeader);
            if (currentTabPosition >= insertionIndex) {
              insertionIndex++;
            }
            tabbrowser.moveTabTo(currentTabPosition, insertionIndex);
            /*#else*/
            if (currentTabHeader._tPos >= insertionIndex) {
              insertionIndex++;
            }
            tabbrowser.moveTabTo(currentTabHeader, insertionIndex);
            /*#endif*/
          }
        } else {
          // Insert new tab
          var newTab = tabbrowser.addTab(url);
          if (atLeftSide) {
            /*#if seamonkey*/
            var currentTabPosition = tabbrowser.getTabIndex(newTab);
            if ((currentTabPosition < insertionIndex) && (insertionIndex > 0)) {
              tabbrowser.moveTabTo(currentTabPosition , insertionIndex - 1);
            } else {
              tabbrowser.moveTabTo(currentTabPosition , insertionIndex);
            }
            if (tabbrowser.getTabIndex(newTab) >= insertionIndex) {
              insertionIndex++;
            }
            /*#else*/
            if ((newTab._tPos < insertionIndex) && (insertionIndex > 0)) {
              tabbrowser.moveTabTo(newTab, insertionIndex - 1);
            } else {
              tabbrowser.moveTabTo(newTab, insertionIndex);
            }
            if (newTab._tPos >= insertionIndex) {
              insertionIndex++;
            }
            /*#endif*/
          } else {
            /*#if seamonkey*/
            var currentTabPosition = tabbrowser.getTabIndex(newTab);
            if (currentTabPosition >= insertionIndex) {
              insertionIndex++;
            }
            tabbrowser.moveTabTo(currentTabPosition, insertionIndex);
            /*#else*/
            if (newTab._tPos >= insertionIndex) {
              insertionIndex++;
            }
            tabbrowser.moveTabTo(newTab, insertionIndex);
            /*#endif*/
          }

          var pageInfo = [copyTabHistory(currentTab.webNavigation.sessionHistory),
            currentTab.contentWindow.scrollX, currentTab.contentWindow.scrollY,
            currentTab.markupDocumentViewer.textZoom,currentProcessedTab];
          setClonedContent(newTab.linkedBrowser, pageInfo);

          if (moveIfPossible) {
            if (currentProcessedTab) {
              processedTabsMoved.push(currentProcessedTab);
            } else {
              currentTab.contentWindow.close();
            }
          }
        }
      }
    }
    if (processedTabsMoved.length > 0) {
      closeShowcaseTabs(processedTabsMoved);
    }
//} catch (e) { log(e); }
  },

  canHandleMultipleItems: true
};

function getSelectionFromXferData(aDragSession) {
    var selection    = [];
    var trans = Components.classes["@mozilla.org/widget/transferable;1"]
                          .createInstance(Components.interfaces.nsITransferable);
    if (aDragSession.sourceDocument != null) {
      trans.addDataFlavor("text/x-showcase-tab");
    }
    trans.addDataFlavor("text/x-moz-url");
    trans.addDataFlavor("text/x-moz-file");
    trans.addDataFlavor("text/unicode");
    var uri, extra, rSource, rParent, parent;
    for (var i = 0; i < aDragSession.numDropItems; ++i) {
      var bestFlavour = {}, dataObj = {}, len = {};
      aDragSession.getData(trans, i);
      trans.getAnyTransferData(bestFlavour, dataObj, len);
      dataObj = dataObj.value.QueryInterface(Components.interfaces.nsISupportsString);
      if (!dataObj)
        continue;
      var value = dataObj.data.substring(0, len.value);

      var newValue = {};
      newValue.value = value;
      switch (bestFlavour.value) {
      case "text/x-showcase-tab":
        newValue.type = "showcaseId";
        break;
      case "text/x-moz-url":
      case "text/x-moz-file":
      case "text/unicode":
        newValue.type = "url";
        newValue.contentType = bestFlavour.value;
        newValue.data = dataObj.data;
        break;
      }
      selection.push(newValue);
    }
    return selection;
}

function createTransferDataForThumbnail(targetProcessedTab, tabId) {
  var value;

  if (targetProcessedTab.targetTab.currentURI) {
    value = targetProcessedTab.targetTab.currentURI.spec;
  } else {
    value = "about:blank";
  }

  if ((detectIETab) && (value.substr(0, IETAB_URL.length) == IETAB_URL)) {
    value = value.substring(IETAB_URL.length);
  }

  var urlString = value + "\n" + targetProcessedTab.targetTab.contentDocument.title;
  var htmlString = "<a href=\"" + value + "\">" + targetProcessedTab.targetTab.contentDocument.title + "</a>";
  var targetTab = targetProcessedTab.targetTab;
  if (targetTab.wrappedJSObject) {
    targetTab = targetTab.wrappedJSObject;
  }
  var targetTabId = tabId.toString();
  if (targetTab.showcaseTabId) {
    targetTabId = targetTab.showcaseTabId;
  } else {
    targetTab.showcaseTabId = targetTabId;
  }
  var data = new TransferData();
  data.addDataForFlavour("text/x-showcase-tab", targetTabId);
  if ((value == "") || (value == "about:blank")) {
    data.addDataForFlavour("text/unicode", value);
  } else {
    data.addDataForFlavour("text/x-moz-url", urlString);
    data.addDataForFlavour("text/unicode", value);
    data.addDataForFlavour("text/html", htmlString);
  }

  return data;
}

function findProcessedTabById(targetId) {
  var foundProcessedTab = null;

  for (var c=0; (c<processedWindows.length)&&!foundProcessedTab; c++) {
    for (var d=0; (d<processedWindows[c].processedTabs.length)&&!foundProcessedTab; d++) {
      if (processedWindows[c].processedTabs[d].targetTab.showcaseTabId && (processedWindows[c].processedTabs[d].targetTab.showcaseTabId == targetId)) {
        foundProcessedTab = processedWindows[c].processedTabs[d];
      }
    }
  }

  return foundProcessedTab;
}

function findTabById(targetId) {
  // Target all windows
  var wm = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
  var windowIter;
  var result = null;
    
  windowIter = wm.getEnumerator('navigator:browser');
    
  while (windowIter.hasMoreElements() && !result) {
    var currentWindow = windowIter.getNext();
    var tabbrowser = currentWindow.getBrowser();
    var tabs = tabbrowser.mTabContainer.childNodes;
    var totalTabs = tabs.length;

    // search tabs
    for (var j = 0; (j< totalTabs) && !result; j++) {
      var targetTab = tabbrowser.getBrowserForTab(tabs[j]);
      if (targetTab.wrappedJSObject) targetTab = targetTab.wrappedJSObject;
      if (targetTab.showcaseTabId && (targetTab.showcaseTabId == targetId)) {
        result = {};
        result.window = currentWindow;
        result.tabHeader = tabs[j];
        result.tab = targetTab;
      }
    }
  }

  return result;
}

function getDataByContentType(transferData, targetContentType) {
  var data = null;
  for (var c=0; (c<transferData.dataList.length) && (data == null); c++) {
    if ((transferData.dataList[c].flavour) && (transferData.dataList[c].flavour.contentType == targetContentType)) {
      data = transferData.dataList[c].supports;
    }
  }
  return data;
}

// Thumbnail icons
function setCurrentIconsThumbnail(targetElement) {
  if (targetElement == null) {
    currentIconsThumbnail = null;
    hideThumbnailIcons();
    return;
  }

  var targetBox;

  if (targetElement.showcaseCanvas) { 
    targetBox = targetElement.showcaseCanvas.showcaseCanvasBox;
  } else {
    targetBox = targetElement.showcaseCanvasBox;
  }

  currentIconsThumbnail = targetBox;

  checkThumbnailIconsState();
  showThumbnailIcons();
}

function getThumbnailBackButton() {
  if (thumbnailBackButtonObject == null) {
    thumbnailBackButtonObject = document.getElementById("thumb-back");
  }
  return thumbnailBackButtonObject;
}

function getThumbnailForwardButton() {
  if (thumbnailForwardButtonObject == null) {
    thumbnailForwardButtonObject = document.getElementById("thumb-forward");
  }
  return thumbnailForwardButtonObject;
}

function getThumbnailReloadButton() {
  if (thumbnailReloadButtonObject == null) {
    thumbnailReloadButtonObject = document.getElementById("thumb-reload");
  }
  return thumbnailReloadButtonObject;
}

function getThumbnailStopButton() {
  if (thumbnailStopButtonObject == null) {
    thumbnailStopButtonObject = document.getElementById("thumb-stop");
  }
  return thumbnailStopButtonObject;
}

function checkThumbnailIconsState() {
  if (thumbnailBackButton) {
    var backButton = getThumbnailBackButton();
    if (currentIconsThumbnail.showcaseTab.targetTab.canGoBack) {
      backButton.removeAttribute("disabled");
    } else {
      backButton.setAttribute("disabled", true);
    }
  }
  if (thumbnailForwardButton) {
    var forwardButton = getThumbnailForwardButton();
    if (currentIconsThumbnail.showcaseTab.targetTab.canGoForward) {
      forwardButton.removeAttribute("disabled");
    } else {
      forwardButton.setAttribute("disabled", true);
    }
  }
  if (thumbnailReloadButton) {
    var reloadButton = getThumbnailReloadButton();

    var location;
    if (currentIconsThumbnail.showcaseTab.targetTab.currentURI) {
      location = currentIconsThumbnail.showcaseTab.targetTab.currentURI.spec;
    } else {
      location = "about:blank";
    }

    if (location == "about:blank" || location == "") {
      reloadButton.setAttribute("disabled", true);
    } else {
      reloadButton.removeAttribute("disabled");
    }
  }
  if (thumbnailStopButton) {
    var stopButton = getThumbnailStopButton();

    if (currentIconsThumbnail.showcaseTab.showcaseProgressListener.progressListener.isLoading) {
      stopButton.removeAttribute("disabled");
    } else {
      stopButton.setAttribute("disabled", true);
    }
  }
}

function showThumbnailIcons() {
  if (inZoomMode) return;

  var currentCanvasBox = document.getBoxObjectFor(currentIconsThumbnail.showcaseCanvas);

  // Count icons
  var numIcons = 0;
  var buttonsWidth = 0;
  var reachedWidthLimit = false;

  if (thumbnailBackButton && !reachedWidthLimit) {
    var backButton = getThumbnailBackButton();
    backButton.setAttribute("collapsed", false);
    if ((buttonsWidth + backButton.boxObject.width) <= currentCanvasBox.width) {
      buttonsWidth += backButton.boxObject.width;
      numIcons++;
    } else {
      reachedWidthLimit = true;
      backButton.setAttribute("collapsed", true);
    }
  }
  if (thumbnailForwardButton && !reachedWidthLimit) {
    var forwardButton = getThumbnailForwardButton();
    forwardButton.setAttribute("collapsed", false);
    if ((buttonsWidth + forwardButton.boxObject.width) <= currentCanvasBox.width) {
      buttonsWidth += forwardButton.boxObject.width;
      numIcons++;
    } else {
      reachedWidthLimit = true;
      forwardButton.setAttribute("collapsed", true);
    }
  }
  if (thumbnailStopButton && !reachedWidthLimit) {
    var stopButton = getThumbnailStopButton();
    stopButton.setAttribute("collapsed", false);
    if ((buttonsWidth + stopButton.boxObject.width) <= currentCanvasBox.width) {
      buttonsWidth += stopButton.boxObject.width;
      numIcons++;
    } else {
      reachedWidthLimit = true;
      stopButton.setAttribute("collapsed", true);
    }
  }
  if (thumbnailReloadButton && !reachedWidthLimit) {
    var reloadButton = getThumbnailReloadButton();
    reloadButton.setAttribute("collapsed", false);
    if ((buttonsWidth + reloadButton.boxObject.width) <= currentCanvasBox.width) {
      buttonsWidth += reloadButton.boxObject.width;
      numIcons++;
    } else {
      reachedWidthLimit = true;
      reloadButton.setAttribute("collapsed", true);
    }
  }

  if (numIcons == 0) return;

  // Determine thumbnail data
  var currentScrollX = {};
  var currentScrollY = {};
  var topScreenX;
  var topScreenY;
  if (scrollBoxObject) {
    scrollBoxObject.getPosition(currentScrollX, currentScrollY);
    topScreenX = scrollBoxObject.screenX;
    topScreenY = scrollBoxObject.screenY;
  } else {
    currentScrollX.value = 0;
    currentScrollY.value = 0;
    topScreenX = showcaseBox.boxObject.screenX;
    topScreenY = showcaseBox.boxObject.screenY;
  }

  var canvasLeft = currentCanvasBox.screenX - topScreenX + currentScrollX.value;
  var baseline = currentCanvasBox.screenY - topScreenY + currentScrollY.value + currentCanvasBox.height -1;

  var currentPosition = 1;

  var lastEnd = 0;
  // Locate and make visible
  if (thumbnailBackButton && (currentPosition <= numIcons)) {
    var backButton = getThumbnailBackButton();
    backButton.setAttribute("top", baseline - backButton.boxObject.height);
    var newLeft = canvasLeft + thumbIconCalculatePosition(currentPosition, numIcons, currentCanvasBox.width, backButton.boxObject.width);
    if (newLeft < lastEnd) {
      backButton.setAttribute("left", lastEnd);
      lastEnd = lastEnd + backButton.boxObject.width;
    } else {
      backButton.setAttribute("left", newLeft);
      lastEnd = newLeft + backButton.boxObject.width;
    }
    currentPosition++;
  }
  if (thumbnailForwardButton && (currentPosition <= numIcons)) {
    var forwardButton = getThumbnailForwardButton();
    forwardButton.setAttribute("top", baseline - forwardButton.boxObject.height);
    var newLeft = canvasLeft + thumbIconCalculatePosition(currentPosition, numIcons, currentCanvasBox.width, forwardButton.boxObject.width);
    if (newLeft < lastEnd) {
      forwardButton.setAttribute("left", lastEnd);
      lastEnd = lastEnd + forwardButton.boxObject.width;
    } else {
      forwardButton.setAttribute("left", newLeft);
      lastEnd = newLeft + forwardButton.boxObject.width;
    }
    currentPosition++;
  }
  if (thumbnailStopButton && (currentPosition <= numIcons)) {
    var stopButton = getThumbnailStopButton();
    stopButton.setAttribute("top", baseline - stopButton.boxObject.height);
    var newLeft = canvasLeft + thumbIconCalculatePosition(currentPosition, numIcons, currentCanvasBox.width, stopButton.boxObject.width);
    if (newLeft < lastEnd) {
      stopButton.setAttribute("left", lastEnd);
      lastEnd = lastEnd + stopButton.boxObject.width;
    } else {
      stopButton.setAttribute("left", newLeft);
      lastEnd = newLeft + stopButton.boxObject.width;
    }
    currentPosition++;
  }
  if (thumbnailReloadButton && (currentPosition <= numIcons)) {
    var reloadButton = getThumbnailReloadButton();
    reloadButton.setAttribute("top", baseline - reloadButton.boxObject.height);
    var newLeft = canvasLeft + thumbIconCalculatePosition(currentPosition, numIcons, currentCanvasBox.width, reloadButton.boxObject.width);
    if (newLeft < lastEnd) {
      reloadButton.setAttribute("left", lastEnd);
      lastEnd = lastEnd + reloadButton.boxObject.width;
    } else {
      reloadButton.setAttribute("left", newLeft);
      lastEnd = newLeft + reloadButton.boxObject.width;
    }
    currentPosition++;
  }
}


function thumbIconCalculatePosition(currentPosition, totalPositions, width, iconWidth) {
  if (totalPositions == 1) {
    return (width / 2) - (iconWidth / 2);
  } else {
    if (currentPosition == 1) {
      return 1;
    } else if (currentPosition == totalPositions) {
      return width - iconWidth - 1;
    } else {
      if (totalPositions == 3) {
        return (width / 2) - (iconWidth / 2);
      } else if (currentPosition == 2) {
        return (width / 3) - (iconWidth / 2);
      } else { //if (currentPosition == 3) {
        return (2 * width / 3) - (iconWidth / 2);
      }
    }
  }
}

function thumbIconPopulateBackMenu(event) {
  var menu = event.target;
          
  while (menu.firstChild)
    menu.removeChild(menu.firstChild);

  if ((currentIconsThumbnail)&&(currentIconsThumbnail.showcaseTab.targetTab.sessionHistory)) {
    var sessionHistory = currentIconsThumbnail.showcaseTab.targetTab.sessionHistory;
  
    var index = sessionHistory.index;
    var entry;
  
    var end = (index > 8) ? index - 8 : 0;
    if ((index - 1) < end) return false;
    for (var pos = index - 1; pos >= end; pos--) {
      entry = sessionHistory.getEntryAtIndex(pos, false);
      if (entry) {
        var menuitem = document.createElement("menuitem");
        menuitem.setAttribute("label", entry.title);
        menuitem.setAttribute("index", pos);
        menu.appendChild(menuitem);
      }
    }
  }
  return true;
}

function thumbIconPopulateForwardMenu(event) {
  var menu = event.target;
          
  while (menu.firstChild)
    menu.removeChild(menu.firstChild);

  if ((currentIconsThumbnail)&&(currentIconsThumbnail.showcaseTab.targetTab.sessionHistory)) {
    var sessionHistory = currentIconsThumbnail.showcaseTab.targetTab.sessionHistory;
  
    var index = sessionHistory.index;
    var count = sessionHistory.count;
    var entry;
    var end  = ((count-index) > 8) ? index + 8 : count - 1;
    if ((index + 1) > end) return false;
    for (var pos = index + 1; pos <= end; pos++) {
      entry = sessionHistory.getEntryAtIndex(pos, false);
      if (entry) {
        var menuitem = document.createElement("menuitem");
        menuitem.setAttribute("label", entry.title);
        menuitem.setAttribute("index", pos);
        menu.appendChild(menuitem);
      }
    }
  }
  return true;
}

function thumbIconGoToHistoryIndex(event) {
  var index = event.target.getAttribute("index");

  if (!index)
    return false;

  var targetWindow = getProcessedWindowForProcessedTab(currentIconsThumbnail.showcaseTab).targetWindow;

  var where;
  if (targetWindow.whereToOpenLink) {
    where = targetWindow.whereToOpenLink(event);
  } else {
    where = "current";
  }

  if (where == "current") {
    // Normal click.  Go there in the current tab and update session history.
    currentIconsThumbnail.showcaseTab.targetTab.gotoIndex(index);
    return true;
  } else {
    // Modified click.  Go there in a new tab/window.
    // This code doesn't copy history or work well with framed pages.

    var sessionHistory = currentIconsThumbnail.showcaseTab.targetTab.sessionHistory;
    var entry = sessionHistory.getEntryAtIndex(index, false);
    var url = entry.URI.spec;
    targetWindow.openUILinkIn(url, where);
    return true;
  }
}

function thumbIconBackCommand(event) {
  if ((!currentIconsThumbnail.showcaseTab.targetTab)||(!currentIconsThumbnail.showcaseTab.targetTab.docShell))
    return;

  if (event) {
    var targetWindow = getProcessedWindowForProcessedTab(currentIconsThumbnail.showcaseTab).targetWindow;

    var where;
    if (targetWindow.whereToOpenLink) {
      where = targetWindow.whereToOpenLink(event, false, false);
    } else {
      where = "current";
    }

    if (where == "current") {
      currentIconsThumbnail.showcaseTab.targetTab.goBack();
    } else {
      var sessionHistory = currentIconsThumbnail.showcaseTab.targetTab.sessionHistory;
      var currentIndex = sessionHistory.index;
      var entry = sessionHistory.getEntryAtIndex(currentIndex - 1, false);
      var url = entry.URI.spec;
      targetWindow.openUILinkIn(url, where);
    }
  } else {
    currentIconsThumbnail.showcaseTab.targetTab.goBack();
  }
}

function thumbIconForwardCommand(event) {
  if ((!currentIconsThumbnail.showcaseTab.targetTab)||(!currentIconsThumbnail.showcaseTab.targetTab.docShell))
    return;

  if (event) {
    var targetWindow = getProcessedWindowForProcessedTab(currentIconsThumbnail.showcaseTab).targetWindow;

    var where;
    if (targetWindow.whereToOpenLink) {
      where = targetWindow.whereToOpenLink(event, false, false);
    } else {
      where = "current";
    }

    if (where == "current") {
      currentIconsThumbnail.showcaseTab.targetTab.goForward();
    } else {
      var sessionHistory = currentIconsThumbnail.showcaseTab.targetTab.sessionHistory;
      var currentIndex = sessionHistory.index;
      var entry = sessionHistory.getEntryAtIndex(currentIndex + 1, false);
      var url = entry.URI.spec;
      targetWindow.openUILinkIn(url, where);
    }
  } else {
    currentIconsThumbnail.showcaseTab.targetTab.goForward();
  }
}

function thumbIconCheckMiddleClick(node, event) {
  if (event.button == 1) {
    var func = new Function("event",node.getAttribute("oncommand"));
    func.call(node,event);
    if ("tagName" in node) {
      if (node.namespaceURI == "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul" && (node.tagName == "menupopup" || node.tagName == "popup"))
        node.hidePopup();
    }
  }
}

function thumbIconReloadCommand(event) {
  if (event.shiftKey) {
    currentIconsThumbnail.showcaseTab.targetTab.webNavigation.reload(RELOAD_SKIP_CACHE_FLAGS);
  } else {
    currentIconsThumbnail.showcaseTab.targetTab.webNavigation.reload(RELOAD_FLAGS);
  }
}

function thumbIconStopCommand() {
  currentIconsThumbnail.showcaseTab.targetTab.webNavigation.stop(nsIWebNavigation.STOP_ALL);
}

function hideThumbnailIcons() {
  if (thumbnailBackButton) {
    getThumbnailBackButton().setAttribute("collapsed", true);
  }
  if (thumbnailForwardButton) {
    getThumbnailForwardButton().setAttribute("collapsed", true);
  }
  if (thumbnailStopButton) {
    getThumbnailStopButton().setAttribute("collapsed", true);
  }
  if (thumbnailReloadButton) {
    getThumbnailReloadButton().setAttribute("collapsed", true);
  }
}

// Log

function log(msg) {
  var consoleService = Components.classes["@mozilla.org/consoleservice;1"]
                                 .getService(Components.interfaces.nsIConsoleService);
  consoleService.logStringMessage(msg);
}
