var showcase_gPrefBranch = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("extensions.showcase.");

function showcase_initPrefs() {
	if(document.documentElement.getButton && document.documentElement.getButton('extra2')) {
		var extra2 = document.documentElement.getButton('extra2');
    extra2.setAttribute('type', 'menu');
		extra2.setAttribute('popup', 'showcase-settings-popup');
	}
}

function showcase_defaultSettings() {
	var strings = document.getElementById("prefsStrings");
	if(!confirm(strings.getString('prefs.confirm'))) return false;

	var count = { value : 0 };

      var childList = showcase_gPrefBranch.getChildList("", count);

	for(var i = 0; i < count.value; i++) {
		if(showcase_gPrefBranch.prefHasUserValue(childList[i]) && childList[i] != "changelog") {
			showcase_gPrefBranch.clearUserPref(childList[i]);
		}
	}

      window.alert(strings.getString('prefs.defaultsuccess'));
	return true;
}

function showcase_extendInt(aInput) {
	if(aInput < 10) return "0" + aInput.toString();
	else return aInput;
}

function showcase_exportSettings() {
	var now = new Date();
	var sDate = showcase_extendInt(now.getMonth() + 1) + "/" + showcase_extendInt(now.getDate()) + "/" + now.getFullYear();
	var sTtime = showcase_extendInt(now.getHours()) + ":" + showcase_extendInt(now.getMinutes()) + ":" + showcase_extendInt(now.getSeconds());
	var sGMT = now.toGMTString();

	var showcaseExport = new Array;
	showcaseExport[0] = "-----------------------------------------------------------------------\n";
	showcaseExport[0]+= "                         Showcase - Settings\n";
	showcaseExport[0]+= "          " + sDate + ", " + sTtime + " (" + sGMT + ")\n";
	showcaseExport[0]+= "-----------------------------------------------------------------------\n";
	showcaseExport[0]+= "                         DO NOT EDIT THIS FILE\n";
	showcaseExport[0]+= "-----------------------------------------------------------------------";

	var count = { value : 0 };
	var childList = showcase_gPrefBranch.getChildList("", count);

	for(var i = 0; i < count.value; i++) {
		try {
			switch(showcase_gPrefBranch.getPrefType(childList[i])) {
				case 	Components.interfaces.nsIPrefBranch.PREF_BOOL:
							showcaseExport[i+1] = childList[i] + '=' + showcase_gPrefBranch.getBoolPref(childList[i]);
							break;

				case 	Components.interfaces.nsIPrefBranch.PREF_INT:
							showcaseExport[i+1] = childList[i] + '=' + showcase_gPrefBranch.getIntPref(childList[i]);
							break;

				case 	Components.interfaces.nsIPrefBranch.PREF_STRING:
							showcaseExport[i+1] = childList[i] + '=' + showcase_gPrefBranch.getCharPref(childList[i]);
							break;
			}
		}
		catch(e) { }
	}

	showcaseExport.sort();
	showcase_saveToFile(showcaseExport);
}


function showcase_importSettings() {
	var strings = document.getElementById("prefsStrings");

	var pattern = showcase_loadFromFile();
  if(!pattern) return false;

  var i;
  var showcaseImport = new Array;
  var appendFilters = null;

  if(pattern[1].indexOf("Showcase - Settings") < 0) {
  	alert(strings.getString('prefs.invalid'));
  	return false;
  }

  if(!confirm(strings.getString('prefs.import'))) return false;

  for(i = 6; i < pattern.length; i++) {
  	var index = pattern[i].indexOf("=");

  	if(index > 0) {
  		showcaseImport[i] = [];
      showcaseImport[i].push(pattern[i].substring(0, index));
      showcaseImport[i].push(pattern[i].substring(index + 1, pattern[i].length));
		}
	}

	if(pattern[1].indexOf("Showcase - Settings") >= 0) {
	for(i = 6; i < showcaseImport.length; i++) {
			try {
				switch(showcase_gPrefBranch.getPrefType(showcaseImport[i][0])) {
					case Components.interfaces.nsIPrefBranch.PREF_BOOL:
							 showcase_gPrefBranch.setBoolPref(showcaseImport[i][0],/true/i.test(showcaseImport[i][1]));
               break;

          case Components.interfaces.nsIPrefBranch.PREF_INT:
               showcase_gPrefBranch.setIntPref(showcaseImport[i][0], showcaseImport[i][1]);
               break;

          case Components.interfaces.nsIPrefBranch.PREF_STRING:
               var pref = showcaseImport[i][1];
               if(pref.indexOf('"') == 0) // in prev version we use " " for string
							 		pref = pref.substring(1,pref.length - 1);
               showcase_gPrefBranch.setCharPref(showcaseImport[i][0], pref);
               break;
				}
			}
			catch(e) { }
		}

            window.alert(strings.getString('prefs.importsuccess'));
		return true;
	}

	alert(strings.getString('prefs.importfailed'));
	return false;
}


function showcase_saveToFile(patterns) {
  var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
  var stream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);

	var strings = document.getElementById("prefsStrings");

  fp.init(window, strings.getString('prefs.save'), fp.modeSave);
  fp.defaultExtension = 'showcase';
  fp.defaultString = strings.getString('prefs.defaultFileName') + '.' + fp.defaultExtension;
  fp.appendFilter(strings.getString('prefs.filter'), "*.showcase");
  fp.appendFilters(fp.filterAll);

  if(fp.show() != fp.returnCancel) {

    if(fp.file.exists()) fp.file.remove(true);
    fp.file.create(fp.file.NORMAL_FILE_TYPE, 0666);
    stream.init(fp.file, 0x02, 0x200, null);

    for(var i = 0; i < patterns.length; i++) {
      patterns[i] = patterns[i] + "\n";
      stream.write(patterns[i], patterns[i].length);
    }

    stream.close();
  } else {
  }
}


function showcase_loadFromFile() {
	var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
  var stream = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance(Components.interfaces.nsIFileInputStream);
  var streamIO = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance(Components.interfaces.nsIScriptableInputStream);

	var strings = document.getElementById("prefsStrings");

  fp.init(window, strings.getString('prefs.open'), fp.modeOpen);
  fp.defaultExtension = 'showcase';
  fp.appendFilter(strings.getString('prefs.filter'), "*.showcase");
  fp.appendFilters(fp.filterAll);

  if(fp.show() != fp.returnCancel) {

  	stream.init(fp.file, 0x01, 0444, null);
    streamIO.init(stream);

    var input = streamIO.read(stream.available());
    streamIO.close();
    stream.close();

    var linebreak = input.match(/(((\n+)|(\r+))+)/m)[1]; // first: whole match -- second: backref-1 -- etc..
    return input.split(linebreak);
  }

  return null;
}
