var showcaseCanvasCounter = 0;

// Tab cache
function ShowcaseTabCache(b)
{
	this.browser = b;
      this.thumb = null;
	b.showcaseCache = this;

	b.addEventListener("pageshow", this, true);
	b.addEventListener("resize", this, false);
      if (ShowcaseCache.updateThumbnailWhenScroll) {
  	  b.addEventListener("scroll", this, true);
      }
};

ShowcaseTabCache.prototype = {

QueryInterface: function(aIID) {
	if (aIID.equals(Components.interfaces.nsITimerCallback) ||
          aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
	    aIID.equals(Components.interfaces.nsISupports))
		return this;

	throw Components.results.NS_NOINTERFACE;
},

makeThumbnail: function () {
	if (this.browser.currentURI != null &&
	    this.browser.currentURI.spec == "about:blank") {
        this.thumb = null;
		return;
	}
      if (!ShowcaseCache.activateCache) {
        this.thumb = null;
        return;
       }

  var cacheWidth, cacheHeight;
  
  var targetWidth, targetHeight;

  if (ShowcaseCache.detectImage && (this.browser.contentDocument instanceof ImageDocument)) {
    var img = this.browser.contentDocument.imageRequest.decoderObserver;
    targetWidth = img.width;
    targetHeight = img.height;
  } else {
    targetWidth = this.browser.contentWindow.innerWidth;
    targetHeight = this.browser.contentWindow.innerHeight;
  }

  if (targetWidth > targetHeight) {
    if (targetWidth > ShowcaseCache.cacheSize) {
      cacheWidth = ShowcaseCache.cacheSize;
      cacheHeight = Math.ceil(ShowcaseCache.cacheSize * targetHeight / targetWidth);
    } else {
      cacheWidth = targetWidth;
      cacheHeight = targetHeight;
    }
  } else {
    if (targetHeight > ShowcaseCache.cacheSize) {
      cacheHeight = ShowcaseCache.cacheSize;
      cacheWidth = Math.ceil(ShowcaseCache.cacheSize * targetWidth / targetHeight);
    } else {
      cacheWidth = targetWidth;
      cacheHeight = targetHeight;
    }
  }
  
  if (this.thumb == null) {
    this.createThumbnail();
  }

  this.thumb.width = cacheWidth;
  this.thumb.height = cacheHeight;

  if (ShowcaseCache.currentShowcases.length < 1) {
    window.setTimeout(showcase_drawThumbnail, 0, this);
  }
},

createThumbnail: function() {
  this.thumb = document.createElementNS("http://www.w3.org/1999/xhtml", "canvas");
  this.thumb.id = "cachecanvas" + showcaseCanvasCounter++;
},

handleEvent: function (e) {
      if (ShowcaseCache.currentShowcases.length > 0)
        return;

      if (e.type == "scroll") {
        if (!this._scrollTimer) {
          this._scrollTimer = Components.classes["@mozilla.org/timer;1"].createInstance(Components.interfaces.nsITimer);
        }
        this._scrollTimer.cancel();
        this._scrollTimer.initWithCallback(this, 300, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
        this.waitingRepaint = true;
      } else {
  	  this.makeThumbnail();
      }
},

notify: function(timer) {
  this.makeThumbnail();
  this.waitingRepaint = false;
},

unload: function() {
      if (this.browser) {
  	  this.browser.removeEventListener("pageshow", this, true);
  	  this.browser.removeEventListener("resize", this, false);
        if (ShowcaseCache.updateThumbnailWhenScroll) {
          this.browser.removeEventListener("scroll", this, true);
        }

        this.browser.showcaseCache = null;
      }
      this.browser = null;
      if (this._scrollTimer) {
        this._scrollTimer.cancel();
        this._scrollTimer = undefined;
      }
      this.thumb = null;
}

};

function showcase_drawThumbnail(target) {
  if (target.drawingThumbnail) return;

  var currentWebBrowserPrint = target.browser.contentWindow.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
                   .getInterface(Components.interfaces.nsIWebBrowserPrint);

  if (currentWebBrowserPrint.doingPrint || currentWebBrowserPrint.doingPrintPreview) return;

  target.drawingThumbnail = true;
  try {
    var ctx = target.thumb.getContext("2d");
    ctx.clearRect(0, 0, target.thumb.width, target.thumb.height);

    if (ShowcaseCache.detectImage && (target.browser.contentDocument instanceof ImageDocument)) {
      var img = target.browser.contentDocument.imageRequest.decoderObserver;
      ctx.drawImage(img, 0, 0, target.thumb.width, target.thumb.height);
    } else {
      ctx.save();
      ctx.scale(target.thumb.width/target.browser.contentWindow.innerWidth, target.thumb.height/target.browser.contentWindow.innerHeight);

      ctx.drawWindow(target.browser.contentWindow, 
        target.browser.contentWindow.scrollX, 
        target.browser.contentWindow.scrollY, 
        target.browser.contentWindow.innerWidth, 
        target.browser.contentWindow.innerHeight, 
        "rgb(255,255,255)");
      ctx.restore();
    }
  } catch (e) {
    //Paint thumbnail failed, probably because the thumbnail disappeared. Fail silently.
  }
  target.drawingThumbnail = false;
}


var ShowcaseCache = {
  prefs: null,
  activateCache: false,
  cacheSize: 0,
  isCaching: false,
  detectImage: false,
  enhancedTabBar: false,
  allTabsButtonMode: -1,
  updateThumbnailWhenScroll: false,
  currentShowcases: null,
  

	QueryInterface: function (aIID)
	{
	if (aIID.equals(Components.interfaces.nsIPrefBranchInternal) ||
	    aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
	    aIID.equals(Components.interfaces.nsISupports))
		return this;

	throw Components.results.NS_NOINTERFACE;
	},

	observe: function (aSubject, aTopic, aData)
	{
	if (aTopic != "nsPref:changed")
		return;

	switch (aData) {
	case "extensions.showcase.cacheSize":
		ShowcaseCache.cacheSize = ShowcaseCache.prefs.getIntPref("cacheSize");
		break;
	case "extensions.showcase.activateCache":
		ShowcaseCache.activateCache = ShowcaseCache.prefs.getBoolPref("activateCache");
            if (ShowcaseCache.activateCache && !ShowcaseCache.isCaching) {
              ShowcaseCache.enableCaching();
            } else if (!ShowcaseCache.activateCache && ShowcaseCache.isCaching) {
              ShowcaseCache.disableCaching();
            }
            break;
	case "extensions.showcase.detectImage":
		ShowcaseCache.detectImage = ShowcaseCache.prefs.getBoolPref("detectImage");
            // Update image thumbnails if necessary
            if (ShowcaseCache.isCaching) {
              var totalTabs = getBrowser().tabContainer.childNodes.length;
              for (var d=0; d<totalTabs; d++) {
                var browser = getBrowser().getBrowserForTab(getBrowser().tabContainer.childNodes.item(d));
                if (browser.showcaseCache && (browser.contentDocument instanceof ImageDocument)) {
                  browser.showcaseCache.makeThumbnail();
                }
              }
            }
            break;
      case "extensions.showcase.updateThumbnailWhenScroll":
		ShowcaseCache.updateThumbnailWhenScroll = ShowcaseCache.prefs.getBoolPref("updateThumbnailWhenScroll");
            // Update image thumbnails if necessary
            if (ShowcaseCache.isCaching) {
              var totalTabs = getBrowser().tabContainer.childNodes.length;
              for (var d=0; d<totalTabs; d++) {
                var browser = getBrowser().getBrowserForTab(getBrowser().tabContainer.childNodes.item(d));
                if (browser.showcaseCache) {
                  if (ShowcaseCache.updateThumbnailWhenScroll) {
 			  browser.addEventListener("scroll", browser.showcaseCache, true);
                  } else {
			  browser.removeEventListener("scroll", browser.showcaseCache, true);
                  }
                }
              }
            }
            break;
	case "extensions.showcase.enhancedTabBar":
            var newEnhancedTabBar = ShowcaseCache.prefs.getBoolPref("enhancedTabBar n");
            if (newEnhancedTabBar != ShowcaseCache.enhancedTabBar ) {
              if (newEnhancedTabBar ) {
                ShowcaseCache.registerEnhancedTabBar();
              } else {
                ShowcaseCache.unregisterEnhancedTabBar();
              }
              ShowcaseCache.enhancedTabBar  = newEnhancedTabBar ;
            }

            break;
	case "extensions.showcase.allTabsButtonMode":
            ShowcaseCache.allTabsButtonMode = ShowcaseCache.prefs.getIntPref("allTabsButtonMode");
            break;
	}
	},


    catchNewTab: function(event) {
      if (event.currentTarget != getBrowser().mPanelContainer)
        return;
      var targetPanel;
      if (event.target.childNodes[1]) {
        targetPanel = event.target.childNodes[1];
      } else {
        targetPanel = event.target;
      }

      if (!targetPanel.showcaseCache) {
        (new ShowcaseTabCache(targetPanel)).makeThumbnail();
      }
	},

     firefox2CatchNewTab: function(event) {
      var targetPanel = event.target.linkedBrowser;
      if (!targetPanel.showcaseCache) {
        (new ShowcaseTabCache(targetPanel)).makeThumbnail();
      }
     },

	catchDestroyTab: function(event) {
        if (event.relatedNode != getBrowser().mPanelContainer)
          return;
      var targetPanel;
      if (event.target.childNodes[1]) {
        targetPanel = event.target.childNodes[1];
      } else {
        targetPanel = event.target;
      }
      if (targetPanel.showcaseCache) {
        targetPanel.showcaseCache.unload();
        targetPanel.showcaseCache = undefined;
      }
	},

     firefox2CatchDestroyTab: function(event) {
      var targetPanel = event.target.linkedBrowser;
      if (targetPanel.showcaseCache) {
        targetPanel.showcaseCache.unload();
      }
     },
    
     catchUpDoubleClick: function(event) {
       var targetScrollBox = getBrowser().mTabContainer.mTabstrip;
       var scrollSize = { };

       if (targetScrollBox.getAttribute("orient") == "horizontal") {
         targetScrollBox.scrollBoxObject.getScrolledSize(scrollSize, {});
       } else {
         targetScrollBox.scrollBoxObject.getScrolledSize({}, scrollSize);
       }
       getBrowser().mTabContainer.mTabstrip.scrollByPixels(-scrollSize.value);
     },

     catchDownDoubleClick: function(event) {
       var targetScrollBox = getBrowser().mTabContainer.mTabstrip;
       var scrollSize = { };

       if (targetScrollBox.getAttribute("orient") == "horizontal") {
         targetScrollBox.scrollBoxObject.getScrolledSize(scrollSize, {});
       } else {
         targetScrollBox.scrollBoxObject.getScrolledSize({}, scrollSize);
       }
       getBrowser().mTabContainer.mTabstrip.scrollByPixels(scrollSize.value);
     },

    registerEnhancedTabBar: function() {
      try {
        var gBrowser = getBrowser();
        gBrowser.mTabContainer.mAllTabsPopup.addEventListener("popupshowing", ShowcaseCache.catchAllTabsPopupShowing, false);
        if (typeof(gBrowser.mTabContainer.mAllTabsButton) != "undefined") {
          gBrowser.mTabContainer.mAllTabsButton.setAttribute("context", "showcaseAllTabsPopup");
        } else {
          gBrowser.mTabContainer.mAllTabsBoxAnimate.nextSibling.setAttribute("context", "showcaseAllTabsPopup");
        }
        gBrowser.mTabContainer.mTabstrip._scrollButtonUp.setAttribute("context", "showcaseLeftTabsPopup");
        gBrowser.mTabContainer.mTabstrip._scrollButtonDown.setAttribute("context", "showcaseRightTabsPopup");
        gBrowser.mTabContainer.mTabstrip._scrollButtonUp.setAttribute("tooltip", "showcaseTooltipLeftArrow");
        gBrowser.mTabContainer.mTabstrip._scrollButtonDown.setAttribute("tooltip", "showcaseTooltipRightArrow");
        if (!gBrowser.mTabContainer.mTabstrip._scrollButtonUp.originalOnMouseDown) {
          gBrowser.mTabContainer.mTabstrip._scrollButtonUp.originalOnMouseDown = gBrowser.mTabContainer.mTabstrip._scrollButtonUp.getAttribute("onmousedown");
        }
        gBrowser.mTabContainer.mTabstrip._scrollButtonUp.setAttribute("onmousedown", "if ((event.button != 2) && (!event.ctrlKey)) { " + gBrowser.mTabContainer.mTabstrip._scrollButtonUp.originalOnMouseDown + " }");
        if (!gBrowser.mTabContainer.mTabstrip._scrollButtonDown.originalOnMouseDown) {
          gBrowser.mTabContainer.mTabstrip._scrollButtonDown.originalOnMouseDown = gBrowser.mTabContainer.mTabstrip._scrollButtonDown.getAttribute("onmousedown");
        }
        gBrowser.mTabContainer.mTabstrip._scrollButtonDown.setAttribute("onmousedown", "if ((event.button != 2) & (!event.ctrlKey)) { " + gBrowser.mTabContainer.mTabstrip._scrollButtonDown.originalOnMouseDown + " }");
        gBrowser.mTabContainer.mTabstrip._scrollButtonUp.addEventListener("dblclick", ShowcaseCache.catchUpDoubleClick, false);
        gBrowser.mTabContainer.mTabstrip._scrollButtonDown.addEventListener("dblclick", ShowcaseCache.catchDownDoubleClick, false);
      } catch (e) {
      }
    },

    unregisterEnhancedTabBar: function() {
      try {
        var gBrowser = getBrowser();
        gBrowser.mTabContainer.mAllTabsPopup.removeEventListener("popupshowing", ShowcaseCache.catchAllTabsPopupShowing, false);
        if (typeof(gBrowser.mTabContainer.mAllTabsButton) != "undefined") {
          gBrowser.mTabContainer.mAllTabsButton.setAttribute("context", "");
        } else {
          gBrowser.mTabContainer.mAllTabsBoxAnimate.nextSibling.setAttribute("context", "");
        }
        gBrowser.mTabContainer.mTabstrip._scrollButtonUp.setAttribute("context", "");
        gBrowser.mTabContainer.mTabstrip._scrollButtonDown.setAttribute("context", "");
        gBrowser.mTabContainer.mTabstrip._scrollButtonUp.setAttribute("tooltip", "");
        gBrowser.mTabContainer.mTabstrip._scrollButtonDown.setAttribute("tooltip", "");
        if (gBrowser.mTabContainer.mTabstrip._scrollButtonUp.originalOnMouseDown) {
          gBrowser.mTabContainer.mTabstrip._scrollButtonUp.setAttribute("onmousedown", gBrowser.mTabContainer.mTabstrip._scrollButtonUp.originalOnMouseDown);
        }
        if (gBrowser.mTabContainer.mTabstrip._scrollButtonDown.originalOnMouseDown) {
          gBrowser.mTabContainer.mTabstrip._scrollButtonDown.originalOnMouseDown.setAttribute("onmousedown", gBrowser.mTabContainer.mTabstrip._scrollButtonDown.originalOnMouseDown);
        }
        gBrowser.mTabContainer.mTabstrip._scrollButtonUp.removeEventListener("dblclick", ShowcaseCache.catchUpDoubleClick, false);
        gBrowser.mTabContainer.mTabstrip._scrollButtonDown.removeEventListener("dblclick", ShowcaseCache.catchDownDoubleClick, false);
      } catch (e) {}
    },
    
    calculateHiddenTabsLeft: function() {
       var targetScrollBox = getBrowser().mTabContainer.mTabstrip;
       var tabs = getBrowser().mTabContainer.childNodes;
       var scrollSize = { };

       if (targetScrollBox.getAttribute("orient") == "horizontal") {
         var xPos = { }
         targetScrollBox.scrollBoxObject.getPosition(xPos, {});
         if (xPos.value == 0)
           return 0;
         var currentX = 0;
         var currentTab = 0;
         while ((currentX < xPos.value) && (currentTab < tabs.length)) {
           currentX += tabs[currentTab].boxObject.width;
           currentTab++;
         }
         return currentTab;
       } else {
         var yPos = { }
         targetScrollBox.scrollBoxObject.getPosition({}, yPos);
         if (yPos.value == 0)
           return 0;
         var currentY = 0;
         var currentTab = 0;
         while ((currentY < yPos.value) && (currentTab < tabs.length)) {
           currentY += tabs[currentTab].boxObject.height;
           currentTab++;
         }
         return currentTab;
       }
    },

    calculateHiddenTabsRight: function() {
       var targetScrollBox = getBrowser().mTabContainer.mTabstrip;
       var tabs = getBrowser().mTabContainer.childNodes;
       var scrollSize = { };

       if (targetScrollBox.getAttribute("orient") == "horizontal") {
         var width = { };
         targetScrollBox.scrollBoxObject.getScrolledSize(width, {});
         var xPos = { }
         targetScrollBox.scrollBoxObject.getPosition(xPos, {});
         var currentX = width.value;
         var currentTab = tabs.length - 1;
         while ((currentX > (targetScrollBox._scrollbox.boxObject.width + xPos.value)) && (currentTab >= 0)) {
           currentX -= tabs[currentTab].boxObject.width;
           currentTab--;
         }
         return (tabs.length - 1 - currentTab);
       } else {
         var height  = { };
         targetScrollBox.scrollBoxObject.getScrolledSize({}, height);
         var yPos = { }
         targetScrollBox.scrollBoxObject.getPosition({}, yPos);
         var currentY = height.value;
         var currentTab = tabs.length - 1;
         while ((currentY > (targetScrollBox._scrollbox.boxObject.height + yPos.value)) && (currentTab >= 0)) {
           currentY = tabs[currentTab].boxObject.height;
           currentTab--;
         }
         return (tabs.length - 1 - currentTab);
       }
    },

    onLoad: function() {
      ShowcaseCache.currentShowcases = new Array();
      ShowcaseCache.prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("extensions.showcase.");
      ShowcaseCache.activateCache = ShowcaseCache.prefs.getBoolPref("activateCache");
      ShowcaseCache.cacheSize = ShowcaseCache.prefs.getIntPref("cacheSize");
      ShowcaseCache.detectImage = ShowcaseCache.prefs.getBoolPref("detectImage");
      ShowcaseCache.updateThumbnailWhenScroll = ShowcaseCache.prefs.getBoolPref("updateThumbnailWhenScroll");
      ShowcaseCache.enhancedTabBar  = ShowcaseCache.prefs.getBoolPref("enhancedTabBar");
      ShowcaseCache.allTabsButtonMode = ShowcaseCache.prefs.getIntPref("allTabsButtonMode");

      /*#if seamonkey*/
	Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranchInternal).addObserver("extensions.showcase.", this, false);
      /*#else*/
	Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch2).addObserver("extensions.showcase.", this, false);
      /*#endif*/

      if (ShowcaseCache.activateCache) {
        ShowcaseCache.enableCaching();
      }

      // Catch event if necessary
      if (ShowcaseCache.enhancedTabBar  && getBrowser().mTabContainer.mAllTabsPopup) {
        ShowcaseCache.registerEnhancedTabBar();
      }

      setTimeout(function() {ShowcaseCache.showWelcomeScreenIfNeeded() }, 400);


      },

      showWelcomeScreenIfNeeded: function() {
        if (ShowcaseCache.prefs.getBoolPref("firstRunRedirection")) {
          var currentVersion = ShowcaseCache.prefs.getCharPref("currentVersion");

          if (currentVersion != "/*#echo version*/") {
            ShowcaseCache.prefs.setCharPref("currentVersion", "/*#echo version*/");
            var targetURL;
            if (currentVersion == "none") {
              targetURL = "http://showcase.uworks.net/welcome.html";
            } else {
              targetURL = "http://showcase.uworks.net/updated.html";
            }
            var newTab = getBrowser().addTab(targetURL);
            getBrowser().selectedTab = newTab;
          }
        }
      },

      catchAllTabsPopupShowing: function(ev) {
        switch (ShowcaseCache.allTabsButtonMode) {
          case 0:
            setTimeout(showShowcase, 0, false, false);
            break;
          case 1:
            setTimeout(showShowcase, 0, true, false);
            break;
          case 2:
            setTimeout(showShowcase, 0, false, true);
            break;
          case 3:
            setTimeout(showShowcase, 0, true, true);
            break;
          case 4:
            setTimeout(toggleSidebar, 0, 'viewShowcaseSidebar');
            break;
          case 5:
            setTimeout(toggleSidebar, 0, 'viewShowcaseThisWindowSidebar');
            break;
        }
        if (getBrowser().mTabContainer.mAllTabsPopup._onHidingAllTabsPopup)
          getBrowser().mTabContainer.mAllTabsPopup._onHidingAllTabsPopup();

        ev.preventDefault();
        return false;
      },

      enableCaching: function() {
      if (ShowcaseCache.isCaching) return;
      if (typeof BrowserOpenAddonsMgr == "function") {
        getBrowser().tabContainer.addEventListener("TabOpen", ShowcaseCache.firefox2CatchNewTab, false);
        getBrowser().tabContainer.addEventListener("TabClose", ShowcaseCache.firefox2CatchDestroyTab, false);
      } else {
  	  getBrowser().mPanelContainer.addEventListener("DOMNodeInserted", ShowcaseCache.catchNewTab, false);
  	  getBrowser().mPanelContainer.addEventListener("DOMNodeRemoved", ShowcaseCache.catchDestroyTab, false);
      }

        var totalTabs = getBrowser().tabContainer.childNodes.length;
        for (var d=0; d<totalTabs; d++) {
		var currentShowcaseTabCache = new ShowcaseTabCache(getBrowser().getBrowserForTab(getBrowser().tabContainer.childNodes.item(d)));
            currentShowcaseTabCache.makeThumbnail();
	  }
        ShowcaseCache.isCaching = true;
	},

	onUnload: function() {
      if(typeof BrowserOpenAddonsMgr == "function") {
        getBrowser().tabContainer.removeEventListener("TabOpen", ShowcaseCache.firefox2CatchNewTab, false);
        getBrowser().tabContainer.removeEventListener("TabClose", ShowcaseCache.firefox2CatchDestroyTab, false);
      } else {
        getBrowser().mPanelContainer.removeEventListener("DOMNodeInserted", ShowcaseCache.catchNewTab, false);
        getBrowser().mPanelContainer.removeEventListener("DOMNodeRemoved", ShowcaseCache.catchDestroyTab, false);
      }

      /*#if seamonkey*/
	Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranchInternal).removeObserver("extensions.showcase.", this);
      /*#else*/
	Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch2).removeObserver("extensions.showcase.", this);
      /*#endif*/

      if (ShowcaseCache.isCaching) {
        ShowcaseCache.disableCaching();
	}
     },

     disableCaching: function() {
        if (!ShowcaseCache.isCaching) return;
        var totalTabs = getBrowser().tabContainer.childNodes.length;
        for (var d=0; d<totalTabs; d++) {
		var browser = getBrowser().getBrowserForTab(getBrowser().tabContainer.childNodes.item(d));
           if (browser.showcaseCache) {
             browser.showcaseCache.unload();
           }
       }
       ShowcaseCache.isCaching = false;
     },

     addShowcase: function(newShowcase) {
       ShowcaseCache.currentShowcases.push(newShowcase);
     },

     removeShowcase: function(targetShowcase) {
       var targetIndex = ShowcaseCache.currentShowcases.indexOf(targetShowcase);

       if (targetIndex > -1) {
         ShowcaseCache.currentShowcases.splice(targetIndex, 1);
       }
     }
};

window.addEventListener("load", function(e) { ShowcaseCache.onLoad(); }, false);
window.addEventListener("unload", function(e) { ShowcaseCache.onUnload(); }, false);
/*
function debugLog(msg) {
  var consoleService = Components.classes["@mozilla.org/consoleservice;1"]
                                 .getService(Components.interfaces.nsIConsoleService);
  consoleService.logStringMessage(msg);
}
*/
