function shortcutsPrefInit() {
  var extensionManager;
  var keyconfigExtension;
  
  /*#if seamonkey*/
  var NSIFILE = Components.interfaces.nsIFile;
  var dirLocator = Components.classes["@mozilla.org/file/directory_service;1"]
                             .getService(Components.interfaces.nsIProperties);
  var userChromePath = dirLocator.get("UChrm", NSIFILE).path;
  var file = Components.classes["@mozilla.org/file/local;1"]
                       .createInstance(Components.interfaces.nsILocalFile);
  file.initWithPath(userChromePath);
  file.append("keyconfig.jar");
  if(file.exists()) {
    keyconfigExtension = new Object();
    keyconfigExtension.type = 2;
  }
  if ((!keyconfigExtension) || (keyconfigExtension.type == 0)) {
    keyConfigNotPresent();
  } else {
    keyConfigIsPresent();
  }
  /*#else*/
  try {
   
    extensionManager = Components.classes["@mozilla.org/extensions/manager;1"]
                       .getService(Components.interfaces.nsIExtensionManager);
    keyconfigExtension = extensionManager.getItemForID("keyconfig@dorando");
  
    // If it fails, try with old id
    if ((!keyconfigExtension) || (keyconfigExtension.type == 0)) {
      keyconfigExtension = extensionManager.getItemForID("{c8500d90-d72d-11d9-8cd5-0800200c9a66}");
    }
    if ((!keyconfigExtension) || (keyconfigExtension.type == 0)) {
      keyConfigNotPresent();
    } else {
      keyConfigIsPresent();
    }
  } catch (e) {
    // Exception, probably in Firefox 4
    Components.utils.import("resource://gre/modules/AddonManager.jsm");    
      
    AddonManager.getAddonByID("keyconfig@dorando", function(addon) {  
        keyConfigIsPresent();
    }); 
    AddonManager.getAddonByID("{c8500d90-d72d-11d9-8cd5-0800200c9a66}", function(addon) {
        keyConfigIsPresent();
    }); 
  }
  /*#endif*/
}

function keyConfigNotPresent() {
  var shortcutsPanelDeck = document.getElementById("shortcutsPanelDeck");
  shortcutsPanelDeck.setAttribute("selectedIndex", 0);
}

function keyConfigIsPresent() {
  var shortcutsPanelDeck = document.getElementById("shortcutsPanelDeck");
  var xmlDoc = document.implementation.createDocument("", "keyconfig", null);
  xmlDoc.async = false;
  try {
    xmlDoc.load("chrome://keyconfig/content/");
    if (xmlDoc.documentElement) {
      // Enabled
      shortcutsPanelDeck.setAttribute("selectedIndex", 2);
    } else {
      // Disabled
      shortcutsPanelDeck.setAttribute("selectedIndex", 1);
    }
  } catch (e) {
    // Exception while loading, so it's disabled
      shortcutsPanelDeck.setAttribute("selectedIndex", 1);
  }
}

function callKeyConfig(createWindowIfNecessary) {
  // Target all windows
  var wm = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
  var windowIter = wm.getEnumerator('navigator:browser');
  var keyconfigInvoked = false;

  while (windowIter.hasMoreElements() && !keyconfigInvoked) {
    var currentWindow = windowIter.getNext();
    try {
      currentWindow.openDialog('chrome://keyconfig/content/', 'keyconfig', 'resizable');
      keyconfigInvoked = true;
    } catch (e) { }
  }
  
  if (!keyconfigInvoked && createWindowIfNecessary) {
     openURL();
     setTimeout(callKeyConfig, 0, false);
  }
}
